/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomTriangleMesh;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Point3f;

public class MeshEditor {
    public static void smooth(CustomTriangleMesh customTriangleMesh, float f) {
        List list = customTriangleMesh.getMesh();
        if (0 != list.size() % 3) {
            System.out.println("MeshEditor.smooth: need a list of points multiple of 3.");
            return;
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < list.size(); i += 3) {
            Object object = (Point3f)list.get(i);
            Point3f point3f = (Point3f)list.get(i + 1);
            Point3f point3f2 = (Point3f)list.get(i + 2);
            MeshEditor.build((Point3f)object, point3f, point3f2, hashtable);
            MeshEditor.build(point3f, point3f2, (Point3f)object, hashtable);
            MeshEditor.build(point3f2, (Point3f)object, point3f, hashtable);
        }
        for (Object object : hashtable.values()) {
            ((PointGroup)object).smoothMembers(f);
        }
    }

    private static void build(Point3f point3f, Point3f point3f2, Point3f point3f3, Hashtable hashtable) {
        PointGroup pointGroup = (PointGroup)hashtable.get(point3f);
        if (null != pointGroup) {
            pointGroup.addMember(point3f);
        } else {
            pointGroup = new PointGroup(point3f);
            hashtable.put(point3f, pointGroup);
        }
        pointGroup.addEdge(point3f2);
        pointGroup.addEdge(point3f3);
    }

    private static class PointGroup {
        Point3f first;
        HashSet edges = new HashSet();
        ArrayList members = new ArrayList();
        float vx;
        float vy;
        float vz;

        PointGroup(Point3f point3f) {
            this.first = point3f;
            this.members.add(point3f);
        }

        void addMember(Point3f point3f) {
            this.members.add(point3f);
        }

        void addEdge(Point3f point3f) {
            this.edges.add(point3f);
        }

        void smoothMembers(float f) {
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.vz = 0.0f;
            for (Object object : this.edges) {
                this.vx += ((Point3f)object).x;
                this.vy += ((Point3f)object).y;
                this.vz += ((Point3f)object).z;
            }
            int n = this.edges.size();
            this.vx = (this.vx / (float)n - this.first.x) * f;
            this.vy = (this.vy / (float)n - this.first.y) * f;
            this.vz = (this.vz / (float)n - this.first.z) * f;
            for (Point3f point3f : this.members) {
                point3f.x += this.vx;
                point3f.y += this.vy;
                point3f.z += this.vz;
            }
        }

        void computeVector(float f) {
            this.vx = 0.0f;
            this.vy = 0.0f;
            this.vz = 0.0f;
            for (Point3f point3f : this.edges) {
                this.vx += point3f.x;
                this.vy += point3f.y;
                this.vz += point3f.z;
            }
            int n = this.edges.size();
            this.vx = (this.vx / (float)n - this.first.x) * f;
            this.vy = (this.vy / (float)n - this.first.y) * f;
            this.vz = (this.vz / (float)n - this.first.z) * f;
        }

        void applyVector(Hashtable hashtable) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n = 0;
            Iterator iterator = this.edges.iterator();
            while (iterator.hasNext()) {
                PointGroup pointGroup = (PointGroup)hashtable.get(iterator.next());
                if (null == pointGroup) continue;
                ++n;
                f += pointGroup.vx;
                f2 += pointGroup.vy;
                f3 += pointGroup.vz;
            }
            f += this.vx;
            f2 += this.vy;
            f3 += this.vz;
            f /= (float)(++n);
            f2 /= (float)n;
            f3 /= (float)n;
            for (PointGroup pointGroup : this.members) {
                ((Point3f)pointGroup).x += this.vx;
                ((Point3f)pointGroup).y += this.vy;
                ((Point3f)pointGroup).z += this.vz;
            }
        }
    }
}

