/*
 * Decompiled with CFR 0.152.
 */
package isosurface;

import customnode.CustomMesh;
import customnode.CustomMeshNode;
import ij.IJ;
import ij.gui.YesNoCancelDialog;
import ij.io.SaveDialog;
import ij3d.Content;
import isosurface.MeshGroup;
import java.awt.Frame;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;

public class MeshExporter {
    private static int mat_index = 1;

    private MeshExporter() {
    }

    private static Collection filterMeshes(Collection collection) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        for (Content content : collection) {
            if (!(content.getContent() instanceof CustomMeshNode) && !(content.getContent() instanceof MeshGroup)) continue;
            arrayList.add(content);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsWaveFront(Collection collection) {
        String string;
        String string2;
        if (null == collection || 0 == collection.size()) {
            return;
        }
        if (0 == (collection = MeshExporter.filterMeshes(collection)).size()) {
            IJ.log((String)"No meshes to export!");
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save WaveFront", "untitled", ".obj");
        String string3 = saveDialog.getDirectory();
        if (null == string3) {
            return;
        }
        if (IJ.isWindows()) {
            string3 = string3.replace('\\', '/');
        }
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        if (!(string2 = saveDialog.getFileName()).toLowerCase().endsWith(".obj")) {
            string2 = string2 + ".obj";
        }
        File file = new File(string3 + "/" + string2);
        if (!IJ.isMacOSX() && file.exists() && !(string = new YesNoCancelDialog((Frame)IJ.getInstance(), "Overwrite?", "File  " + string2 + " exists!\nOverwrite?")).yesPressed()) {
            return;
        }
        string = string2.substring(0, string2.lastIndexOf(46)) + ".mtl";
        OutputStreamWriter outputStreamWriter = null;
        OutputStreamWriter outputStreamWriter2 = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "8859_1");
            outputStreamWriter2 = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(string3 + "/" + string))), "8859_1");
            MeshExporter.writeAsWaveFront(collection, string, outputStreamWriter, outputStreamWriter2);
            outputStreamWriter.flush();
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            IJ.log((String)("Some error ocurred while saving to wavefront:\n" + iOException));
            iOException.printStackTrace();
        }
        finally {
            try {
                if (null != outputStreamWriter) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != outputStreamWriter2) {
                    outputStreamWriter2.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsDXF(Collection collection) {
        OutputStreamWriter outputStreamWriter;
        String string;
        if (null == collection || 0 == collection.size()) {
            return;
        }
        if (0 == (collection = MeshExporter.filterMeshes(collection)).size()) {
            IJ.log((String)"No meshes to export!");
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save as DXF", "untitled", ".dxf");
        String string2 = saveDialog.getDirectory();
        if (null == string2) {
            return;
        }
        if (IJ.isWindows()) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        if (!(string = saveDialog.getFileName()).toLowerCase().endsWith(".dxf")) {
            string = string + ".dxf";
        }
        File file = new File(string2 + "/" + string);
        if (!IJ.isMacOSX() && file.exists() && !(outputStreamWriter = new YesNoCancelDialog((Frame)IJ.getInstance(), "Overwrite?", "File  " + string + " exists!\nOverwrite?")).yesPressed()) {
            return;
        }
        outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), "8859_1");
            MeshExporter.writeDXF(collection, outputStreamWriter);
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (null != outputStreamWriter) {
                    outputStreamWriter.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void writeDXF(Collection collection, Writer writer) throws IOException {
        writer.write("0\nSECTION\n2\nENTITIES\n");
        for (Content content : collection) {
            Object object;
            CustomMesh customMesh = null;
            if (content.getContent() instanceof CustomMeshNode) {
                object = (CustomMeshNode)content.getContent();
                customMesh = object.getMesh();
            } else {
                if (!(content.getContent() instanceof MeshGroup)) continue;
                object = (MeshGroup)content.getContent();
                customMesh = ((MeshGroup)((Object)object)).getMesh();
            }
            object = customMesh.getMesh();
            String string = content.getName().replaceAll(" ", "_").replaceAll("#", "--");
            Mtl mtl = new Mtl(1.0f - content.getTransparency(), customMesh.getColor());
            MeshExporter.writeTrianglesDXF(writer, (List)object, string, "" + mtl.getAsSingle());
        }
        writer.append("0\nENDSEC\n0\nEOF\n");
    }

    @Deprecated
    public static String createDXF(Collection collection) {
        StringWriter stringWriter = new StringWriter();
        try {
            MeshExporter.writeDXF(collection, stringWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    @Deprecated
    public static void writeTrianglesDXF(StringBuffer stringBuffer, List list, String string, String string2) {
        try {
            StringWriter stringWriter = new StringWriter();
            MeshExporter.writeTrianglesDXF(stringWriter, list, string, string2);
            stringBuffer.append(stringWriter.getBuffer());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void writeTrianglesDXF(Writer writer, List list, String string, String string2) throws IOException {
        String string3 = "0\n3DFACE\n8\n" + string + "\n6\nCONTINUOUS\n62\n" + string2 + '\n';
        int n = list.size();
        Point3f[] point3fArray = new Point3f[n];
        list.toArray(point3fArray);
        StringBuffer stringBuffer = new StringBuffer(150);
        for (int i = 0; i < n; i += 3) {
            writer.write(string3);
            stringBuffer.append("10\n").append(point3fArray[i].x).append('\n').append("20\n").append(point3fArray[i].y).append('\n').append("30\n").append(point3fArray[i].z).append('\n').append("11\n").append(point3fArray[i + 1].x).append('\n').append("21\n").append(point3fArray[i + 1].y).append('\n').append("31\n").append(point3fArray[i + 1].z).append('\n').append("12\n").append(point3fArray[i + 2].x).append('\n').append("22\n").append(point3fArray[i + 2].y).append('\n').append("32\n").append(point3fArray[i + 2].z).append('\n').append("13\n").append(point3fArray[i + 2].x).append('\n').append("23\n").append(point3fArray[i + 2].y).append('\n').append("33\n").append(point3fArray[i + 2].z).append('\n');
            writer.write(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
    }

    @Deprecated
    public static String[] createWaveFront(Collection collection, String string) {
        StringWriter stringWriter = new StringWriter();
        StringWriter stringWriter2 = new StringWriter();
        try {
            MeshExporter.writeAsWaveFront(collection, string, stringWriter, stringWriter2);
            return new String[]{stringWriter.toString(), stringWriter2.toString()};
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void writeAsWaveFront(Collection collection, String string, Writer writer, Writer writer2) throws IOException {
        writer.write("# OBJ File\n");
        writer.write("mtllib ");
        writer.write(string);
        writer.write(10);
        Hashtable<Mtl, Mtl> hashtable = new Hashtable<Mtl, Mtl>();
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer(100);
        for (Object object : collection) {
            Object object2;
            int n2 = ((Content)object).getType();
            CustomMesh customMesh = null;
            if (((Content)object).getContent() instanceof CustomMeshNode) {
                object2 = (CustomMeshNode)((Content)object).getContent();
                customMesh = ((CustomMeshNode)((Object)object2)).getMesh();
            } else {
                if (!(((Content)object).getContent() instanceof MeshGroup)) continue;
                object2 = (MeshGroup)((Content)object).getContent();
                customMesh = ((MeshGroup)((Object)object2)).getMesh();
            }
            object2 = customMesh.getMesh();
            Mtl mtl = new Mtl(1.0f - ((Content)object).getTransparency(), customMesh.getColor());
            Object v = hashtable.get(mtl);
            if (null != v) {
                mtl = (Mtl)v;
            } else {
                hashtable.put(mtl, mtl);
            }
            String string2 = ((Content)object).getName().replaceAll(" ", "_").replaceAll("#", "--");
            Hashtable<Point3f, Integer> hashtable2 = new Hashtable<Point3f, Integer>();
            writer.write("o ");
            writer.write(string2);
            writer.write(10);
            int n3 = object2.size();
            int[] nArray = new int[n3];
            if (0 != n3 % 3) {
                System.out.println("WARNING: list of triangles not multiple of 3");
            }
            int n4 = 0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Point3f point3f = (Point3f)iterator.next();
                Object v2 = hashtable2.get(point3f);
                if (null != v2) {
                    nArray[n4] = (Integer)v2;
                } else {
                    nArray[n4] = n;
                    hashtable2.put(point3f, new Integer(n));
                    stringBuffer.append('v').append(' ').append(point3f.x).append(' ').append(point3f.y).append(' ').append(point3f.z).append('\n');
                    writer.write(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    ++n;
                }
                ++n4;
            }
            writer.write("usemtl ");
            writer.write(mtl.name);
            writer.write(10);
            writer.write("s 1\n");
            int n5 = hashtable2.size();
            for (int i = 0; i < n3; i += 3) {
                stringBuffer.append('f').append(' ').append(nArray[i]).append(' ').append(nArray[i + 1]).append(' ').append(nArray[i + 2]).append('\n');
                writer.write(stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            writer.write(10);
        }
        writer2.write("# MTL File\n");
        for (Object object : hashtable.keySet()) {
            StringBuffer stringBuffer2 = new StringBuffer(150);
            ((Mtl)object).fill(stringBuffer2);
            writer2.write(stringBuffer2.toString());
        }
    }

    public static boolean saveToFile(File file, String string) {
        if (null == file) {
            return false;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(file), string.length()), "8859_1");
            outputStreamWriter.write(string, 0, string.length());
            outputStreamWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            IJ.showMessage((String)"ERROR: Most likely did NOT save your file.");
            return false;
        }
        return true;
    }

    private static class Mtl {
        float alpha = 1.0f;
        float R = 1.0f;
        float G = 1.0f;
        float B = 1.0f;
        String name;

        Mtl(float f, Color3f color3f) {
            this.alpha = f;
            float[] fArray = new float[3];
            color3f.get(fArray);
            this.R = fArray[0];
            this.G = fArray[1];
            this.B = fArray[2];
            this.name = "mat_" + mat_index;
            mat_index++;
        }

        Mtl(float f, float f2, float f3, float f4) {
            this.alpha = f;
            this.R = f2;
            this.G = f3;
            this.B = f4;
            this.name = "mat_" + mat_index;
            mat_index++;
        }

        public boolean equals(Object object) {
            if (object instanceof Mtl) {
                Mtl mtl = (Mtl)object;
                if (mtl.alpha == this.alpha && mtl.R == this.R && mtl.G == this.G && mtl.B == this.B) {
                    return true;
                }
            }
            return false;
        }

        void fill(StringBuffer stringBuffer) {
            stringBuffer.append("\nnewmtl ").append(this.name).append('\n').append("Ns 96.078431\n").append("Ka 0.0 0.0 0.0\n").append("Kd ").append(this.R).append(' ').append(this.G).append(' ').append(this.B).append('\n').append("Ks 0.5 0.5 0.5\n").append("Ni 1.0\n").append("d ").append(this.alpha).append('\n').append("illum 2\n\n");
        }

        int getAsSingle() {
            return (int)((this.R + this.G + this.B / 3.0f) * 255.0f);
        }
    }
}

