/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import math3d.Point3d;
import pal.math.MultivariateFunction;
import util.CombinationGenerator;
import util.Overlay_Registered;
import vib.FastMatrix;
import vib.TransformedImage;
import vib.oldregistration.RegistrationAlgorithm;
import vib.transforms.OrderedTransformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Affine_From_Landmarks
extends RegistrationAlgorithm
implements PlugIn {
    OrderedTransformations transformation;
    boolean allowScaling;
    public static final boolean tryOptimizing = false;

    static double scoreFromAllLandmarks(OrderedTransformations orderedTransformations, ArrayList<String> arrayList, NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        double d = 0.0;
        ListIterator<String> listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            NamedPointWorld namedPointWorld;
            String string = (String)listIterator.next();
            NamedPointWorld namedPointWorld2 = null;
            NamedPointWorld namedPointWorld3 = null;
            Object object = namedPointSet.listIterator();
            while (object.hasNext()) {
                namedPointWorld = (NamedPointWorld)object.next();
                if (!string.equals(namedPointWorld.getName())) continue;
                namedPointWorld2 = namedPointWorld;
                break;
            }
            object = namedPointSet2.listIterator();
            while (object.hasNext()) {
                namedPointWorld = (NamedPointWorld)object.next();
                if (!string.equals(namedPointWorld.getName())) continue;
                namedPointWorld3 = namedPointWorld;
                break;
            }
            object = new double[3];
            orderedTransformations.apply(namedPointWorld3.x, namedPointWorld3.y, namedPointWorld3.z, (double[])object);
            double d2 = Math.sqrt((double)((object[0] - namedPointWorld2.x) * (object[0] - namedPointWorld2.x) + (object[1] - namedPointWorld2.y) * (object[1] - namedPointWorld2.y) + (object[2] - namedPointWorld2.z) * (object[2] - namedPointWorld2.z)));
            d += d2 * d2;
        }
        return d / (double)arrayList.size();
    }

    public static FastMatrix generateAffine(NamedPointWorld namedPointWorld, NamedPointWorld namedPointWorld2, NamedPointWorld namedPointWorld3, NamedPointWorld namedPointWorld4, NamedPointWorld namedPointWorld5, NamedPointWorld namedPointWorld6, NamedPointWorld namedPointWorld7, NamedPointWorld namedPointWorld8) {
        double[][] dArray = new double[3][4];
        dArray[0][0] = namedPointWorld2.x - namedPointWorld.x;
        dArray[0][1] = namedPointWorld3.x - namedPointWorld.x;
        dArray[0][2] = namedPointWorld4.x - namedPointWorld.x;
        dArray[1][0] = namedPointWorld2.y - namedPointWorld.y;
        dArray[1][1] = namedPointWorld3.y - namedPointWorld.y;
        dArray[1][2] = namedPointWorld4.y - namedPointWorld.y;
        dArray[2][0] = namedPointWorld2.z - namedPointWorld.z;
        dArray[2][1] = namedPointWorld3.z - namedPointWorld.z;
        dArray[2][2] = namedPointWorld4.z - namedPointWorld.z;
        double[][] dArray2 = new double[3][4];
        dArray2[0][0] = namedPointWorld6.x - namedPointWorld5.x;
        dArray2[0][1] = namedPointWorld7.x - namedPointWorld5.x;
        dArray2[0][2] = namedPointWorld8.x - namedPointWorld5.x;
        dArray2[1][0] = namedPointWorld6.y - namedPointWorld5.y;
        dArray2[1][1] = namedPointWorld7.y - namedPointWorld5.y;
        dArray2[1][2] = namedPointWorld8.y - namedPointWorld5.y;
        dArray2[2][0] = namedPointWorld6.z - namedPointWorld5.z;
        dArray2[2][1] = namedPointWorld7.z - namedPointWorld5.z;
        dArray2[2][2] = namedPointWorld8.z - namedPointWorld5.z;
        FastMatrix fastMatrix = new FastMatrix(dArray);
        FastMatrix fastMatrix2 = new FastMatrix(dArray2);
        FastMatrix fastMatrix3 = fastMatrix2.times(fastMatrix.inverse());
        fastMatrix3.apply(namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
        double d = namedPointWorld5.x - fastMatrix3.x;
        double d2 = namedPointWorld5.y - fastMatrix3.y;
        double d3 = namedPointWorld5.z - fastMatrix3.z;
        FastMatrix fastMatrix4 = FastMatrix.translate(d, d2, d3).times(fastMatrix3);
        return fastMatrix4;
    }

    public void run(String string) {
        String string2;
        ImagePlus imagePlus;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"Affine_From_Landmarks: No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            imagePlus = WindowManager.getImage((int)nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        stringArray[nArray.length] = string2 = "*None*";
        imagePlus = new GenericDialog("Affine Registration from Landmarks");
        imagePlus.addChoice("Template stack:", stringArray, stringArray[0]);
        imagePlus.addChoice("Stack to transform:", stringArray, stringArray[1]);
        imagePlus.addCheckbox("Overlay result", true);
        imagePlus.showDialog();
        if (imagePlus.wasCanceled()) {
            return;
        }
        int[] nArray2 = new int[]{imagePlus.getNextChoiceIndex(), imagePlus.getNextChoiceIndex()};
        this.setImages(WindowManager.getImage((int)nArray[nArray2[0]]), WindowManager.getImage((int)nArray[nArray2[1]]));
        boolean bl = imagePlus.getNextBoolean();
        ImagePlus imagePlus2 = this.register();
        if (bl) {
            ImagePlus imagePlus3 = Overlay_Registered.overlayToImagePlus(this.sourceImages[0], imagePlus2);
            imagePlus3.setTitle("Registered and Overlayed");
            imagePlus3.show();
        } else {
            imagePlus2.show();
        }
    }

    public static double evaluateFastMatrix(FastMatrix fastMatrix, NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        if (namedPointSet.size() != namedPointSet2.size()) {
            throw new RuntimeException("In evaluateFastMatrix, 'from' (size " + namedPointSet.size() + ") and 'to' (size " + namedPointSet2.size() + ") must be equal");
        }
        double d = 0.0;
        int n = namedPointSet.size();
        for (int i = 0; i < n; ++i) {
            NamedPointWorld namedPointWorld = namedPointSet.get(i);
            NamedPointWorld namedPointWorld2 = namedPointSet2.get(i);
            if (!namedPointWorld.name.equals(namedPointWorld2.name)) {
                throw new RuntimeException("In evaluateFastMatrix, point index " + i + " has a name mismatch: fromPoint = " + namedPointWorld + ", toPoint = " + namedPointWorld2);
            }
            fastMatrix.apply(namedPointWorld.x, namedPointWorld.y, namedPointWorld.z);
            double d2 = fastMatrix.x - namedPointWorld2.x;
            double d3 = fastMatrix.y - namedPointWorld2.y;
            double d4 = fastMatrix.z - namedPointWorld2.z;
            d += Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        }
        return d / (double)n;
    }

    public static FastMatrix bestBetweenPoints(NamedPointSet namedPointSet, ImagePlus imagePlus, NamedPointSet namedPointSet2, ImagePlus imagePlus2) {
        int n;
        Calibration calibration;
        ArrayList<String> arrayList = namedPointSet.namesSharedWith(namedPointSet2, true);
        int n2 = arrayList.size();
        if (n2 < 4) {
            String string = "There are fewer than 4 points in these two images that have been marked up with the same names:";
            if (n2 == 0) {
                string = string + " (none in common)";
            } else {
                Iterator<String> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = string + "\n    " + iterator.next();
                }
            }
            IJ.error((String)string);
            return null;
        }
        NamedPointSet namedPointSet3 = new NamedPointSet();
        NamedPointSet namedPointSet4 = new NamedPointSet();
        for (String string : arrayList) {
            namedPointSet4.add(namedPointSet.get(string));
            namedPointSet3.add(namedPointSet2.get(string));
        }
        Object object = new int[n2];
        for (int i = 0; i < n2; ++i) {
            object[i] = i;
        }
        CombinationGenerator combinationGenerator = new CombinationGenerator(n2, 4);
        FastMatrix fastMatrix = null;
        double d = Double.MAX_VALUE;
        double d2 = combinationGenerator.getTotal().doubleValue();
        if (d2 > 1024.0) {
            IJ.error((String)"There are over 1024 combinations; you probablyshouldn't be using this method.");
        }
        double d3 = Double.MIN_VALUE;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        double d8 = 1.0;
        double d9 = 1.0;
        Calibration calibration2 = imagePlus.getCalibration();
        if (calibration2 != null) {
            d4 = calibration2.pixelWidth;
            d5 = calibration2.pixelHeight;
            d6 = calibration2.pixelDepth;
        }
        if ((calibration = imagePlus2.getCalibration()) != null) {
            d7 = calibration.pixelWidth;
            d8 = calibration.pixelHeight;
            d9 = calibration.pixelDepth;
        }
        double[] dArray = new double[]{Math.abs((double)imagePlus.getWidth() * d4), Math.abs((double)imagePlus.getHeight() * d5), Math.abs((double)imagePlus.getStackSize() * d6), Math.abs((double)imagePlus2.getWidth() * d7), Math.abs((double)imagePlus2.getHeight() * d8), Math.abs((double)imagePlus2.getStackSize() * d9)};
        for (n = 0; n < 6; ++n) {
            if (!(dArray[n] > d3)) continue;
            d3 = dArray[n];
        }
        IJ.showProgress((double)0.0);
        n = 0;
        while (combinationGenerator.hasMore()) {
            int[] nArray = combinationGenerator.getNext();
            FastMatrix fastMatrix2 = Affine_From_Landmarks.generateAffine(namedPointSet3.get(nArray[0]), namedPointSet3.get(nArray[1]), namedPointSet3.get(nArray[2]), namedPointSet3.get(nArray[3]), namedPointSet4.get(nArray[0]), namedPointSet4.get(nArray[1]), namedPointSet4.get(nArray[2]), namedPointSet4.get(nArray[3]));
            double d10 = Affine_From_Landmarks.evaluateFastMatrix(fastMatrix2, namedPointSet3, namedPointSet4);
            if (d10 < d) {
                d = d10;
                fastMatrix = fastMatrix2;
            }
            Point3d[] point3dArray = new Point3d[4];
            Point3d[] point3dArray2 = new Point3d[4];
            for (int i = 0; i < 4; ++i) {
                NamedPointWorld namedPointWorld = namedPointSet3.get(nArray[i]);
                NamedPointWorld namedPointWorld2 = namedPointSet4.get(nArray[i]);
                point3dArray[i] = namedPointWorld.toPoint3d();
                point3dArray2[i] = namedPointWorld2.toPoint3d();
            }
            IJ.showProgress((double)((double)(++n) / d2));
        }
        IJ.showProgress((double)1.0);
        return fastMatrix;
    }

    @Override
    public ImagePlus register() {
        NamedPointSet namedPointSet = null;
        NamedPointSet namedPointSet2 = null;
        try {
            namedPointSet = NamedPointSet.forImage(this.sourceImages[0]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("Failed to find a corresponding points file for: " + this.sourceImages[0].getTitle()));
        }
        try {
            namedPointSet2 = NamedPointSet.forImage(this.sourceImages[1]);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            IJ.error((String)("Failed to find a corresponding points file for: " + this.sourceImages[1].getTitle()));
        }
        return this.register(namedPointSet, namedPointSet2);
    }

    @Override
    public ImagePlus register(NamedPointSet namedPointSet, NamedPointSet namedPointSet2) {
        FastMatrix fastMatrix = Affine_From_Landmarks.bestBetweenPoints(namedPointSet, this.sourceImages[0], namedPointSet2, this.sourceImages[1]);
        TransformedImage transformedImage = new TransformedImage(this.sourceImages[0], this.sourceImages[1]);
        transformedImage.setTransformation(fastMatrix);
        ImagePlus imagePlus = transformedImage.getTransformed();
        imagePlus.setTitle("Transformed");
        return imagePlus;
    }

    public static class CandidateAffine
    implements MultivariateFunction {
        FastMatrix m = new FastMatrix();
        NamedPointSet from;
        NamedPointSet to;
        double bestScore = Double.MAX_VALUE;
        double[] bestArgument = new double[12];
        double sizeOfLargestDimension;

        public CandidateAffine(NamedPointSet namedPointSet, NamedPointSet namedPointSet2, double d) {
            this.from = namedPointSet;
            this.to = namedPointSet2;
            this.sizeOfLargestDimension = d;
        }

        public double evaluate(double[] dArray) {
            double[] dArray2 = (double[])dArray.clone();
            dArray2[3] = dArray2[3] * this.sizeOfLargestDimension;
            dArray2[7] = dArray2[7] * this.sizeOfLargestDimension;
            dArray2[11] = dArray2[11] * this.sizeOfLargestDimension;
            this.m.setFromFlatDoubleArray(dArray2);
            double d = Affine_From_Landmarks.evaluateFastMatrix(this.m, this.from, this.to);
            if (d < this.bestScore) {
                this.bestScore = d;
                System.arraycopy(dArray, 0, this.bestArgument, 0, 12);
            }
            return d;
        }

        public int getNumArguments() {
            return 12;
        }

        public double getLowerBound(int n) {
            return -1.0;
        }

        public double getUpperBound(int n) {
            return 1.0;
        }
    }
}

