/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import landmarks.FineTuneProgressListener;
import landmarks.Name_Points;
import landmarks.NamedPointWorld;
import landmarks.ProgressWindow;
import landmarks.RegistrationResult;
import landmarks.TransformationAttempt;
import pal.math.ConjugateDirectionSearch;

public class FineTuneThread
extends Thread {
    boolean keepResults = true;
    int method;
    double cubeSide;
    ImagePlus croppedTemplate;
    ImagePlus template;
    NamedPointWorld templatePoint;
    ImagePlus newImage;
    NamedPointWorld guessedPoint;
    double[] initialTransformation;
    double[] guessedTransformation;
    ProgressWindow progressWindow;
    FineTuneProgressListener listener;
    ConjugateDirectionSearch optimizer;
    boolean pleaseStop = false;

    public void setInitialTransformation(double[] dArray) {
        if (dArray.length != 6) {
            throw new RuntimeException("initialTransformation passed to FineTuneThread must be 6 in length");
        }
        this.initialTransformation = dArray;
    }

    public FineTuneThread(int n, double d, ImagePlus imagePlus, ImagePlus imagePlus2, NamedPointWorld namedPointWorld, ImagePlus imagePlus3, NamedPointWorld namedPointWorld2, double[] dArray, double[] dArray2, ProgressWindow progressWindow, FineTuneProgressListener fineTuneProgressListener) {
        this.method = n;
        this.cubeSide = d;
        this.croppedTemplate = imagePlus;
        this.template = imagePlus2;
        this.templatePoint = namedPointWorld;
        this.newImage = imagePlus3;
        this.guessedPoint = namedPointWorld2;
        if (dArray != null && dArray.length != 6) {
            throw new RuntimeException("initialTransformation passed to FineTuneThread must be 6 in length");
        }
        this.initialTransformation = dArray;
        if (dArray2 != null && dArray2.length != 6) {
            throw new RuntimeException("guessedTransformation passed to FineTuneThread must be 6 in length, if non-null");
        }
        this.guessedTransformation = dArray2;
        this.progressWindow = progressWindow;
        this.listener = fineTuneProgressListener;
    }

    public void run() {
        double[] dArray = (double[])this.initialTransformation.clone();
        this.optimizer = new ConjugateDirectionSearch();
        this.optimizer.step = 1.0;
        this.optimizer.scbd = 10.0;
        this.optimizer.illc = true;
        TransformationAttempt transformationAttempt = new TransformationAttempt(this.cubeSide, this.croppedTemplate, this.templatePoint, this.newImage, this.guessedPoint, this.method, this.listener, this.progressWindow);
        this.optimizer.optimize(transformationAttempt, dArray, 2.0, 2.0);
        if (this.pleaseStop) {
            this.listener.fineTuneThreadFinished(2, null, this);
            return;
        }
        if (this.pleaseStop) {
            this.listener.fineTuneThreadFinished(2, null, this);
            return;
        }
        RegistrationResult registrationResult = Name_Points.mapImageWith(this.croppedTemplate, this.newImage, this.templatePoint, this.guessedPoint, dArray, this.cubeSide, this.method, "score: ");
        this.listener.fineTuneThreadFinished(1, registrationResult, this);
    }

    public void askToFinish() {
        this.pleaseStop = true;
        if (this.optimizer != null) {
            this.optimizer.interrupt = true;
        }
    }
}

