/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import math3d.Point3d;
import tracing.PathAndFillManager;
import vib.FastMatrix;
import vib.transforms.OrderedTransformations;

public class NamedPointWorld {
    public double x;
    public double y;
    public double z;
    public boolean set;
    String name;

    public NamedPointWorld(String string, double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.name = string;
        this.set = true;
    }

    public NamedPointWorld(String string) {
        this.name = string;
        this.set = false;
    }

    public NamedPointWorld transformWith(FastMatrix fastMatrix) {
        fastMatrix.apply(this.x, this.y, this.z);
        return new NamedPointWorld(this.name, fastMatrix.x, fastMatrix.y, fastMatrix.z);
    }

    public NamedPointWorld transformWith(OrderedTransformations orderedTransformations) {
        double[] dArray = new double[3];
        orderedTransformations.apply(this.x, this.y, this.z, dArray);
        return new NamedPointWorld(this.name, dArray[0], dArray[1], dArray[2]);
    }

    public static String escape(String string) {
        String string2 = string.replaceAll("\\\\", "\\\\\\\\");
        string2 = string2.replaceAll("\\\"", "\\\\\"");
        return string2;
    }

    public static String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2;
        while ((n2 = stringBuffer.indexOf(string, n)) >= 0) {
            stringBuffer.deleteCharAt(n2);
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    public Point3d toPoint3d() {
        return new Point3d(this.x, this.y, this.z);
    }

    public String getName() {
        return this.name;
    }

    public String toXMLElement() {
        StringBuffer stringBuffer = new StringBuffer("<pointworld set=\"");
        stringBuffer.append(this.set);
        stringBuffer.append("\" name=\"");
        stringBuffer.append(PathAndFillManager.escapeForXMLAttributeValue(this.name));
        stringBuffer.append("\"");
        if (this.set) {
            stringBuffer.append(" x=\"");
            stringBuffer.append(this.x);
            stringBuffer.append("\" y=\"");
            stringBuffer.append(this.y);
            stringBuffer.append("\" z=\"");
            stringBuffer.append(this.z);
            stringBuffer.append("\"");
        }
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public String toYAML() {
        if (this.set) {
            return "\"" + NamedPointWorld.escape(this.name) + "\": [ " + this.x + ", " + this.y + ", " + this.z + " ]";
        }
        return "\"" + NamedPointWorld.escape(this.name) + "\":";
    }

    public String toString() {
        if (this.set) {
            return "\"" + this.name + "\" at " + this.x + ", " + this.y + ", " + this.z;
        }
        return "\"" + this.name + "\" [not set]";
    }

    public void setName(String string) {
        this.name = string;
    }

    public void unset() {
        this.set = false;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public void set(double d, double d2, double d3) {
        this.set = true;
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public String toIGS() {
        return "landmark {\n\tname \"" + NamedPointWorld.escape(this.name) + "\"\n\tlocation " + this.x + " " + this.y + " " + this.z + "\n}";
    }
}

