/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;

public class ProgressCanvas
extends ImageCanvas {
    protected ImagePlus imagePlus;
    int fixed_x;
    int fixed_y;
    int fixed_z;
    int transformed_x;
    int transformed_y;
    int transformed_z;
    boolean drawFixed = false;
    boolean drawTransformed = false;

    public ProgressCanvas(ImagePlus imagePlus) {
        super(imagePlus);
        this.imagePlus = imagePlus;
    }

    protected void drawOverlay(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.imagePlus.getCurrentSlice() - 1;
        if (this.drawFixed && this.fixed_z == n5) {
            n4 = this.screenX(this.fixed_x);
            n3 = this.screenY(this.fixed_y);
            n2 = this.screenX(this.fixed_x + 1) - n4;
            n = this.screenY(this.fixed_y + 1) - n3;
            this.drawCrosshairs(graphics, Color.magenta, n4 + n2 / 2, n3 + n / 2);
        }
        if (this.drawTransformed && this.transformed_z == n5) {
            n4 = this.screenX(this.transformed_x);
            n3 = this.screenY(this.transformed_y);
            n2 = this.screenX(this.transformed_x + 1) - n4;
            n = this.screenY(this.transformed_y + 1) - n3;
            this.drawCrosshairs(graphics, Color.green, n4 + n2 / 2, n3 + n / 2);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawOverlay(graphics);
    }

    protected void drawCrosshairs(Graphics graphics, Color color, int n, int n2) {
        graphics.setColor(color);
        int n3 = 8;
        graphics.drawLine(n, n2 + 1, n, n2 + (n3 - 1));
        graphics.drawLine(n, n2 - 1, n, n2 - (n3 - 1));
        graphics.drawLine(n + 1, n2, n + (n3 - 1), n2);
        graphics.drawLine(n - 1, n2, n - (n3 - 1), n2);
    }

    public void setCrosshairs(int n, int n2, int n3, boolean bl) {
        System.out.println("Setting crosshairs (fixed: " + bl + ") to " + n + "," + n2 + "," + n3);
        if (bl) {
            this.fixed_x = n;
            this.fixed_y = n2;
            this.fixed_z = n3;
            this.drawFixed = true;
        } else {
            this.transformed_x = n;
            this.transformed_y = n2;
            this.transformed_z = n3;
            this.drawTransformed = true;
        }
    }
}

