/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import landmarks.FineTuneThread;
import landmarks.Name_Points;
import landmarks.ProgressCanvas;
import landmarks.RegistrationResult;

public class ProgressWindow
extends StackWindow
implements ActionListener {
    int width;
    int height;
    int depth;
    DecimalFormat scoreFormatter;
    DecimalFormat distanceFormatter;
    Name_Points plugin;
    ArrayList<FineTuneThread> fineTuneThreads;
    Button useThis;
    Button cancel;
    Button refineBestSoFar;
    Label lowestScore;
    Label triedSoFar;
    Button moveToRefinedPoint;
    Button moveToOriginalPoint;
    Label distanceMoved;
    RegistrationResult bestSoFar;
    boolean useTheResult = true;
    protected ProgressCanvas progressCanvas;
    boolean notShowingBest = true;
    long timeLastProgressUpdate = 0L;

    void updateLowestScore(double d) {
        this.lowestScore.setText("Score: " + this.scoreFormatter.format(d));
    }

    void updateTriedSoFar(int n, int n2) {
        this.triedSoFar.setText("Seeds tried: " + n + " / " + n2);
    }

    void updateDistance(double d, String string) {
        this.distanceMoved.setText("Moved: " + this.scoreFormatter.format(d) + " " + string);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.useThis || object == this.cancel) {
            this.cancel.setEnabled(false);
            this.useThis.setEnabled(false);
            if (object == this.useThis) {
                this.useTheResult = true;
                this.triedSoFar.setText("Finishing...");
                this.plugin.stopFineTuneThreads();
            } else if (object == this.cancel) {
                this.useTheResult = false;
                this.triedSoFar.setText("Cancelling...");
                this.plugin.stopFineTuneThreads();
            }
            this.close();
        } else if (object == this.moveToOriginalPoint) {
            this.imp.setSlice(this.progressCanvas.fixed_z + 1);
        } else if (object == this.moveToRefinedPoint) {
            this.imp.setSlice(this.progressCanvas.transformed_z + 1);
        }
    }

    void startThreads() {
        for (FineTuneThread fineTuneThread : this.fineTuneThreads) {
            fineTuneThread.start();
        }
    }

    public ProgressWindow(ImagePlus imagePlus) {
        super(imagePlus);
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
        this.scoreFormatter = new DecimalFormat("0.0000");
        this.distanceFormatter = new DecimalFormat("0.00");
    }

    public ProgressWindow(ImagePlus imagePlus, ImageCanvas imageCanvas, Name_Points name_Points) {
        super(imagePlus, imageCanvas);
        ImageCanvas imageCanvas2 = this.getCanvas();
        this.progressCanvas = imageCanvas2 != null && imageCanvas instanceof ProgressCanvas ? (ProgressCanvas)imageCanvas : null;
        this.plugin = name_Points;
        this.useThis = new Button("Use This");
        this.cancel = new Button("Cancel");
        this.lowestScore = new Label("Score: (none yet)");
        this.triedSoFar = new Label("No attempts so far.");
        this.useThis.addActionListener(this);
        this.cancel.addActionListener(this);
        this.add(this.useThis);
        this.add(this.cancel);
        this.add(this.lowestScore);
        this.add(this.triedSoFar);
        this.moveToRefinedPoint = new Button("Goto refined point");
        this.moveToOriginalPoint = new Button("Goto original guess");
        this.moveToRefinedPoint.addActionListener(this);
        this.moveToOriginalPoint.addActionListener(this);
        this.add(this.moveToRefinedPoint);
        this.add(this.moveToOriginalPoint);
        this.distanceMoved = new Label("Moved:");
        this.add(this.distanceMoved);
        this.pack();
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
        this.scoreFormatter = new DecimalFormat("0.0000");
    }

    synchronized void showBest() {
        int n;
        RegistrationResult registrationResult = this.bestSoFar;
        ImageStack imageStack = this.imp.getStack();
        int n2 = this.imp.getCurrentSlice();
        boolean bl = false;
        if (imageStack.getSize() == 1) {
            bl = true;
        }
        int n3 = (registrationResult.overlay_width - this.width) / 2;
        int n4 = (registrationResult.overlay_height - this.height) / 2;
        for (n = 0; n < registrationResult.overlay_depth; ++n) {
            ColorProcessor colorProcessor;
            byte[] byArray = new byte[this.width * this.height];
            byte[] byArray2 = new byte[this.width * this.height];
            for (int i = 0; i < registrationResult.overlay_height; ++i) {
                for (int j = 0; j < registrationResult.overlay_width; ++j) {
                    int n5 = j - n3;
                    int n6 = i - n4;
                    if (n5 < 0 || n6 < 0 || n5 >= this.width || n6 >= this.height) continue;
                    byArray[n6 * this.width + n5] = registrationResult.transformed_bytes[n][i * registrationResult.overlay_width + j];
                    byArray2[n6 * this.width + n5] = registrationResult.fixed_bytes[n][i * registrationResult.overlay_width + j];
                }
            }
            if (n < this.depth) {
                colorProcessor = (ColorProcessor)imageStack.getProcessor(n + 1);
                colorProcessor.setRGB(byArray, byArray2, byArray);
                continue;
            }
            colorProcessor = new ColorProcessor(this.width, this.height);
            colorProcessor.setRGB(byArray, byArray2, byArray);
            imageStack.addSlice("", (ImageProcessor)colorProcessor);
        }
        for (n = this.depth - 1; n >= registrationResult.overlay_depth; --n) {
            imageStack.deleteSlice(n + 1);
        }
        this.depth = registrationResult.overlay_depth;
        this.progressCanvas.setCrosshairs(registrationResult.fixed_point_x - n3, registrationResult.fixed_point_y - n4, registrationResult.fixed_point_z, true);
        this.progressCanvas.setCrosshairs(registrationResult.transformed_point_x - n3, registrationResult.transformed_point_y - n4, registrationResult.transformed_point_z, false);
        this.updateDistance(registrationResult.pointMoved, this.plugin.templateUnits);
        n = n2;
        if (bl) {
            n = this.depth / 2;
        }
        if (n >= this.depth) {
            n = this.depth - 1;
        }
        this.imp.setSlice(n + 1);
        if (bl) {
            this.pack();
        }
        this.imp.updateAndRepaintWindow();
        this.repaint();
        this.notShowingBest = false;
    }

    public synchronized void offerNewResult(RegistrationResult registrationResult) {
        long l = System.currentTimeMillis();
        long l2 = l - this.timeLastProgressUpdate;
        if (this.bestSoFar == null || registrationResult.score < this.bestSoFar.score) {
            this.bestSoFar = registrationResult;
            this.updateLowestScore(registrationResult.score);
            this.notShowingBest = true;
            System.out.println("Found a better one: " + registrationResult.score);
            if (this.timeLastProgressUpdate == 0L || l2 > 1000L) {
                System.out.println("Yeah, it's been " + (double)l2 / 1000.0 + "seconds.");
                this.showBest();
                this.timeLastProgressUpdate = l;
            }
        }
        if (l2 > 5000L && this.notShowingBest) {
            this.timeLastProgressUpdate = l;
            this.showBest();
        }
    }
}

