/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;
import org.junit.Assert;
import org.junit.Test;
import util.BatchOpener;

public class TestLoading {
    @Test
    public void testLoadingXML() {
        NamedPointSet namedPointSet = new NamedPointSet();
        namedPointSet.add(new NamedPointWorld("the centre of the ellipsoid body", 295.00580720092915, 157.95586527293844, 91.85064935064935));
        namedPointSet.add(new NamedPointWorld("the top of the left alpha lobe of the mushroom body"));
        namedPointSet.add(new NamedPointWorld("the top of the right alpha lobe of the mushroom body", 360.04645760743324, 72.00929152148665, 100.81168831168831));
        namedPointSet.add(new NamedPointWorld("the left tip of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the right tip of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most dorsal point of the left part of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most dorsal point of the right part of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most lateral part of the mushroom body on the left"));
        namedPointSet.add(new NamedPointWorld("the most lateral part of the mushroom body on the right"));
        NamedPointSet namedPointSet2 = null;
        try {
            namedPointSet2 = NamedPointSet.fromFile("test-images/CantonF41c-reduced.tif.points.xml");
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet2.equals(namedPointSet));
        try {
            namedPointSet2 = NamedPointSet.forImage("test-images/CantonF41c-reduced.tif");
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet2.equals(namedPointSet));
        ImagePlus imagePlus = BatchOpener.openFirstChannel("test-images/CantonF41c-reduced.tif");
        try {
            namedPointSet2 = NamedPointSet.forImage(imagePlus);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet2.equals(namedPointSet));
    }

    @Test
    public void testLoadingTSV() {
        NamedPointSet namedPointSet = new NamedPointSet();
        namedPointSet.add(new NamedPointWorld("the centre of the ellipsoid body"));
        namedPointSet.add(new NamedPointWorld("the left tip of the protocerebral bridge", 329.31556348952125, 182.13852265821257, 62.983801242131975));
        namedPointSet.add(new NamedPointWorld("the right tip of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most dorsal point of the left part of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most dorsal point of the right part of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the top of the left alpha lobe of the mushroom body"));
        namedPointSet.add(new NamedPointWorld("the top of the right alpha lobe of the mushroom body", 302.32248451497037, 55.90390299410485, 28.792594853546046));
        namedPointSet.add(new NamedPointWorld("the most lateral part of the mushroom body on the left"));
        namedPointSet.add(new NamedPointWorld("the most lateral part of the mushroom body on the right"));
        NamedPointSet namedPointSet2 = null;
        try {
            namedPointSet2 = NamedPointSet.fromFile("test-images/tidied-mhl-62yxUAS-lacZ0-reduced.tif.points.R");
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet2.equals(namedPointSet));
        try {
            namedPointSet2 = NamedPointSet.forImage("test-images/tidied-mhl-62yxUAS-lacZ0-reduced.tif");
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet2.equals(namedPointSet));
        ImagePlus imagePlus = BatchOpener.openFirstChannel("test-images/tidied-mhl-62yxUAS-lacZ0-reduced.tif");
        try {
            namedPointSet2 = NamedPointSet.forImage(imagePlus);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet2.equals(namedPointSet));
    }

    @Test
    public void testLoadingPseudoYAML() {
        NamedPointSet namedPointSet = new NamedPointSet();
        namedPointSet.add(new NamedPointWorld("the centre of the ellipsoid body", 76.71103997439151, 130.92786521945018, 81.6));
        namedPointSet.add(new NamedPointWorld("the left tip of the protocerebral bridge", 106.12655154351908, 155.72917889538127, 14.399999999999999));
        namedPointSet.add(new NamedPointWorld("the right tip of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most dorsal point of the left part of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the most dorsal point of the right part of the protocerebral bridge"));
        namedPointSet.add(new NamedPointWorld("the top of the left alpha lobe of the mushroom body"));
        namedPointSet.add(new NamedPointWorld("the top of the right alpha lobe of the mushroom body"));
        namedPointSet.add(new NamedPointWorld("the most lateral part of the mushroom body on the left"));
        namedPointSet.add(new NamedPointWorld("the most lateral part of the mushroom body on the right"));
        NamedPointSet namedPointSet2 = new NamedPointSet();
        namedPointSet2.add(new NamedPointWorld("the centre of the ellipsoid body", 266.0, 454.0, 68.0));
        namedPointSet2.add(new NamedPointWorld("the left tip of the protocerebral bridge", 368.0, 540.0, 12.0));
        namedPointSet2.add(new NamedPointWorld("the right tip of the protocerebral bridge"));
        namedPointSet2.add(new NamedPointWorld("the most dorsal point of the left part of the protocerebral bridge"));
        namedPointSet2.add(new NamedPointWorld("the most dorsal point of the right part of the protocerebral bridge"));
        namedPointSet2.add(new NamedPointWorld("the top of the left alpha lobe of the mushroom body"));
        namedPointSet2.add(new NamedPointWorld("the top of the right alpha lobe of the mushroom body"));
        namedPointSet2.add(new NamedPointWorld("the most lateral part of the mushroom body on the left"));
        namedPointSet2.add(new NamedPointWorld("the most lateral part of the mushroom body on the right"));
        NamedPointSet namedPointSet3 = null;
        try {
            namedPointSet3 = NamedPointSet.forImage("test-images/71yAAeastmost.labels");
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet3.equals(namedPointSet));
        ImagePlus imagePlus = BatchOpener.openFirstChannel("test-images/71yAAeastmost.labels");
        try {
            namedPointSet3 = NamedPointSet.forImage(imagePlus);
        }
        catch (NamedPointSet.PointsFileException pointsFileException) {
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((boolean)namedPointSet3.equals(namedPointSet));
    }
}

