/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import ij.ImagePlus;
import ij.measure.Calibration;
import landmarks.FineTuneProgressListener;
import landmarks.Name_Points;
import landmarks.NamedPointWorld;
import landmarks.ProgressWindow;
import landmarks.RegistrationResult;
import pal.math.MultivariateFunction;

public class TransformationAttempt
implements MultivariateFunction {
    double cubeSide;
    ImagePlus croppedTemplate;
    NamedPointWorld templatePoint;
    ImagePlus newImage;
    NamedPointWorld guessedPoint;
    ProgressWindow progressWindow;
    double minTranslation;
    double maxTranslation;
    int similarityMeasure;
    FineTuneProgressListener listener;

    public TransformationAttempt(double d, ImagePlus imagePlus, NamedPointWorld namedPointWorld, ImagePlus imagePlus2, NamedPointWorld namedPointWorld2, int n, FineTuneProgressListener fineTuneProgressListener, ProgressWindow progressWindow) {
        this.cubeSide = d;
        this.croppedTemplate = imagePlus;
        this.templatePoint = namedPointWorld;
        this.newImage = imagePlus2;
        this.guessedPoint = namedPointWorld2;
        this.listener = fineTuneProgressListener;
        this.progressWindow = progressWindow;
        this.similarityMeasure = n;
        this.minTranslation = -d;
        Calibration calibration = imagePlus2.getCalibration();
        this.maxTranslation = 0.0;
        double d2 = (double)imagePlus2.getWidth() * calibration.pixelWidth;
        double d3 = (double)imagePlus2.getHeight() * calibration.pixelHeight;
        double d4 = (double)imagePlus2.getStackSize() * calibration.pixelDepth;
        if (d2 > this.maxTranslation) {
            this.maxTranslation = d2;
        }
        if (d3 > this.maxTranslation) {
            this.maxTranslation = d3;
        }
        if (d4 > this.maxTranslation) {
            this.maxTranslation = d4;
        }
        this.maxTranslation += d;
    }

    public double evaluate(double[] dArray) {
        RegistrationResult registrationResult = Name_Points.mapImageWith(this.croppedTemplate, this.newImage, this.templatePoint, this.guessedPoint, dArray, this.cubeSide, this.similarityMeasure, "");
        if (this.listener != null) {
            this.listener.fineTuneNewBestResult(registrationResult);
        }
        return registrationResult.score;
    }

    public int getNumArguments() {
        return 6;
    }

    public double getLowerBound(int n) {
        if (n >= 0 && n <= 2) {
            return Math.PI * -4;
        }
        return this.minTranslation;
    }

    public double getUpperBound(int n) {
        if (n >= 0 && n <= 2) {
            return Math.PI * 4;
        }
        return this.maxTranslation;
    }
}

