/*
 * Decompiled with CFR 0.152.
 */
package leica;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class Leica_SP_Writer
implements PlugInFilter {
    ImagePlus image;
    int channels;

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 131;
    }

    public void run(ImageProcessor imageProcessor) {
        Object object;
        Calibration calibration;
        Object object2;
        ImageStack imageStack;
        GenericDialog genericDialog = new GenericDialog("Number of channels");
        genericDialog.addNumericField("channels", 2.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.channels = (int)genericDialog.getNextNumber();
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        int n3 = this.image.getStack() != null ? this.image.getStack().getSize() : 1;
        ArrayList arrayList = new ArrayList();
        int n4 = WindowManager.getImageCount();
        for (int i = 0; i < n4; ++i) {
            ImagePlus imagePlus = WindowManager.getImage((int)(i + 1));
            if (imagePlus == this.image) {
                if (i > 0) {
                    arrayList.add(arrayList.get(0));
                    arrayList.set(0, imagePlus);
                    continue;
                }
                arrayList.add(imagePlus);
                continue;
            }
            imageStack = imagePlus.getStack();
            if (imagePlus.getWidth() != n || imagePlus.getHeight() != n2 || (imageStack != null || n3 != 1) && imageStack.getSize() != n3) continue;
            arrayList.add(imagePlus);
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            imageStack = (ImagePlus)arrayList.get(i);
            stringArray[i] = imageStack.getTitle();
        }
        GenericDialog genericDialog2 = new GenericDialog("Channels");
        for (int i = 0; i < this.channels; ++i) {
            genericDialog2.addChoice("image" + i, stringArray, stringArray[0]);
        }
        genericDialog2.showDialog();
        if (genericDialog2.wasCanceled()) {
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save Leica SP", stringArray[0], ".tif");
        if (saveDialog.getFileName() == null) {
            return;
        }
        String string = saveDialog.getDirectory() + File.separator + saveDialog.getFileName();
        ImageStack imageStack2 = new ImageStack(n, n2);
        Calibration calibration2 = this.image.getCalibration();
        for (int i = 0; i < this.channels; ++i) {
            int n5 = genericDialog2.getNextChoiceIndex();
            object2 = (ImagePlus)arrayList.get(n5);
            calibration = object2.getCalibration();
            if (!(calibration2.pixelWidth == calibration.pixelWidth && calibration2.pixelHeight == calibration.pixelHeight && calibration2.pixelDepth == calibration.pixelDepth && calibration2.xOrigin == calibration.xOrigin && calibration2.yOrigin == calibration.yOrigin && calibration2.zOrigin == calibration.zOrigin || IJ.showMessageWithCancel((String)"Mismatch", (String)("The dimensions of " + object2.getTitle() + "do not match. " + "Continue?")))) {
                return;
            }
            object = object2.getStack();
            for (int j = 0; j < n3; ++j) {
                imageStack2.addSlice("", object.getProcessor(j + 1));
            }
        }
        ImagePlus imagePlus = new ImagePlus("", imageStack2);
        imagePlus.setCalibration(calibration2);
        FileInfo fileInfo = imagePlus.getFileInfo();
        fileInfo.nImages = n3 * this.channels;
        fileInfo.description = "[GLOBAL]\n[FILTERSETTING1]\nNumOfVisualisations=" + this.channels + "\n" + "NumOfFrames=" + n3 + "\n" + "VoxelSizeX=" + calibration2.pixelWidth + "\n" + "VoxelSizeY=" + calibration2.pixelHeight + "\n" + "VoxelSizeZ=" + calibration2.pixelDepth + "\n" + (fileInfo.description == null ? "" : fileInfo.description);
        object2 = this.image.getProperty("Info");
        if (object2 != null && object2 instanceof String) {
            fileInfo.info = (String)object2;
        }
        try {
            calibration = new TiffEncoder(fileInfo);
            object = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string)));
            calibration.write((DataOutputStream)object);
            ((FilterOutputStream)object).close();
        }
        catch (IOException iOException) {
            IJ.error((String)("Could not write " + string));
            return;
        }
    }
}

