/*
 * Decompiled with CFR 0.152.
 */
package marchingcubes;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import marchingcubes.MCTriangulator;

public class ExportMesh_
implements PlugIn {
    public void exportToMesh(ImagePlus imagePlus, int n, int n2, boolean[] blArray, String string) {
        MCTriangulator mCTriangulator = new MCTriangulator();
        List list = mCTriangulator.getTriangles(imagePlus, n, blArray, n2);
        if (list.size() % 3 != 0) {
            IJ.error((String)"There weren't a multiple of 3 entries in the mesh List");
            return;
        }
        Hashtable<Point3f, Integer> hashtable = new Hashtable<Point3f, Integer>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n4 = 0;
        for (Object object : list) {
            Integer n32 = (Integer)hashtable.get(object);
            if (null != n32) continue;
            hashtable.put((Point3f)object, new Integer(n4));
            arrayList.add(object);
            ++n4;
        }
        try {
            Object object;
            PrintStream printStream = new PrintStream(string);
            printStream.println("# Almost the simplest possible Wavefront .obj file.");
            printStream.println("# Generated by the ExportMesh_ plugin in ImageJ.");
            for (Point3f point3f : arrayList) {
                printStream.println("v " + point3f.x + " " + point3f.y + " " + point3f.z);
            }
            printStream.println("s 1");
            object = list.iterator();
            while (object.hasNext()) {
                Point3f point3f = (Point3f)object.next();
                Point3f point3f2 = (Point3f)object.next();
                Point3f point3f3 = (Point3f)object.next();
                int n3 = (Integer)hashtable.get(point3f) + 1;
                int n5 = (Integer)hashtable.get(point3f2) + 1;
                int n6 = (Integer)hashtable.get(point3f3) + 1;
                printStream.println("f " + n3 + " " + n5 + " " + n6);
            }
        }
        catch (IOException iOException) {
            IJ.error((String)("Saving to '" + string + "' failed: " + iOException));
            return;
        }
    }

    public void run(String string) {
        Object object;
        String string2;
        SaveDialog saveDialog;
        Calibration calibration;
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"ExportMesh: No images are open.");
            return;
        }
        if (nArray.length < 1) {
            IJ.error((String)"ExportMesh: No images are open.");
            return;
        }
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            ImagePlus imagePlus = WindowManager.getImage((int)nArray[i]);
            stringArray[i] = imagePlus != null ? imagePlus.getTitle() : "";
        }
        GenericDialog genericDialog = new GenericDialog("Triangulate");
        genericDialog.addChoice("Stack:", stringArray, stringArray[0]);
        genericDialog.addNumericField("Threshold", 50.0, 0);
        genericDialog.addNumericField("Resampling factor", 2.0, 0);
        genericDialog.addMessage("Channels");
        genericDialog.addCheckboxGroup(1, 3, new String[]{"red", "green", "blue"}, new boolean[]{true, true, true});
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = genericDialog.getNextChoiceIndex();
        ImagePlus imagePlus = WindowManager.getImage((int)nArray[n]);
        int n2 = (int)genericDialog.getNextNumber();
        int n3 = (int)genericDialog.getNextNumber();
        boolean[] blArray = new boolean[]{genericDialog.getNextBoolean(), genericDialog.getNextBoolean(), genericDialog.getNextBoolean()};
        if (imagePlus == null) {
            IJ.error((String)"Must select a currently open image");
            return;
        }
        Vector3f vector3f = new Vector3f();
        if (imagePlus != null) {
            calibration = imagePlus.getCalibration();
            vector3f.x = (float)((double)(-imagePlus.getWidth()) * calibration.pixelWidth / 2.0);
            vector3f.y = (float)((double)(-imagePlus.getHeight()) * calibration.pixelHeight / 2.0);
            vector3f.z = (float)((double)(-imagePlus.getStackSize()) * calibration.pixelDepth / 2.0);
        }
        if ((calibration = imagePlus.getOriginalFileInfo()) == null) {
            saveDialog = new SaveDialog("Save mesh as...", "mesh.obj", ".obj");
        } else {
            string2 = calibration.fileName;
            object = calibration.directory;
            String string3 = string2 + ".obj";
            saveDialog = new SaveDialog("Save mesh as...", (String)object, string3, ".obj");
        }
        if (saveDialog.getFileName() == null) {
            return;
        }
        string2 = saveDialog.getDirectory() + saveDialog.getFileName();
        object = new File(string2);
        if (object != null && ((File)object).exists() && !IJ.showMessageWithCancel((String)"Save traces file...", (String)("The file " + string2 + " already exists.\n" + "Do you want to replace it?"))) {
            return;
        }
        IJ.showStatus((String)("Saving label annotations to " + string2));
        this.exportToMesh(imagePlus, n2, n3, blArray, string2);
    }
}

