/*
 * Decompiled with CFR 0.152.
 */
package marchingcubes;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij3d.Volume;
import isosurface.Triangulator;
import java.util.List;
import javax.vecmath.Point3f;
import marchingcubes.MCCube;
import vib.Resample_;

public class MCTriangulator
implements Triangulator {
    public List getTriangles(ImagePlus imagePlus, int n, boolean[] blArray, int n2) {
        if (n2 != 1) {
            imagePlus = Resample_.resample(imagePlus, n2);
        }
        Volume volume = new Volume(imagePlus, blArray);
        volume.setAverage(true);
        List<Point3f> list = MCCube.getTriangles(volume, n);
        return list;
    }

    public static void zeroPad(ImagePlus imagePlus) {
        ImageStack imageStack = imagePlus.getStack();
        int n = imageStack.getWidth();
        int n2 = imageStack.getHeight();
        int n3 = imageStack.getSize();
        int n4 = imagePlus.getType();
        ImageStack imageStack2 = new ImageStack(n + 2, n2 + 2);
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        ImageProcessor imageProcessor2 = MCTriangulator.createProcessor(n + 2, n2 + 2, n4);
        imageStack2.addSlice("", imageProcessor2);
        for (int i = 0; i < n3; ++i) {
            imageProcessor = imageStack.getProcessor(i + 1);
            imageProcessor2 = MCTriangulator.createProcessor(n + 2, n2 + 2, n4);
            imageProcessor2.insert(imageProcessor, 1, 1);
            imageStack2.addSlice(Integer.toString(i + 1), imageProcessor2);
        }
        imageProcessor2 = MCTriangulator.createProcessor(n + 2, n2 + 2, n4);
        imageStack2.addSlice(Integer.toString(n3 + 1), imageProcessor2);
        imagePlus.setStack(null, imageStack2);
        Calibration calibration = imagePlus.getCalibration();
        calibration.xOrigin -= calibration.pixelWidth;
        calibration.yOrigin -= calibration.pixelHeight;
        calibration.zOrigin -= calibration.pixelDepth;
        imagePlus.setCalibration(calibration);
    }

    private static final ImageProcessor createProcessor(int n, int n2, int n3) {
        if (n3 == 4) {
            return new ColorProcessor(n, n2);
        }
        return new ByteProcessor(n, n2);
    }
}

