/*
 * Decompiled with CFR 0.152.
 */
package math3d;

public class Eigensystem3x3Float {
    float[][] m;
    float[] eigenVectors;
    float[] eigenValues;

    public Eigensystem3x3Float(float[][] fArray) {
        this.m = fArray;
        if (this.m[0][1] != this.m[1][0] || this.m[0][2] != this.m[2][0] || this.m[1][2] != this.m[2][1]) {
            throw new RuntimeException("Eigensystem3x3Float only works with symmetric matrices");
        }
    }

    public void getEvalues(float[] fArray) {
        fArray[0] = this.eigenValues[0];
        fArray[1] = this.eigenValues[1];
        fArray[2] = this.eigenValues[2];
    }

    public float[] getEvaluesCopy() {
        return (float[])this.eigenValues.clone();
    }

    public float[] getEvalues() {
        return this.eigenValues;
    }

    public boolean findEvalues() {
        this.eigenValues = new float[3];
        double d = -1.0;
        double d2 = this.m[0][1];
        double d3 = this.m[0][2];
        double d4 = this.m[1][2];
        double d5 = this.m[0][0];
        double d6 = this.m[1][1];
        double d7 = this.m[2][2];
        double d8 = d2 * d2 + d3 * d3 + d4 * d4 - d5 * d6 - d5 * d7 - d6 * d7;
        double d9 = d5 + d6 + d7;
        double d10 = (3.0 * d * d8 - d9 * d9) / (9.0 * d * d);
        double d11 = d5 * d6 * d7 - d5 * d4 * d4 - d2 * d2 * d7 + 2.0 * d2 * d3 * d4 - d3 * d3 * d6;
        double d12 = (9.0 * d * d9 * d8 - 27.0 * d * d * d11 - 2.0 * d9 * d9 * d9) / (54.0 * d * d * d);
        double d13 = d10 * d10 * d10 + d12 * d12;
        if (d13 > 0.0) {
            return false;
        }
        if (d13 < 0.0) {
            double d14 = 1.7320508075688772;
            double d15 = Math.sqrt(d12 * d12 - d13);
            double d16 = d12 > 0.0 ? Math.atan(Math.sqrt(-d13) / d12) : Math.PI - Math.atan(Math.sqrt(-d13) / -d12);
            double d17 = Math.pow(d15, 0.3333333333333333);
            double d18 = d16 / 3.0;
            double d19 = -d16 / 3.0;
            double d20 = 2.0 * d17 * Math.cos(d18);
            this.eigenValues[0] = (float)(d20 - d9 / (3.0 * d));
            double d21 = -(d20 / 2.0) - d9 / 3.0 * d;
            double d22 = -d14 * d17 * Math.sin(d18);
            this.eigenValues[1] = (float)(d21 + d22);
            this.eigenValues[2] = (float)(d21 - d22);
            return true;
        }
        double d23 = d12 >= 0.0 ? 2.0 * Math.pow(d12, 0.3333333333333333) : -2.0 * Math.pow(-d12, 0.3333333333333333);
        double d24 = d9 / (3.0 * d);
        this.eigenValues[0] = (float)(d23 - d24);
        this.eigenValues[1] = (float)(-d23 / 2.0 - d24);
        this.eigenValues[2] = this.eigenValues[1];
        return true;
    }
}

