/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import ij.IJ;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class FloatMatrixN {
    public static void invert(float[][] fArray) {
        FloatMatrixN.invert(fArray, false);
    }

    public static void invert(float[][] fArray, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = fArray.length;
        if (n4 != fArray[0].length) {
            throw new RuntimeException("invert: no square matrix");
        }
        float[][] fArray2 = new float[n4][n4];
        for (n3 = 0; n3 < n4; ++n3) {
            fArray2[n3][n3] = 1.0f;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5;
            if (bl) {
                IJ.showStatus((String)("invert matrix: " + n3 + "/" + 2 * n4));
            }
            n2 = n3;
            for (n5 = n3 + 1; n5 < n4; ++n5) {
                if (!(Math.abs(fArray[n5][n3]) > Math.abs(fArray[n2][n3]))) continue;
                n2 = n5;
            }
            if (n2 != n3) {
                float[] fArray3 = fArray[n2];
                fArray[n2] = fArray[n3];
                fArray[n3] = fArray3;
                fArray3 = fArray2[n2];
                fArray2[n2] = fArray2[n3];
                fArray2[n3] = fArray3;
            }
            if (fArray[n3][n3] != 1.0f) {
                float f = fArray[n3][n3];
                n = n3;
                while (n < n4) {
                    float[] fArray4 = fArray[n3];
                    int n6 = n++;
                    fArray4[n6] = fArray4[n6] / f;
                }
                n = 0;
                while (n < n4) {
                    float[] fArray5 = fArray2[n3];
                    int n7 = n++;
                    fArray5[n7] = fArray5[n7] / f;
                }
            }
            for (n5 = n3 + 1; n5 < n4; ++n5) {
                int n8;
                float f = fArray[n5][n3];
                for (n8 = n3; n8 < n4; ++n8) {
                    float[] fArray6 = fArray[n5];
                    int n9 = n8;
                    fArray6[n9] = fArray6[n9] - f * fArray[n3][n8];
                }
                for (n8 = 0; n8 < n4; ++n8) {
                    float[] fArray7 = fArray2[n5];
                    int n10 = n8;
                    fArray7[n10] = fArray7[n10] - f * fArray2[n3][n8];
                }
            }
        }
        for (n3 = n4 - 1; n3 > 0; --n3) {
            if (bl) {
                IJ.showStatus((String)("invert matrix: " + (2 * n4 - n3) + "/" + 2 * n4));
            }
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                float f = fArray[n2][n3] / fArray[n3][n3];
                for (n = n3; n < n4; ++n) {
                    float[] fArray8 = fArray[n2];
                    int n11 = n;
                    fArray8[n11] = fArray8[n11] - f * fArray[n3][n];
                }
                for (n = 0; n < n4; ++n) {
                    float[] fArray9 = fArray2[n2];
                    int n12 = n;
                    fArray9[n12] = fArray9[n12] - f * fArray2[n3][n];
                }
            }
        }
        for (n3 = 0; n3 < n4; ++n3) {
            fArray[n3] = fArray2[n3];
        }
    }

    public static float[][] clone(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(fArray[i], 0, fArray2[i], 0, n2);
        }
        return fArray2;
    }

    public static float[][] times(float[][] fArray, float[][] fArray2) {
        int n = fArray2.length;
        if (fArray[0].length != fArray2.length) {
            throw new RuntimeException("rank mismatch");
        }
        int n2 = fArray.length;
        int n3 = fArray2[0].length;
        float[][] fArray3 = new float[n2][n3];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n; ++k) {
                    float[] fArray4 = fArray3[i];
                    int n4 = j;
                    fArray4[n4] = fArray4[n4] + fArray[i][k] * fArray2[k][j];
                }
            }
        }
        return fArray3;
    }

    public static float[] times(float[][] fArray, float[] fArray2) {
        int n = fArray2.length;
        if (fArray[0].length != fArray2.length) {
            throw new RuntimeException("rank mismatch");
        }
        int n2 = fArray.length;
        float[] fArray3 = new float[n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i;
                fArray3[n3] = fArray3[n3] + fArray[i][j] * fArray2[j];
            }
        }
        return fArray3;
    }

    static float[][] LU_decomposition(float[][] fArray) {
        int n;
        int n2;
        int n3 = fArray.length;
        float[][] fArray2 = new float[n3][n3];
        float[][] fArray3 = new float[n3][n3];
        for (int i = 0; i < n3; ++i) {
            for (n2 = i; n2 < n3; ++n2) {
                fArray2[i][n2] = fArray[i][n2];
                for (n = 0; n < i; ++n) {
                    float[] fArray4 = fArray2[i];
                    int n4 = n2;
                    fArray4[n4] = fArray4[n4] - fArray3[i][n] * fArray2[n][n2];
                }
            }
            for (n2 = i + 1; n2 < n3; ++n2) {
                fArray3[n2][i] = fArray[n2][i];
                for (n = 0; n < i; ++n) {
                    float[] fArray5 = fArray3[n2];
                    int n5 = i;
                    fArray5[n5] = fArray5[n5] - fArray3[n2][n] * fArray2[n][i];
                }
                float[] fArray6 = fArray3[n2];
                int n6 = i;
                fArray6[n6] = fArray6[n6] / fArray2[i][i];
            }
        }
        float[][] fArray7 = new float[n3][n3];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n3; ++n) {
                fArray7[n2][n] = fArray3[n2][n] + fArray2[n2][n];
            }
        }
        return fArray7;
    }

    static float[][] choleskyDecomposition(float[][] fArray) {
        int n;
        if (fArray.length != fArray[0].length) {
            throw new RuntimeException("Row and column rank must be equal");
        }
        int n2 = fArray.length;
        float[][] fArray2 = new float[n2][n2];
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < n2; ++n) {
                fArray2[i][n] = 0.0f;
            }
        }
        float f = 0.0f;
        for (n = 0; n < n2; ++n) {
            int n3;
            f = 0.0f;
            for (n3 = 0; n3 < n; ++n3) {
                f += fArray2[n3][n] * fArray2[n3][n];
            }
            if (fArray[n][n] - f < 0.0f) {
                throw new RuntimeException("Matrix must be positive definite (trace is " + f + ", but diagonal element " + n + " is " + fArray[n][n] + ")");
            }
            fArray2[n][n] = (float)Math.sqrt(fArray[n][n] - f);
            for (n3 = n + 1; n3 < n2; ++n3) {
                f = 0.0f;
                for (int i = 0; i < n; ++i) {
                    f += fArray2[i][n3] * fArray2[i][n];
                }
                fArray2[n][n3] = (fArray[n][n3] - f) / fArray2[n][n];
            }
        }
        return fArray2;
    }

    public static float[][] transpose(float[][] fArray) {
        float[][] fArray2 = new float[fArray[0].length][fArray.length];
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < fArray2[i].length; ++j) {
                fArray2[i][j] = fArray[j][i];
            }
        }
        return fArray2;
    }

    public static float[] solve_UL(float[][] fArray, float[] fArray2) {
        float[][] fArray3 = FloatMatrixN.LU_decomposition(fArray);
        float[] fArray4 = new float[fArray2.length];
        for (int i = 0; i < fArray4.length; ++i) {
            float f = 0.0f;
            for (int j = 0; j < i; ++j) {
                f += fArray3[i][j] * fArray4[j];
            }
            fArray4[i] = fArray2[i] - f;
        }
        float[] fArray5 = new float[fArray2.length];
        for (int i = fArray5.length - 1; i >= 0; --i) {
            float f = 0.0f;
            for (int j = i + 1; j < fArray5.length; ++j) {
                f += fArray3[i][j] * fArray5[j];
            }
            fArray5[i] = (fArray4[i] - f) / fArray3[i][i];
        }
        return fArray5;
    }

    public static float[] solve_cholesky(float[][] fArray, float[] fArray2) {
        float[][] fArray3 = FloatMatrixN.choleskyDecomposition(fArray);
        fArray3 = FloatMatrixN.choleskyDecomposition(fArray);
        float[][] fArray4 = FloatMatrixN.transpose(fArray3);
        float[] fArray5 = FloatMatrixN.forward_substitution(fArray4, fArray2);
        float[] fArray6 = FloatMatrixN.backward_substitution(fArray3, fArray5);
        return fArray6;
    }

    private static float[] backward_substitution(float[][] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray2.length];
        for (int i = fArray3.length - 1; i >= 0; --i) {
            float f = 0.0f;
            for (int j = i + 1; j < fArray3.length; ++j) {
                f += fArray[i][j] * fArray3[j];
            }
            fArray3[i] = (fArray2[i] - f) / fArray[i][i];
        }
        return fArray3;
    }

    private static float[] forward_substitution(float[][] fArray, float[] fArray2) {
        float[] fArray3 = new float[fArray2.length];
        for (int i = 0; i < fArray3.length; ++i) {
            float f = 0.0f;
            for (int j = 0; j < i; ++j) {
                f += fArray[i][j] * fArray3[j];
            }
            fArray3[i] = (fArray2[i] - f) / fArray[i][i];
        }
        return fArray3;
    }

    public static float[] apply(float[][] fArray, float[] fArray2) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[] fArray3 = new float[fArray2.length];
        for (int i = 0; i < n; ++i) {
            fArray3[i] = 0.0f;
            for (int j = 0; j < n2; ++j) {
                int n3 = i;
                fArray3[n3] = fArray3[n3] + fArray[i][j] * fArray2[j];
            }
        }
        return fArray3;
    }

    public static void print(float[] fArray) {
        System.out.print("[");
        for (int i = 0; i < fArray.length; ++i) {
            System.out.print(fArray[i] + ", ");
        }
        System.out.print("]");
        System.out.println();
    }

    public static void print(float[][] fArray) {
        FloatMatrixN.print(fArray, System.out);
    }

    public static void print(float[][] fArray, PrintStream printStream, char c) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00f");
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = 0; j < fArray[i].length; ++j) {
                printStream.print(decimalFormat.format(fArray[i][j]) + c);
            }
            printStream.println("");
        }
        printStream.println();
    }

    public static float round(float f, int n, RoundingMode roundingMode) {
        BigDecimal bigDecimal = BigDecimal.valueOf(f);
        return bigDecimal.setScale(n, roundingMode).floatValue();
    }

    public static void print(float[][] fArray, PrintStream printStream) {
        FloatMatrixN.print(fArray, printStream, '\t');
    }

    public static void main(String[] stringArray) {
        float f = 1234.1234f;
        BigDecimal bigDecimal = BigDecimal.valueOf(f);
        System.out.println(bigDecimal.unscaledValue() + " " + bigDecimal.scale());
        int n = BigDecimal.valueOf(f).movePointLeft(2).unscaledValue().intValue() * 100;
        bigDecimal = bigDecimal.movePointLeft(2);
        System.out.println(bigDecimal.unscaledValue());
        System.out.println("Test rounding");
        float f2 = 1.2345679f;
        System.out.println("Math.round(" + f2 + ") = " + Math.round(f2));
        System.out.println("round(" + f2 + ",2) = " + FloatMatrixN.round(f2, 2, RoundingMode.HALF_EVEN));
        float[][] fArrayArray = new float[][]{{1.0f, 2.0f, 3.0f, 2.0f}, {-1.0f, 0.0f, 2.0f, -3.0f}, {-2.0f, 1.0f, 1.0f, 1.0f}, {0.0f, -2.0f, 3.0f, 0.0f}};
        float[][] fArray = FloatMatrixN.clone(fArrayArray);
        FloatMatrixN.invert(fArray);
        float[][] fArray2 = FloatMatrixN.times((float[][])fArrayArray, fArray);
        FloatMatrixN.print(fArray2);
        float[][] fArray3 = new float[5][5];
        for (int i = 0; i < fArray3.length; ++i) {
            for (int j = i; j < fArray3.length; ++j) {
                float f3 = 1.0f / (float)(i + j + 1);
                fArray3[j][i] = f3;
                fArray3[i][j] = f3;
            }
        }
        System.out.println("Original matrix ");
        FloatMatrixN.print(fArray3);
        float[][] fArray4 = FloatMatrixN.choleskyDecomposition(fArray3);
        System.out.println("Upper triangular form u of cholesky decomposition ");
        FloatMatrixN.print(fArray4);
        float[][] fArray5 = FloatMatrixN.transpose(fArray4);
        System.out.println("Transposed form u^T of u ");
        FloatMatrixN.print(fArray5);
        float[][] fArray6 = FloatMatrixN.times(fArray5, fArray4);
        System.out.println("Finally the product of the u^T and u, which should give the original matrix ");
        FloatMatrixN.print(fArray6);
        float[] fArray7 = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        System.out.println("A vector x: x = [1.0f 2.0f 3.0f]^T\n");
        float[] fArray8 = FloatMatrixN.apply(fArray3, fArray7);
        System.out.println("Applying the original matrix to x gives b: ");
        FloatMatrixN.print(fArray8);
        System.out.println("\n\nTest different solve methods");
        System.out.println("\nTest Cholesky decomposition");
        float[] fArray9 = FloatMatrixN.solve_cholesky(fArray3, fArray8);
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        FloatMatrixN.print(fArray9);
        System.out.println("\nTest LU decomposition");
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        fArray9 = FloatMatrixN.solve_UL(fArray3, fArray8);
        FloatMatrixN.print(fArray9);
        System.out.println("\nTest ordinary invert method");
        System.out.println("Now solve Ax = b for x and see if it is the original x");
        float[][] fArray10 = FloatMatrixN.clone(fArray3);
        FloatMatrixN.invert(fArray10);
        fArray9 = FloatMatrixN.apply(fArray10, fArray8);
        FloatMatrixN.print(fArray9);
    }
}

