/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.FloatMatrixN;

public class JacobiFloat {
    private float[][] matrix;
    private float[][] eigenmatrix;
    private float[] eigenvalues;
    private int numberOfRotationsNeeded;
    private int maxSweeps;

    public JacobiFloat(float[][] fArray) {
        this(fArray, 50);
    }

    public JacobiFloat(float[][] fArray, int n) {
        this.matrix = fArray;
        for (int i = 0; i < fArray.length; ++i) {
            for (int j = i + 1; j < fArray.length; ++j) {
                if (this.isSmallComparedTo(Math.abs(fArray[i][j] - fArray[j][i]), fArray[i][j])) continue;
                throw new RuntimeException("Matrix is not symmetric!");
            }
        }
        this.eigenmatrix = new float[fArray.length][fArray.length];
        this.eigenvalues = new float[fArray.length];
        this.maxSweeps = n;
        this.perform();
    }

    public float[][] getEigenVectors() {
        return FloatMatrixN.transpose(this.eigenmatrix);
    }

    public float[][] getEigenMatrix() {
        return this.eigenmatrix;
    }

    public float[] getEigenValues() {
        return this.eigenvalues;
    }

    public int getNumberOfRotations() {
        return this.numberOfRotationsNeeded;
    }

    private float offDiagonalSum() {
        float f = 0.0f;
        for (int i = 0; i < this.matrix.length - 1; ++i) {
            for (int j = i + 1; j < this.matrix.length; ++j) {
                f += Math.abs(this.matrix[i][j]);
            }
        }
        return f;
    }

    private void rotate(int n, int n2, int n3, int n4, float f, float f2) {
        float f3 = this.matrix[n][n2];
        float f4 = this.matrix[n3][n4];
        this.matrix[n][n2] = f3 - f * (f4 + f3 * f2);
        this.matrix[n3][n4] = f4 + f * (f3 - f4 * f2);
    }

    private void rotateEigenMatrix(int n, int n2, int n3, int n4, float f, float f2) {
        float f3 = this.eigenmatrix[n][n2];
        float f4 = this.eigenmatrix[n3][n4];
        this.eigenmatrix[n][n2] = f3 - f * (f4 + f3 * f2);
        this.eigenmatrix[n3][n4] = f4 + f * (f3 - f4 * f2);
    }

    private boolean isSmallComparedTo(float f, float f2) {
        return Math.abs(f2) + f == Math.abs(f2);
    }

    private void perform() {
        int n;
        float[] fArray = new float[this.matrix.length];
        float[] fArray2 = new float[this.matrix.length];
        for (n = 0; n < this.matrix.length; ++n) {
            for (int i = 0; i < this.matrix.length; ++i) {
                this.eigenmatrix[n][i] = 0.0f;
            }
            this.eigenmatrix[n][n] = 1.0f;
            fArray[n] = this.eigenvalues[n] = this.matrix[n][n];
            fArray2[n] = 0.0f;
        }
        this.numberOfRotationsNeeded = 0;
        for (n = 0; n < this.maxSweeps; ++n) {
            int n2;
            float f = this.offDiagonalSum();
            if (f == 0.0f) {
                return;
            }
            float f2 = 0.0f;
            if (n < 3) {
                f2 = 0.2f * f / (float)(this.matrix.length * this.matrix.length);
            }
            for (n2 = 0; n2 < this.matrix.length - 1; ++n2) {
                for (int i = n2 + 1; i < this.matrix.length; ++i) {
                    int n3;
                    float f3;
                    float f4;
                    float f5 = 100.0f * Math.abs(this.matrix[n2][i]);
                    if (n > 3 && this.isSmallComparedTo(f5, this.eigenvalues[n2]) && this.isSmallComparedTo(f5, this.eigenvalues[i])) {
                        this.matrix[n2][i] = 0.0f;
                        continue;
                    }
                    if (!(Math.abs(this.matrix[n2][i]) > f2)) continue;
                    float f6 = this.eigenvalues[i] - this.eigenvalues[n2];
                    if (this.isSmallComparedTo(f5, f6)) {
                        f4 = this.matrix[n2][i] / f6;
                    } else {
                        f3 = 0.5f * f6 / this.matrix[n2][i];
                        f4 = 1.0f / (float)((double)Math.abs(f3) + Math.sqrt(1.0f + f3 * f3));
                        if (f3 < 0.0f) {
                            f4 = -f4;
                        }
                    }
                    f3 = 1.0f / (float)Math.sqrt(1.0f + f4 * f4);
                    float f7 = f4 * f3;
                    float f8 = f7 / (1.0f + f3);
                    float f9 = f4 * this.matrix[n2][i];
                    int n4 = n2;
                    fArray2[n4] = fArray2[n4] - f9;
                    int n5 = i;
                    fArray2[n5] = fArray2[n5] + f9;
                    int n6 = n2;
                    this.eigenvalues[n6] = this.eigenvalues[n6] - f9;
                    int n7 = i;
                    this.eigenvalues[n7] = this.eigenvalues[n7] + f9;
                    this.matrix[n2][i] = 0.0f;
                    for (n3 = 0; n3 <= n2 - 1; ++n3) {
                        this.rotate(n3, n2, n3, i, f7, f8);
                    }
                    for (n3 = n2 + 1; n3 <= i - 1; ++n3) {
                        this.rotate(n2, n3, n3, i, f7, f8);
                    }
                    for (n3 = i + 1; n3 < this.matrix.length; ++n3) {
                        this.rotate(n2, n3, i, n3, f7, f8);
                    }
                    for (n3 = 0; n3 < this.matrix.length; ++n3) {
                        this.rotateEigenMatrix(n3, n2, n3, i, f7, f8);
                    }
                    ++this.numberOfRotationsNeeded;
                }
            }
            for (n2 = 0; n2 < this.matrix.length; ++n2) {
                int n8 = n2;
                fArray[n8] = fArray[n8] + fArray2[n2];
                this.eigenvalues[n2] = fArray[n2];
                fArray2[n2] = 0.0f;
            }
        }
    }

    public static String toString(float[] fArray) {
        String string = "{";
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + fArray[i];
        }
        return string + "}";
    }

    public static String toString(float[][] fArray) {
        String string = "{";
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + JacobiFloat.toString(fArray[i]);
        }
        return string + "}";
    }

    public static float[] getColumn(float[][] fArray, int n) {
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = fArray[i][n];
        }
        return fArray2;
    }

    public static float[][] matMult(float[][] fArray, float[][] fArray2) {
        int n = fArray.length;
        int n2 = fArray2[0].length;
        float[][] fArray3 = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray3[i][j] = 0.0f;
                for (int k = 0; k < fArray2.length; ++k) {
                    float[] fArray4 = fArray3[i];
                    int n3 = j;
                    fArray4[n3] = fArray4[n3] + fArray[i][k] * fArray2[k][j];
                }
            }
        }
        return fArray3;
    }

    public static float[] vecMult(float[][] fArray, float[] fArray2) {
        int n = fArray.length;
        float[] fArray3 = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray3[i] = 0.0f;
            for (int j = 0; j < fArray2.length; ++j) {
                int n2 = i;
                fArray3[n2] = fArray3[n2] + fArray[i][j] * fArray2[j];
            }
        }
        return fArray3;
    }

    public static float[][] transpose(float[][] fArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        float[][] fArray2 = new float[n2][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray2[j][i] = fArray[i][j];
            }
        }
        return fArray2;
    }

    public static void main(String[] stringArray) {
        float[][] fArrayArray = new float[][]{{1.0f, 2.0f}, {2.0f, 1.0f}};
        JacobiFloat jacobiFloat = new JacobiFloat(fArrayArray);
        float[] fArray = jacobiFloat.getEigenValues();
        float[][] fArray2 = new float[fArray.length][fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i][i] = fArray[i];
        }
        float[][] fArray3 = jacobiFloat.getEigenVectors();
        float[][] fArray4 = JacobiFloat.matMult(fArray3, JacobiFloat.matMult(fArray2, JacobiFloat.transpose(fArray3)));
        System.out.println("out: " + JacobiFloat.toString(fArray4));
    }
}

