/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.Point3d;

public class NormalEstimator {
    double x;
    double y;
    double z;
    double xx;
    double yy;
    double zz;
    double xy;
    double yz;
    double xz;
    double xyz;
    long total;
    public Point3d normal;
    public double distance;

    public void reset() {
        this.xyz = 0.0;
        this.xz = 0.0;
        this.yz = 0.0;
        this.xy = 0.0;
        this.zz = 0.0;
        this.yy = 0.0;
        this.xx = 0.0;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.total = 0L;
    }

    public void add(Point3d point3d) {
        this.x += point3d.x;
        this.y += point3d.y;
        this.z += point3d.z;
        this.xx += point3d.x * point3d.x;
        this.yy += point3d.y * point3d.y;
        this.zz += point3d.z * point3d.z;
        this.xy += point3d.x * point3d.y;
        this.yz += point3d.y * point3d.z;
        this.xz += point3d.x * point3d.z;
        this.xyz += point3d.x * point3d.y * point3d.z;
        ++this.total;
    }

    public void remove(Point3d point3d) {
        this.x -= point3d.x;
        this.y -= point3d.y;
        this.z -= point3d.z;
        this.xx -= point3d.x * point3d.x;
        this.yy -= point3d.y * point3d.y;
        this.zz -= point3d.z * point3d.z;
        this.xy -= point3d.x * point3d.y;
        this.yz -= point3d.y * point3d.z;
        this.xz -= point3d.x * point3d.z;
        this.xyz -= point3d.x * point3d.y * point3d.z;
        --this.total;
    }

    public Point3d getNormal() {
        double d = this.xx * this.yy * this.zz + this.xy * this.yz * this.xz + this.xz * this.xy * this.yz - this.xx * this.yz * this.yz - this.xy * this.xy * this.zz - this.xz * this.yy * this.xz;
        if (d != 0.0) {
            double d2 = (this.yy * this.zz - this.yz * this.yz) / d;
            double d3 = (this.xz * this.yz - this.xy * this.zz) / d;
            double d4 = (this.xy * this.yz - this.yy * this.xz) / d;
            double d5 = (this.xx * this.zz - this.xz * this.xz) / d;
            double d6 = (this.xy * this.xz - this.xx * this.yz) / d;
            double d7 = (this.xx * this.yy - this.xy * this.xy) / d;
            double d8 = d2 * this.x + d3 * this.y + d4 * this.z;
            double d9 = d3 * this.x + d5 * this.y + d6 * this.z;
            double d10 = d4 * this.x + d6 * this.y + d7 * this.z;
            this.normal = new Point3d(d8, d9, d10);
            this.distance = this.normal.length();
        } else {
            this.distance = 0.0;
            double d11 = this.yy * this.zz - this.yz * this.yz;
            if (d11 != 0.0) {
                double d12 = (this.zz * -this.xy - this.yz * -this.xz) / d11;
                double d13 = (-this.yz * -this.xy + this.yy * -this.xz) / d11;
                this.normal = new Point3d(1.0, d12, d13);
            } else {
                this.distance = 0.0;
                if (this.xy != 0.0 && this.xz != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.xy / this.xz);
                } else if (this.yy != 0.0 && this.yz != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.yy / this.yz);
                } else if (this.yz != 0.0 && this.zz != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.yz / this.zz);
                } else if (this.y != 0.0 && this.z != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, -this.y / this.z);
                } else if (this.xy != 0.0 || this.yy != 0.0 || this.yz != 0.0 || this.y != 0.0) {
                    this.normal = new Point3d(0.0, 0.0, 1.0);
                } else if (this.xz != 0.0 || this.yz != 0.0 || this.zz != 0.0 || this.z != 0.0) {
                    this.normal = new Point3d(0.0, 1.0, 0.0);
                } else {
                    throw new RuntimeException("amiguous plane");
                }
            }
        }
        this.normal = this.normal.times(1.0 / this.normal.length());
        return this.normal;
    }

    public long getTotal() {
        return this.total;
    }

    public Point3d getMean() {
        return new Point3d(this.x / (double)this.total, this.y / (double)this.total, this.z / (double)this.total);
    }

    public double distanceTo(Point3d point3d) {
        return Math.abs(this.distance - this.normal.scalar(point3d));
    }

    public static void main(String[] stringArray) {
        NormalEstimator normalEstimator = new NormalEstimator();
        Point3d point3d = new Point3d(1.0, 3.0, 1.0);
        point3d = point3d.times(1.0 / point3d.length());
        Point3d point3d2 = Point3d.random();
        for (int i = 0; i < 1000; ++i) {
            Point3d point3d3 = Point3d.random();
            point3d3 = point3d3.minus(point3d.times(point3d.scalar(point3d3.minus(point3d2))));
            normalEstimator.add(point3d3);
        }
        System.err.println("estimate " + normalEstimator.getNormal());
        System.err.println("expect " + point3d);
        normalEstimator.reset();
        normalEstimator.add(new Point3d(-2.0, 1.0, 1.0));
        normalEstimator.add(new Point3d(1.0, 1.0, -2.0));
        normalEstimator.add(new Point3d(1.0, -2.0, 1.0));
        System.err.println("estimate " + normalEstimator.getNormal());
        System.err.println("expect 1 1 1");
        normalEstimator.reset();
        normalEstimator.add(new Point3d(1.0, 0.0, 0.0));
        normalEstimator.add(new Point3d(1.0, 1.0, 0.0));
        normalEstimator.add(new Point3d(1.0, -2.0, 0.0));
        System.err.println("estimate " + normalEstimator.getNormal());
        System.err.println("expect 0 0 1");
        normalEstimator.reset();
        normalEstimator.add(new Point3d(0.0, 0.0, 1.0));
        normalEstimator.add(new Point3d(1.0, -1.0, 0.0));
        normalEstimator.add(new Point3d(-1.0, 1.0, 0.0));
        System.err.println("estimate " + normalEstimator.getNormal());
        System.err.println("expect 1 1 0");
    }
}

