/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.Line;
import math3d.Point3d;

public class Plane {
    double a;
    double b;
    double c;
    double d;

    public Plane(double d, double d2, double d3, double d4) {
        this.a = d;
        this.b = d2;
        this.c = d3;
        this.d = d4;
    }

    public Plane(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        double d = point3d.x;
        double d2 = point3d2.x;
        double d3 = point3d3.x;
        double d4 = point3d.y;
        double d5 = point3d2.y;
        double d6 = point3d3.y;
        double d7 = point3d.z;
        double d8 = point3d2.z;
        double d9 = point3d3.z;
        this.a = d4 * (d8 - d9) + d5 * (d9 - d7) + d6 * (d7 - d8);
        this.b = d7 * (d2 - d3) + d8 * (d3 - d) + d9 * (d - d2);
        this.c = d * (d5 - d6) + d2 * (d6 - d4) + d3 * (d4 - d5);
        this.d = -(d * (d5 * d9 - d6 * d8) + d2 * (d6 * d7 - d4 * d9) + d3 * (d4 * d8 - d5 * d7));
        double d10 = Math.sqrt(this.a * this.a + this.b * this.b + this.c * this.c);
        this.a /= d10;
        this.b /= d10;
        this.c /= d10;
        this.d /= d10;
        if (!this.isInside(point3d4)) {
            this.a *= -1.0;
            this.b *= -1.0;
            this.c *= -1.0;
            this.d *= -1.0;
        }
    }

    boolean isInside(Point3d point3d) {
        return this.isInside(point3d.x, point3d.y, point3d.z);
    }

    boolean isInside(double d, double d2, double d3) {
        return this.a * d + this.b * d2 + this.c * d3 > 0.0;
    }

    public Point3d intersection(Line line) {
        double d = line.p1.x;
        double d2 = line.p2.x;
        double d3 = line.p1.y;
        double d4 = line.p2.y;
        double d5 = line.p1.z;
        double d6 = line.p2.z;
        double d7 = this.a * (d - d2) + this.b * (d3 - d4) + this.c * (d5 - d6);
        if (d7 > -1.0E-4 && d7 < 1.0E-4) {
            return null;
        }
        double d8 = (this.a * d + this.b * d3 + this.c * d5 + this.d) / d7;
        Point3d point3d = new Point3d(d + d8 * (d2 - d), d3 + d8 * (d4 - d3), d5 + d8 * (d6 - d5));
        return point3d;
    }

    public Point3d getNormal() {
        return new Point3d(this.a, this.b, this.c);
    }
}

