/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class Point3d {
    public double x;
    public double y;
    public double z;

    public Point3d() {
    }

    public Point3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double[] toArray() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    public float[] toArrayFloat() {
        float[] fArray = new float[]{(float)this.x, (float)this.y, (float)this.z};
        return fArray;
    }

    public double[] toArrayDouble() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    public Point3d minus(Point3d point3d) {
        return new Point3d(this.x - point3d.x, this.y - point3d.y, this.z - point3d.z);
    }

    public Point3d plus(Point3d point3d) {
        return new Point3d(this.x + point3d.x, this.y + point3d.y, this.z + point3d.z);
    }

    public double scalar(Point3d point3d) {
        return this.x * point3d.x + this.y * point3d.y + this.z * point3d.z;
    }

    public Point3d times(double d) {
        return new Point3d(this.x * d, this.y * d, this.z * d);
    }

    public Point3d vector(Point3d point3d) {
        return new Point3d(this.y * point3d.z - this.z * point3d.y, this.z * point3d.x - this.x * point3d.z, this.x * point3d.y - this.y * point3d.x);
    }

    public double length() {
        return Math.sqrt(this.scalar(this));
    }

    public double distance2(Point3d point3d) {
        double d = this.x - point3d.x;
        double d2 = this.y - point3d.y;
        double d3 = this.z - point3d.z;
        return d * d + d2 * d2 + d3 * d3;
    }

    public double distanceTo(Point3d point3d) {
        return Math.sqrt(this.distance2(point3d));
    }

    public static Point3d average(Point3d[] point3dArray) {
        Point3d point3d = new Point3d();
        for (int i = 0; i < point3dArray.length; ++i) {
            point3d = point3d.plus(point3dArray[i]);
        }
        return point3d.times(1.0 / (double)point3dArray.length);
    }

    static Point3d random() {
        return new Point3d(Math.random() * 400.0 + 50.0, Math.random() * 400.0 + 50.0, Math.random() * 400.0 + 50.0);
    }

    public String toString() {
        return this.x + " " + this.y + " " + this.z;
    }

    public static Point3d parsePoint(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        Point3d point3d = new Point3d();
        point3d.x = Double.parseDouble(stringTokenizer.nextToken());
        point3d.y = Double.parseDouble(stringTokenizer.nextToken());
        point3d.z = Double.parseDouble(stringTokenizer.nextToken());
        return point3d;
    }

    public static Point3d[] parsePoints(String string) {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(Point3d.parsePoint(stringTokenizer.nextToken().trim()));
        }
        Point3d[] point3dArray = new Point3d[arrayList.size()];
        for (int i = 0; i < point3dArray.length; ++i) {
            point3dArray[i] = (Point3d)arrayList.get(i);
        }
        return point3dArray;
    }

    public static void print(Point3d[] point3dArray) {
        for (int i = 0; i < point3dArray.length; ++i) {
            System.out.println((i > 0 ? "," : "") + point3dArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        String string = "127.46979200950274 127.5047385083133 28.033169558193062,153.0 123.5 0.0";
        Point3d[] point3dArray = Point3d.parsePoints(string);
        Point3d.print(point3dArray);
    }
}

