/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import ij.IJ;
import ij.io.OpenDialog;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import nrrd.NrrdHeader;

public class Transform_IO
implements PlugIn {
    public boolean normaliseScaleFactors = false;
    public static final int matRows = 4;
    public static final int matCols = 4;
    public static final int matSize = 16;
    NrrdHeader nh;

    String getTags() {
        return this.nh == null ? null : this.nh.getTagStrings();
    }

    String getFields() {
        return this.nh == null ? null : this.nh.getFieldStrings();
    }

    String getHeader() {
        return this.nh == null ? null : this.nh.toString();
    }

    float[] openAffineTransform(String string) {
        this.nh = new NrrdHeader();
        float[] fArray = new float[16];
        try {
            String string2;
            this.nh.readHeader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            int n = 0;
            while ((string2 = lineNumberReader.readLine()) != null) {
                String[] stringArray = string2.split("\\s+");
                if (stringArray.length != 4) {
                    throw new Exception("Could not read 4 floats from line " + lineNumberReader.getLineNumber() + " of file " + string);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    fArray[n * 4 + i] = this.s2f(stringArray[i]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            IJ.error((String)("Unable to read affine transfomation from file: " + string + "\n" + exception));
        }
        return fArray;
    }

    public float[] openAffineTransform() {
        OpenDialog openDialog = new OpenDialog("Open Affine Transformation...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        return this.openAffineTransform(new File(string, string2).getPath());
    }

    public boolean saveAffineTransform(String string, float[] fArray) {
        File file = new File(string);
        if (fArray.length != 16) {
            return false;
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            bufferedWriter.write("# Simple Affine Transformation written by Transform_IO\n");
            bufferedWriter.write("# at " + new Date() + "\n");
            bufferedWriter.write(this.toString(fArray));
            ((Writer)bufferedWriter).close();
        }
        catch (Exception exception) {
            IJ.error((String)("Unable to write transformation to file: " + file.getAbsolutePath() + "error: " + exception));
            return false;
        }
        return true;
    }

    public String toString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            stringBuffer.append(fArray[i * 4] + " " + fArray[i * 4 + 1] + " " + fArray[i * 4 + 2] + " " + fArray[i * 4 + 3] + "\n");
        }
        return stringBuffer.toString();
    }

    public boolean saveAffineTransform(float[] fArray) {
        SaveDialog saveDialog = new SaveDialog("Save Affine Transformation ...", "", ".mat");
        String string = saveDialog.getFileName();
        if (string == null) {
            return false;
        }
        String string2 = saveDialog.getDirectory();
        return this.saveAffineTransform(new File(string2, string).getPath(), fArray);
    }

    float s2f(String string) {
        Float f = null;
        try {
            f = new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f != null ? f.floatValue() : Float.NaN;
    }

    public void run(String string) {
        float[] fArray = string.equals("") ? this.openAffineTransform() : this.openAffineTransform(string);
        IJ.log((String)("fields:=" + this.getFields()));
        IJ.log((String)("tags:=" + this.getTags()));
        IJ.log((String)("mat = " + Arrays.toString(fArray)));
    }
}

