/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.Line;
import math3d.Plane;
import math3d.Point3d;

public class Triangle {
    public Point3d a;
    public Point3d b;
    public Point3d c;
    public Point3d center;
    public double cRadius2;

    public Triangle() {
    }

    public Triangle(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        this.a = point3d;
        this.b = point3d2;
        this.c = point3d3;
        this.calculateCircumcenter2();
    }

    public double calculateCircumcenter2() {
        Point3d point3d = this.b.minus(this.a);
        Point3d point3d2 = this.c.minus(this.a);
        double d = point3d.scalar(point3d);
        double d2 = point3d.scalar(point3d2);
        double d3 = point3d2.scalar(point3d2);
        double d4 = d * d3 - d2 * d2;
        double d5 = 0.5 * (d3 * d - d2 * d3) / d4;
        double d6 = 0.5 * (-d2 * d + d * d3) / d4;
        this.center = new Point3d(this.a.x + d5 * point3d.x + d6 * point3d2.x, this.a.y + d5 * point3d.y + d6 * point3d2.y, this.a.z + d5 * point3d.z + d6 * point3d2.z);
        this.cRadius2 = this.center.distance2(this.a);
        return this.cRadius2;
    }

    public Point3d intersection(Line line) {
        Plane plane = new Plane(this.a, this.b, this.c, this.b);
        Point3d point3d = plane.intersection(line);
        if (point3d == null) {
            return null;
        }
        Point3d point3d2 = plane.getNormal().plus(this.a);
        Plane plane2 = new Plane(this.a, this.b, point3d2, this.center);
        point3d2 = plane.getNormal().plus(this.b);
        Plane plane3 = new Plane(this.b, this.c, point3d2, this.center);
        point3d2 = plane.getNormal().plus(this.c);
        Plane plane4 = new Plane(this.c, this.a, point3d2, this.center);
        if (plane2.isInside(point3d) && plane3.isInside(point3d) && plane4.isInside(point3d)) {
            return point3d;
        }
        return null;
    }

    public static void test() {
        Triangle triangle = new Triangle();
        triangle.a = Point3d.random();
        triangle.a.z = 0.0;
        triangle.b = Point3d.random();
        triangle.b.z = 0.0;
        triangle.c = Point3d.random();
        triangle.c.z = 0.0;
        triangle.calculateCircumcenter2();
        Point3d point3d = triangle.center;
        double d = Math.sqrt(triangle.cRadius2);
        System.out.println("%!PS-1.0\n" + triangle.a + " pop moveto\n" + triangle.b + " pop lineto\n" + triangle.c + " pop lineto closepath stroke\n" + triangle.a + " pop moveto\n" + point3d + " pop lineto stroke\n" + point3d + " pop " + d + " 0 350 arc stroke\n" + "showpage\n");
    }

    public String toString() {
        return "{" + this.a + "; " + this.b + "; " + this.c + "} ";
    }
}

