/*
 * Decompiled with CFR 0.152.
 */
package nrrd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import nrrd.NrrdInfo;

public class NrrdHeader {
    String filename;
    String directory;
    LinkedHashMap tags;
    LinkedHashMap fields;
    ArrayList header;
    ArrayList comments;
    String magic;
    String content;
    String contentType;
    String encoding;
    public int lineSkip;
    boolean detachedHeader = false;
    boolean multiLineDataFile = false;
    ArrayList dataFiles;
    StringBuffer textData;
    boolean textNrrd = false;

    public String getTextData() {
        if (!this.textNrrd || this.textData.length() == 0) {
            return null;
        }
        return this.textData.toString();
    }

    public NrrdHeader() {
        this("UTF-8");
    }

    public NrrdHeader(String string) {
        this.encoding = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.header == null || this.header.size() < 1) {
            return null;
        }
        Iterator iterator = this.header.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next() + "\n");
        }
        return stringBuffer.toString();
    }

    void appendLine(String string) {
        this.header.add(string);
    }

    void init() {
        this.tags = new LinkedHashMap();
        this.fields = new LinkedHashMap();
        this.header = new ArrayList();
        this.comments = new ArrayList();
        this.textData = new StringBuffer();
        this.dataFiles = new ArrayList();
        this.detachedHeader = false;
        this.multiLineDataFile = false;
    }

    public String getCommentStrings() {
        return this.comments.toString();
    }

    void appendCommment(String string) throws Exception {
        if (!string.startsWith("#")) {
            throw new Exception("nrrd invalid comment: " + string);
        }
        this.appendLine(string);
        string = string.split("#\\s*", 1)[0];
    }

    public String getTagStrings() {
        return this.tags.toString();
    }

    void appendTag(String string) throws Exception {
        this.appendLine(string);
        int n = string.indexOf(":=");
        if (n < 1 || string.length() < 3) {
            throw new Exception("nrrd: invalid tag: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2, string.length());
        this.tags.put(string2, string3);
    }

    public String getFieldStrings() {
        if (this.fields == null || this.fields.size() < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        Iterator iterator = this.fields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = Arrays.toString((String[])this.fields.get(string));
            if (string2 != null) {
                stringBuffer.append(string + "=" + string2);
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    void processDataFile(String string) throws Exception {
        String[] stringArray = null;
        this.detachedHeader = true;
        if (string.startsWith("LIST")) {
            this.multiLineDataFile = true;
            stringArray = string.trim().split("\\s+");
        } else if (string.matches(".*%[0-9]*d.*")) {
            if (string.startsWith("\"")) {
                int n = string.lastIndexOf("\"", 1);
                if (n < 2) {
                    throw new Exception("Unable to read quoted format string in data file line");
                }
                String[] stringArray2 = string.substring(n + 1).split("\\s+");
                if (stringArray2.length < 4 || stringArray2.length > 5) {
                    throw new Exception("Incorrect number of field specifications in data file field");
                }
                stringArray = new String[1 + stringArray2.length];
                stringArray[0] = string.substring(1, n);
                System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            } else {
                stringArray = string.split("\\s+");
            }
        } else {
            stringArray = new String[]{string};
        }
        this.fields.put("data file", stringArray);
    }

    void appendField(String string) throws Exception {
        this.appendLine(string);
        int n = string.indexOf(": ");
        String string2 = this.standardFieldName(string.substring(0, n));
        String string3 = string.substring(n + 2, string.length());
        String[] stringArray = null;
        if (string2.equals("content")) {
            this.content = string3;
            stringArray = new String[]{string3};
            this.fields.put(string2, stringArray);
            return;
        }
        if (string2.equals("data file")) {
            this.processDataFile(string3);
            return;
        }
        if ((string3 = string3.trim()).startsWith("\"") && string3.endsWith("\"")) {
            stringArray = (string3 = string3.substring(1, string3.length() - 1)).split("\"\\s+\"");
            if (stringArray.length < 1) {
                throw new Exception("nrrd: trouble parsing quoted field values: " + string);
            }
        } else {
            stringArray = string3.toLowerCase().split("\\s+");
        }
        this.fields.put(string2, stringArray);
    }

    String standardFieldName(String string) {
        if ((string = string.toLowerCase()).equals("centerings")) {
            return "centers";
        }
        if (string.equals("axismaxs")) {
            return "axis maxs";
        }
        if (string.equals("axismins")) {
            return "axis mins";
        }
        if (string.equals("lineskip")) {
            return "line skip";
        }
        if (string.equals("byteskip")) {
            return "byte skip";
        }
        if (string.equals("datafile")) {
            return "data file";
        }
        if (string.equals("oldmax")) {
            return "old max";
        }
        if (string.equals("oldmin")) {
            return "old min";
        }
        return string;
    }

    public void readHeader(String string) throws IOException {
        FileInputStream fileInputStream;
        try {
            File file = new File(string);
            this.filename = file.getName();
            this.directory = file.getParent();
            fileInputStream = new FileInputStream(file);
        }
        catch (Exception exception) {
            throw new IOException("Unable to access nrrd file: " + string);
        }
        this.readHeader(fileInputStream);
        fileInputStream.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readHeader(InputStream inputStream) throws IOException {
        try {
            String string;
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream, this.encoding));
            this.init();
            this.magic = lineNumberReader.readLine();
            this.appendLine(this.magic);
            while ((string = lineNumberReader.readLine()) != null) {
                if (string.startsWith("#")) {
                    this.appendCommment(string);
                    continue;
                }
                if (string.indexOf(":=") > -1) {
                    this.appendTag(string);
                    continue;
                }
                if (string.indexOf(": ") > -1) {
                    this.appendField(string);
                    continue;
                }
                if (string.length() == 0) {
                    this.lineSkip = lineNumberReader.getLineNumber();
                    return;
                }
                if (this.multiLineDataFile) {
                    this.appendLine(string);
                    this.dataFiles.add(string);
                    continue;
                }
                if (this.textNrrd) {
                    this.textData.append(string);
                    continue;
                }
                if (this.magic.startsWith("NRRD")) {
                    throw new Exception("Invalid nrrd header at line:" + lineNumberReader.getLineNumber());
                }
                this.textData.append(string);
                String[] stringArray = string.split("\\s+");
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        float f = new Float(stringArray[i]).floatValue();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Invalid nrrd text file - first uncommented line must contain floats");
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new IOException("Trouble reading nrrd header: " + exception);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Must specify a file name!");
        } else {
            NrrdHeader nrrdHeader = null;
            NrrdInfo nrrdInfo = null;
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    nrrdHeader = new NrrdHeader();
                    nrrdHeader.readHeader(stringArray[i]);
                    nrrdInfo = new NrrdInfo(nrrdHeader);
                    nrrdInfo.parseHeader();
                    System.out.println("" + nrrdHeader);
                    System.out.println("fields:\n" + nrrdHeader.getFieldStrings() + "\n");
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Problem reading file name: " + stringArray[i] + "\n" + iOException);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Problem parsing file name: " + stringArray[i] + "\n" + exception);
                    exception.printStackTrace();
                }
            }
        }
    }
}

