/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import java.io.File;
import java.util.List;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import octree.CubeData;
import octree.CubeDataRecycler;
import octree.VolumeOctree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cube
implements AxisConstants {
    public static final int RESOLUTION_SUFFICIENT = 0;
    public static final int RESOLUTION_UNSUFFICIENT = 1;
    public static final int OUTSIDE_CANVAS = 2;
    public static final double RES_THRESHOLD = 1024.0;
    final int x;
    final int y;
    final int z;
    final int level;
    final float pw;
    final float ph;
    final float pd;
    final String path;
    final String name;
    final String dir;
    private Cube[] children;
    final Point3d[] corners;
    private Point2d[] cornersInCanvas;
    private CubeData cdata;
    private boolean updateNeeded = true;
    private VolumeOctree octree;
    Point3d ptmp = new Point3d();

    public Cube(VolumeOctree volumeOctree, String string, int n, int n2, int n3, int n4) {
        this.dir = string + "/";
        this.octree = volumeOctree;
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.level = n4;
        this.name = n + "_" + n2 + "_" + n3 + "_" + n4;
        this.path = this.dir + this.name + ".tif";
        if (this.exists()) {
            float[] fArray = CubeData.readCalibration(this.path, null);
            this.pw = fArray[0];
            this.ph = fArray[1];
            this.pd = fArray[2];
            double d = 256.0f * this.pw;
            double d2 = 256.0f * this.ph;
            double d3 = 256.0f * this.pd;
            this.cornersInCanvas = new Point2d[8];
            for (int i = 0; i < 8; ++i) {
                this.cornersInCanvas[i] = new Point2d();
            }
            this.corners = new Point3d[8];
            this.corners[0] = new Point3d((double)((float)n * volumeOctree.pw), (double)((float)n2 * volumeOctree.ph), (double)((float)n3 * volumeOctree.pd));
            this.corners[7] = new Point3d(this.corners[0].x + d, this.corners[0].y + d2, this.corners[0].z + d3);
            this.corners[1] = new Point3d(this.corners[7].x, this.corners[0].y, this.corners[0].z);
            this.corners[2] = new Point3d(this.corners[0].x, this.corners[7].y, this.corners[0].z);
            this.corners[3] = new Point3d(this.corners[7].x, this.corners[7].y, this.corners[0].z);
            this.corners[4] = new Point3d(this.corners[0].x, this.corners[0].y, this.corners[7].z);
            this.corners[5] = new Point3d(this.corners[7].x, this.corners[0].y, this.corners[7].z);
            this.corners[6] = new Point3d(this.corners[0].x, this.corners[7].y, this.corners[7].z);
        } else {
            this.pd = -1.0f;
            this.ph = -1.0f;
            this.pw = -1.0f;
            this.corners = null;
        }
    }

    public boolean exists() {
        return new File(this.path).exists();
    }

    public Cube[] getChildren() {
        return this.children;
    }

    public boolean cubeDataUpToDate() {
        return !this.updateNeeded;
    }

    public void cleanup() {
        if (this.cdata != null && this.updateNeeded) {
            CubeDataRecycler.instance().deleteCubeData(this.cdata);
            this.cdata = null;
        }
        if (this.children == null) {
            return;
        }
        for (Cube cube : this.children) {
            if (cube == null) continue;
            cube.cleanup();
        }
    }

    public CubeData getCubeData() {
        return this.cdata;
    }

    public void updateCubeData() {
        try {
            this.cdata.createData();
            this.updateNeeded = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void collectCubesToDisplay(List<Cube> list, Canvas3D canvas3D, Transform3D transform3D, int n, int n2) {
        int n3 = this.checkResolution(canvas3D, transform3D);
        if (n3 == 2) {
            this.undisplaySelf();
            this.undisplaySubtree();
            return;
        }
        if (n3 == 1 && this.children != null) {
            this.undisplaySelf();
            for (Cube cube : this.children) {
                if (cube == null) continue;
                cube.collectCubesToDisplay(list, canvas3D, transform3D, n, n2);
            }
        } else {
            if (this.cdata == null) {
                this.undisplaySubtree();
                this.cdata = CubeDataRecycler.instance().newCubeData(this);
                this.cdata.prepareForAxis(n);
                this.updateNeeded = true;
            } else if (n == this.cdata.axis) {
                this.updateNeeded = false;
            } else {
                this.cdata.prepareForAxis(n);
                this.updateNeeded = true;
            }
            list.add(this);
        }
    }

    public int checkResolution(Canvas3D canvas3D, Transform3D transform3D) {
        for (int i = 0; i < this.corners.length; ++i) {
            this.volumePointInCanvas(canvas3D, transform3D, this.corners[i], this.cornersInCanvas[i]);
        }
        if (this.outsideCanvas(canvas3D)) {
            return 2;
        }
        double d = this.cornersInCanvas[0].distance(this.cornersInCanvas[7]);
        double d2 = this.cornersInCanvas[1].distance(this.cornersInCanvas[6]);
        if (d2 > d) {
            d = d2;
        }
        if ((d2 = this.cornersInCanvas[2].distance(this.cornersInCanvas[5])) > d) {
            d = d2;
        }
        if ((d2 = this.cornersInCanvas[3].distance(this.cornersInCanvas[4])) > d) {
            d = d2;
        }
        return d <= 1024.0 ? 0 : 1;
    }

    private void undisplaySubtree() {
        if (this.children == null) {
            return;
        }
        for (Cube cube : this.children) {
            if (cube == null) continue;
            cube.undisplaySelf();
            cube.undisplaySubtree();
        }
    }

    private void undisplaySelf() {
        if (this.cdata != null) {
            CubeDataRecycler.instance().deleteCubeData(this.cdata);
            this.cdata = null;
        }
    }

    public void createChildren() {
        if (this.level == 1) {
            return;
        }
        int n = this.level >> 1;
        int n2 = 256;
        this.children = new Cube[8];
        this.children[0] = new Cube(this.octree, this.dir, this.x, this.y, this.z, n);
        if (!this.children[0].exists()) {
            this.children[0] = null;
        }
        this.children[1] = new Cube(this.octree, this.dir, this.x + n * n2, this.y, this.z, n);
        if (!this.children[1].exists()) {
            this.children[1] = null;
        }
        this.children[2] = new Cube(this.octree, this.dir, this.x, this.y + n * n2, this.z, n);
        if (!this.children[2].exists()) {
            this.children[2] = null;
        }
        this.children[3] = new Cube(this.octree, this.dir, this.x + n * n2, this.y + n * n2, this.z, n);
        if (!this.children[3].exists()) {
            this.children[3] = null;
        }
        this.children[4] = new Cube(this.octree, this.dir, this.x, this.y, this.z + n * n2, n);
        if (!this.children[4].exists()) {
            this.children[4] = null;
        }
        this.children[5] = new Cube(this.octree, this.dir, this.x + n * n2, this.y, this.z + n * n2, n);
        if (!this.children[5].exists()) {
            this.children[5] = null;
        }
        this.children[6] = new Cube(this.octree, this.dir, this.x, this.y + n * n2, this.z + n * n2, n);
        if (!this.children[6].exists()) {
            this.children[6] = null;
        }
        this.children[7] = new Cube(this.octree, this.dir, this.x + n * n2, this.y + n * n2, this.z + n * n2, n);
        if (!this.children[7].exists()) {
            this.children[7] = null;
        }
        for (Cube cube : this.children) {
            if (cube == null) continue;
            cube.createChildren();
        }
    }

    private final void volumePointInCanvas(Canvas3D canvas3D, Transform3D transform3D, Point3d point3d, Point2d point2d) {
        this.ptmp.set((Tuple3d)point3d);
        transform3D.transform(this.ptmp);
        canvas3D.getPixelLocationFromImagePlate(this.ptmp, point2d);
    }

    private final boolean outsideCanvas(Canvas3D canvas3D) {
        int n;
        int n2;
        boolean bl = true;
        for (n2 = 0; n2 < 8; ++n2) {
            if (!(this.cornersInCanvas[n2].x >= 0.0)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        bl = true;
        for (n2 = 0; n2 < 8; ++n2) {
            if (!(this.cornersInCanvas[n2].y >= 0.0)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        n2 = canvas3D.getWidth();
        int n3 = canvas3D.getHeight();
        bl = true;
        for (n = 0; n < 8; ++n) {
            if (!(this.cornersInCanvas[n].x < (double)n2)) continue;
            bl = false;
            break;
        }
        if (bl) {
            return true;
        }
        bl = true;
        for (n = 0; n < 8; ++n) {
            if (!(this.cornersInCanvas[n].y < (double)n3)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String toString() {
        return this.name;
    }
}

