/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.media.j3d.TexCoordGeneration;
import javax.vecmath.Vector4f;
import octree.Cube;
import octree.ShapeGroup;

public class CubeData
implements AxisConstants {
    private static final int SIZE = 256;
    private static final int B_IMG_TYPE = 10;
    String path;
    float[] cal = new float[3];
    float[] min = new float[3];
    float[] max = new float[3];
    int axis;
    BufferedImage[] images;
    byte[][] pixels;
    TexCoordGeneration tg;
    ShapeGroup[] shapes;
    Cube cube;

    public CubeData(Cube cube) {
        this.setCube(cube);
        this.images = new BufferedImage[256];
        this.pixels = new byte[256][];
        this.shapes = new ShapeGroup[256];
        for (int i = 0; i < 256; ++i) {
            this.images[i] = new BufferedImage(256, 256, 10);
            this.pixels[i] = ((DataBufferByte)this.images[i].getRaster().getDataBuffer()).getData();
            this.shapes[i] = new ShapeGroup(cube);
        }
    }

    public void prepareForAxis(int n) {
        this.axis = n;
        for (int i = 0; i < 256; ++i) {
            this.shapes[i].pos = this.min[n] + this.cal[n] * (float)i;
        }
    }

    public void setCube(Cube cube) {
        this.cube = cube;
        this.path = cube.path;
        this.min[0] = (float)cube.corners[0].x;
        this.min[1] = (float)cube.corners[0].y;
        this.min[2] = (float)cube.corners[0].z;
        this.cal[0] = cube.pw;
        this.cal[1] = cube.ph;
        this.cal[2] = cube.pd;
    }

    public void createData() throws Exception {
        switch (this.axis) {
            case 0: {
                this.createXData();
                break;
            }
            case 1: {
                this.createYData();
                break;
            }
            case 2: {
                this.createZData();
            }
        }
    }

    private void createShapes() {
        for (int i = 0; i < 256; ++i) {
            this.shapes[i].setCubeData(this.cube, this, i);
        }
    }

    private final void createZData() throws Exception {
        this.loadZData();
        float f = (float)(1.0 / (double)(this.cal[0] * 256.0f));
        float f2 = (float)(1.0 / (double)(this.cal[1] * 256.0f));
        this.tg = new TexCoordGeneration();
        this.tg.setPlaneS(new Vector4f(f, 0.0f, 0.0f, -(f * this.min[0])));
        this.tg.setPlaneT(new Vector4f(0.0f, f2, 0.0f, -(f2 * this.min[1])));
        this.axis = 2;
        this.createShapes();
    }

    private final void createXData() throws Exception {
        int n;
        this.loadZData();
        byte[][] byArray = new byte[256][this.pixels[0].length];
        int n2 = 0;
        for (n = 0; n < 256; ++n) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < 256) {
                int n5 = 0;
                while (n5 < 256) {
                    byArray[n5][n2] = this.pixels[n][n4];
                    ++n5;
                    ++n4;
                }
                ++n3;
                ++n2;
            }
        }
        for (n = 0; n < 256; ++n) {
            System.arraycopy(byArray[n], 0, this.pixels[n], 0, byArray[n].length);
        }
        float f = (float)(1.0 / (double)(this.cal[1] * 256.0f));
        float f2 = (float)(1.0 / (double)(this.cal[2] * 256.0f));
        this.tg = new TexCoordGeneration();
        this.tg.setPlaneS(new Vector4f(0.0f, f, 0.0f, -(f * this.min[1])));
        this.tg.setPlaneT(new Vector4f(0.0f, 0.0f, f2, -(f2 * this.min[2])));
        this.axis = 0;
        this.createShapes();
    }

    private final void createYData() throws Exception {
        this.loadZData();
        byte[][] byArray = new byte[256][this.pixels[0].length];
        int n = 0;
        int n2 = 0;
        while (n < 256) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < 256) {
                System.arraycopy(this.pixels[n3], n2, byArray[n], n4, 256);
                ++n3;
                n4 += 256;
            }
            ++n;
            n2 += 256;
        }
        for (n = 0; n < 256; ++n) {
            System.arraycopy(byArray[n], 0, this.pixels[n], 0, byArray[n].length);
        }
        float f = (float)(1.0 / (double)(this.cal[0] * 256.0f));
        float f2 = (float)(1.0 / (double)(this.cal[2] * 256.0f));
        this.tg = new TexCoordGeneration();
        this.tg.setPlaneS(new Vector4f(f, 0.0f, 0.0f, -(f * this.min[0])));
        this.tg.setPlaneT(new Vector4f(0.0f, 0.0f, f2, -(f2 * this.min[2])));
        this.axis = 1;
        this.createShapes();
    }

    public static final float[] readCalibration(String string, float[] fArray) {
        if (fArray == null) {
            fArray = new float[3];
        }
        File file = new File(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            if (fileInputStream == null) {
                return null;
            }
            fArray[0] = CubeData.readFloat(fileInputStream);
            fArray[1] = CubeData.readFloat(fileInputStream);
            fArray[2] = CubeData.readFloat(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return fArray;
    }

    public static final void writeZData(String string, byte[][] byArray, float f, float f2, float f3) throws Exception {
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file, false);
        CubeData.writeFloat(fileOutputStream, f);
        CubeData.writeFloat(fileOutputStream, f2);
        CubeData.writeFloat(fileOutputStream, f3);
        for (int i = 0; i < byArray.length; ++i) {
            fileOutputStream.write(byArray[i]);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    private void loadZData() throws Exception {
        File file = new File(this.path);
        FileInputStream fileInputStream = new FileInputStream(file);
        this.cal[0] = CubeData.readFloat(fileInputStream);
        this.cal[1] = CubeData.readFloat(fileInputStream);
        this.cal[2] = CubeData.readFloat(fileInputStream);
        for (int i = 0; i < 256; ++i) {
            byte[] byArray = this.pixels[i];
            int n = byArray.length;
            for (int j = 0; j < n; j += fileInputStream.read(byArray, j, n - j)) {
            }
        }
        fileInputStream.close();
        this.max[0] = this.min[0] + 256.0f * this.cal[0];
        this.max[1] = this.min[1] + 256.0f * this.cal[1];
        this.max[2] = this.min[2] + 256.0f * this.cal[2];
    }

    private static final float readFloat(FileInputStream fileInputStream) throws Exception {
        return Float.intBitsToFloat(CubeData.readInt(fileInputStream));
    }

    private static final int readInt(FileInputStream fileInputStream) throws Exception {
        return (fileInputStream.read() << 24) + (fileInputStream.read() << 16) + (fileInputStream.read() << 8) + fileInputStream.read();
    }

    private static final void writeFloat(FileOutputStream fileOutputStream, float f) throws Exception {
        int n = Float.floatToIntBits(f);
        CubeData.writeInt(fileOutputStream, n);
    }

    private static final void writeInt(FileOutputStream fileOutputStream, int n) throws Exception {
        fileOutputStream.write((n & 0xFF000000) >> 24);
        fileOutputStream.write((n & 0xFF0000) >> 16);
        fileOutputStream.write((n & 0xFF00) >> 8);
        fileOutputStream.write(n & 0xFF);
    }
}

