/*
 * Decompiled with CFR 0.152.
 */
package octree;

import octree.Cube;
import octree.CubeData;

public class CubeDataRecycler {
    private static CubeDataRecycler instance = null;
    private static int CACHE_SIZE;
    private CubeData[] pool = new CubeData[CACHE_SIZE];
    private int size = 0;

    private CubeDataRecycler() {
    }

    public void clearAll() {
        for (int i = 0; i < this.size; ++i) {
            this.pool[i] = null;
        }
        this.size = 0;
    }

    public static CubeDataRecycler instance() {
        if (instance == null) {
            instance = new CubeDataRecycler();
        }
        return instance;
    }

    public CubeData newCubeData(Cube cube) {
        if (this.size == 0) {
            return new CubeData(cube);
        }
        --this.size;
        CubeData cubeData = this.pool[this.size];
        cubeData.setCube(cube);
        return cubeData;
    }

    public void deleteCubeData(CubeData cubeData) {
        if (this.size < CACHE_SIZE) {
            this.pool[this.size++] = cubeData;
        }
    }
}

