/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import octree.CubeData;
import vib.Resample_;

public class FilePreparer {
    private ImagePlus image;
    private int size;
    private String outdir;
    private Resample_.Averager accu = new Resample_.Averager();

    public FilePreparer(String string, int n, String string2) {
        this(IJ.openImage((String)string), n, string2);
    }

    public FilePreparer(ImagePlus imagePlus, int n, String string) {
        this.image = imagePlus;
        this.size = n;
        this.outdir = string;
    }

    public int createFiles() throws Exception {
        System.out.println("create Files");
        int n = this.nextPow2(this.image.getWidth());
        int n2 = this.nextPow2(this.image.getHeight());
        int n3 = this.nextPow2(this.image.getStackSize());
        System.out.println("w = " + n);
        System.out.println("h = " + n2);
        System.out.println("d = " + n3);
        int n4 = 1;
        Calibration calibration = this.image.getCalibration().copy();
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        while (true) {
            int n8;
            int n9;
            for (n9 = 0; n9 < n3; n9 += this.size) {
                byte[][] byArrayArray = new byte[this.size][];
                for (n8 = 0; n8 < this.size; ++n8) {
                    byArrayArray[n8] = n9 + n8 < this.image.getStackSize() ? (byte[])this.image.getStack().getPixels(n9 + n8 + 1) : new byte[this.image.getWidth() * this.image.getHeight()];
                }
                System.out.println("create cubes for z = " + n9);
                for (n8 = 0; n8 < n2; n8 += this.size) {
                    for (int i = 0; i < n; i += this.size) {
                        String string = this.outdir + "/" + i * n4 + "_" + n8 * n4 + "_" + n9 * n4 + "_" + n4 + ".tif";
                        if (new File(string).exists()) continue;
                        ImagePlus imagePlus = this.createSubvolume(byArrayArray, i, n8);
                        this.saveCube(imagePlus, string);
                    }
                }
            }
            n9 = n > this.size ? 2 : 1;
            int n10 = n2 > this.size ? 2 : 1;
            int n11 = n8 = n3 > this.size ? 2 : 1;
            if (n9 == 1 && n10 == 1 && n8 == 1) break;
            this.image = this.resample(this.image, n9, n10, n8, this.accu);
            this.image.show();
            n = this.image.getWidth();
            n2 = this.image.getHeight();
            n3 = this.image.getStackSize();
            n4 <<= 1;
        }
        this.writeProperties(n5, n6, n7, n4, calibration);
        System.out.println("Finished create files");
        return n4;
    }

    private void saveCube(ImagePlus imagePlus, String string) throws Exception {
        byte[][] byArrayArray = new byte[this.size][];
        ImageStack imageStack = imagePlus.getStack();
        Calibration calibration = imagePlus.getCalibration();
        for (int i = 0; i < this.size; ++i) {
            byArrayArray[i] = (byte[])imageStack.getPixels(i + 1);
        }
        CubeData.writeZData(string, byArrayArray, (float)calibration.pixelWidth, (float)calibration.pixelHeight, (float)calibration.pixelDepth);
    }

    private void writeProperties(int n, int n2, int n3, int n4, Calibration calibration) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("width", Integer.toString(n));
        properties.setProperty("height", Integer.toString(n2));
        properties.setProperty("depth", Integer.toString(n3));
        properties.setProperty("level", Integer.toString(n4));
        properties.setProperty("pixelWidth", Float.toString((float)calibration.pixelWidth));
        properties.setProperty("pixelHeight", Float.toString((float)calibration.pixelHeight));
        properties.setProperty("pixelDepth", Float.toString((float)calibration.pixelDepth));
        FileOutputStream fileOutputStream = new FileOutputStream(new File(this.outdir, "props.txt"));
        properties.store(fileOutputStream, "octree");
    }

    private ImagePlus createSubvolume(byte[][] byArray, int n, int n2) {
        int n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        int n5 = this.image.getStackSize();
        ImageStack imageStack = new ImageStack(this.size, this.size);
        for (int i = 0; i < this.size; ++i) {
            byte[] byArray2 = byArray[i];
            byte[] byArray3 = new byte[this.size * this.size];
            for (int j = 0; j < this.size; ++j) {
                for (int k = 0; k < this.size; ++k) {
                    byArray3[j * this.size + k] = n + k >= n3 || n2 + j >= n4 ? (byte)0 : byArray2[(j + n2) * n3 + (k + n)];
                }
            }
            imageStack.addSlice("", (Object)byArray3);
        }
        ImagePlus imagePlus = new ImagePlus("", imageStack);
        imagePlus.setCalibration(this.image.getCalibration());
        return imagePlus;
    }

    private final int nextPow2(int n) {
        int n2;
        for (n2 = 2; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    public ImagePlus resample(ImagePlus imagePlus, int n, int n2, int n3, Resample_.Averager averager) {
        Object object;
        int n4 = imagePlus.getType();
        if (n4 != 0) {
            throw new RuntimeException("Only 8bit images supported at the moment");
        }
        ImageStack imageStack = imagePlus.getStack();
        int n5 = imagePlus.getWidth();
        int n6 = imagePlus.getHeight();
        int n7 = imageStack.getSize();
        int n8 = this.nextPow2(n5);
        int n9 = this.nextPow2(n6);
        int n10 = this.nextPow2(n7);
        int n11 = n8 / 2;
        int n12 = n9 / 2;
        int n13 = n10 / 2;
        ImageStack imageStack2 = new ImageStack(n11, n12);
        for (int i = 0; i < n10; i += n3) {
            object = new byte[n3][];
            for (int j = 0; j < n3; ++j) {
                object[j] = i + j < n7 ? (byte[])imageStack.getPixels(i + j + 1) : new byte[n5 * n6];
            }
            byte[] byArray = new byte[n11 * n12];
            for (int j = 0; j < n9; j += n2) {
                for (int k = 0; k < n8; k += n) {
                    averager.reset();
                    for (int i2 = 0; i2 < n; ++i2) {
                        int n14 = k + i2;
                        for (int i3 = 0; i3 < n2; ++i3) {
                            int n15 = j + i3;
                            for (int i4 = 0; i4 < n3; ++i4) {
                                if (n14 >= n5 || n15 >= n6) {
                                    averager.add(0);
                                    continue;
                                }
                                averager.add(object[i4][n15 * n5 + n14] & 0xFF);
                            }
                        }
                    }
                    byArray[k / n + n11 * (j / n2)] = (byte)averager.get();
                }
                IJ.showProgress((int)(i * n9 + j + 1), (int)(n9 * n10));
            }
            imageStack2.addSlice(null, (Object)byArray);
        }
        ImagePlus imagePlus2 = new ImagePlus(imagePlus.getTitle() + " resampled", imageStack2);
        object = imagePlus.getCalibration().copy();
        object.pixelWidth *= (double)n;
        object.pixelHeight *= (double)n2;
        object.pixelDepth *= (double)n3;
        imagePlus2.setCalibration((Calibration)object);
        return imagePlus2;
    }
}

