/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.QuadArray;
import octree.CubeData;

public class GeometryCreator
implements AxisConstants {
    private float[] quadCoords = new float[12];
    private static GeometryCreator instance;

    private GeometryCreator() {
    }

    public static GeometryCreator instance() {
        if (instance == null) {
            instance = new GeometryCreator();
        }
        return instance;
    }

    public GeometryArray getQuad(CubeData cubeData, int n) {
        this.calculateQuad(cubeData, n);
        QuadArray quadArray = new QuadArray(4, 1);
        quadArray.setCoordinates(0, this.quadCoords);
        return quadArray;
    }

    public float[] getQuadCoordinates(CubeData cubeData, int n) {
        this.calculateQuad(cubeData, n);
        return this.quadCoords;
    }

    private void calculateQuad(CubeData cubeData, int n) {
        switch (cubeData.axis) {
            case 0: {
                this.setCoordsY(cubeData);
                this.setCoordsZ(cubeData);
                this.setCurCoordX(n, cubeData);
                break;
            }
            case 1: {
                this.setCoordsX(cubeData);
                this.setCoordsZ(cubeData);
                this.setCurCoordY(n, cubeData);
                break;
            }
            case 2: {
                this.setCoordsX(cubeData);
                this.setCoordsY(cubeData);
                this.setCurCoordZ(n, cubeData);
            }
        }
    }

    private void setCurCoordX(int n, CubeData cubeData) {
        float f;
        this.quadCoords[0] = f = (float)n * cubeData.cal[0] + cubeData.min[0];
        this.quadCoords[3] = f;
        this.quadCoords[6] = f;
        this.quadCoords[9] = f;
    }

    private void setCurCoordY(int n, CubeData cubeData) {
        float f;
        this.quadCoords[1] = f = (float)n * cubeData.cal[1] + cubeData.min[1];
        this.quadCoords[4] = f;
        this.quadCoords[7] = f;
        this.quadCoords[10] = f;
    }

    private void setCurCoordZ(int n, CubeData cubeData) {
        float f;
        this.quadCoords[2] = f = (float)n * cubeData.cal[2] + cubeData.min[2];
        this.quadCoords[5] = f;
        this.quadCoords[8] = f;
        this.quadCoords[11] = f;
    }

    private void setCoordsX(CubeData cubeData) {
        this.quadCoords[1] = cubeData.min[1];
        this.quadCoords[2] = cubeData.min[2];
        this.quadCoords[4] = cubeData.max[1];
        this.quadCoords[5] = cubeData.min[2];
        this.quadCoords[7] = cubeData.max[1];
        this.quadCoords[8] = cubeData.max[2];
        this.quadCoords[10] = cubeData.min[1];
        this.quadCoords[11] = cubeData.max[2];
    }

    private void setCoordsY(CubeData cubeData) {
        this.quadCoords[0] = cubeData.min[0];
        this.quadCoords[2] = cubeData.min[2];
        this.quadCoords[3] = cubeData.min[0];
        this.quadCoords[5] = cubeData.max[2];
        this.quadCoords[6] = cubeData.max[0];
        this.quadCoords[8] = cubeData.max[2];
        this.quadCoords[9] = cubeData.max[0];
        this.quadCoords[11] = cubeData.min[2];
    }

    private void setCoordsZ(CubeData cubeData) {
        this.quadCoords[0] = cubeData.min[0];
        this.quadCoords[1] = cubeData.min[1];
        this.quadCoords[3] = cubeData.max[0];
        this.quadCoords[4] = cubeData.min[1];
        this.quadCoords[6] = cubeData.max[0];
        this.quadCoords[7] = cubeData.max[1];
        this.quadCoords[9] = cubeData.min[0];
        this.quadCoords[10] = cubeData.max[1];
    }
}

