/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij.IJ;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.OrderedGroup;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import octree.Cube;
import octree.CubeData;
import octree.CubeDataRecycler;
import octree.ShapeGroup;
import octree.VolumeOctree;

public class OctreeBehavior
extends Behavior {
    public static final int UPDATE = 1;
    private final WakeupOnBehaviorPost updateCrit;
    private final Canvas3D canvas;
    private final VolumeOctree octree;
    private final ExecutorService updateService;
    private boolean cancelled = false;
    private boolean finished = true;
    private Transform3D volumeToImagePlate = new Transform3D();
    private Transform3D tmp = new Transform3D();

    public OctreeBehavior(Canvas3D canvas3D, VolumeOctree volumeOctree) {
        this.canvas = canvas3D;
        this.octree = volumeOctree;
        this.updateCrit = new WakeupOnBehaviorPost(null, 1);
        this.updateService = Executors.newSingleThreadExecutor();
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.updateCrit);
    }

    public synchronized void processStimulus(Enumeration enumeration) {
        System.out.println("processStim");
        while (enumeration.hasMoreElements()) {
            int n;
            Object e = enumeration.nextElement();
            if (!(e instanceof WakeupOnBehaviorPost) || (n = ((WakeupOnBehaviorPost)e).getTriggeringPostId()) != 1) continue;
            this.updateService.submit(new Runnable(){

                public void run() {
                    OctreeBehavior.this.display(OctreeBehavior.this.canvas);
                }
            });
        }
        this.wakeupOn((WakeupCondition)this.updateCrit);
    }

    public final void cancel() {
        if (!this.finished) {
            this.cancelled = true;
        }
    }

    private final void display(Canvas3D canvas3D) {
        this.finished = false;
        canvas3D.getImagePlateToVworld(this.volumeToImagePlate);
        this.volumeToImagePlate.invert();
        this.octree.getRootBranchGroup().getLocalToVworld(this.tmp);
        this.volumeToImagePlate.mul(this.tmp);
        if (this.cancelled) {
            this.octree.getRootCube().cleanup();
            return;
        }
        ArrayList<Cube> arrayList = new ArrayList<Cube>();
        this.octree.getRootCube().collectCubesToDisplay(arrayList, canvas3D, this.volumeToImagePlate, this.octree.curAxis, this.octree.curDir);
        if (this.cancelled) {
            this.octree.getRootCube().cleanup();
            return;
        }
        Object[] objectArray = new ShapeGroup[arrayList.size() * 256];
        int n = 0;
        for (Cube cube : arrayList) {
            CubeData cubeData = cube.getCubeData();
            for (ShapeGroup shapeGroup : cubeData.shapes) {
                objectArray[n++] = shapeGroup;
            }
        }
        if (this.cancelled) {
            this.octree.getRootCube().cleanup();
            return;
        }
        this.octree.removeAllCubes();
        Arrays.sort(objectArray);
        this.octree.setCombinedWhichChild();
        OrderedGroup orderedGroup = this.octree.getOrderedGroup(6);
        this.displayShapes(orderedGroup, (ShapeGroup[])objectArray, this.octree.curDir);
        CubeDataRecycler.instance().clearAll();
        if (this.cancelled) {
            System.out.println("Aborted");
            this.octree.getRootCube().cleanup();
            this.cancelled = false;
        } else {
            this.octree.setWhichChild(6);
            System.out.println("# shapes: " + this.octree.countDetailShapes());
        }
        this.finished = true;
    }

    private final void displayShapes(OrderedGroup orderedGroup, ShapeGroup[] shapeGroupArray, int n) {
        if (n == 0) {
            for (int i = shapeGroupArray.length - 1; i >= 0 && !this.cancelled; --i) {
                if (!shapeGroupArray[i].cube.cubeDataUpToDate()) {
                    shapeGroupArray[i].cube.updateCubeData();
                }
                BranchGroup branchGroup = VolumeOctree.getBranchGroup();
                branchGroup.addChild((Node)shapeGroupArray[i].shape);
                orderedGroup.insertChild((Node)branchGroup, 0);
                try {
                    Thread.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IJ.showProgress((int)(shapeGroupArray.length - i), (int)shapeGroupArray.length);
            }
        } else {
            for (int i = 0; i < shapeGroupArray.length && !this.cancelled; ++i) {
                if (!shapeGroupArray[i].cube.cubeDataUpToDate()) {
                    shapeGroupArray[i].cube.updateCubeData();
                }
                BranchGroup branchGroup = VolumeOctree.getBranchGroup();
                branchGroup.addChild((Node)shapeGroupArray[i].shape);
                orderedGroup.insertChild((Node)branchGroup, 0);
                try {
                    Thread.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                IJ.showProgress((int)i, (int)shapeGroupArray.length);
            }
        }
        IJ.showProgress((double)1.0);
    }
}

