/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.io.DirectoryChooser;
import ij.io.OpenDialog;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

public class OctreeDialog {
    private String imagePath;
    private String imageDir;
    private String name;
    private boolean dirEmpty = false;
    private boolean canceled = false;

    public void showDialog() {
        GenericDialog genericDialog = new GenericDialog("Add large volume");
        genericDialog.addStringField("Name:", "", 10);
        genericDialog.addMessage("Please specify the path to the image which you\nwant to display.\nIf you specify a directory with precomputed data\nbelow, you can leave this field empty");
        Panel panel = new Panel(new FlowLayout());
        final TextField textField = new TextField(30);
        panel.add(textField);
        Button button = new Button("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpenDialog openDialog = new OpenDialog("Image path", null);
                String string = openDialog.getDirectory();
                String string2 = openDialog.getFileName();
                if (string != null && string2 != null) {
                    File file = new File(openDialog.getDirectory(), openDialog.getFileName());
                    textField.setText(file.getAbsolutePath());
                }
            }
        });
        panel.add(button);
        genericDialog.addPanel(panel);
        genericDialog.addMessage("For displaying large volumes, much data has to be\nprecomputed. Please specify an empty directory where\nthis data can be stored. If data for this image was\nprecomputed before, please specify the directory\ncontaining it here.");
        panel = new Panel(new FlowLayout());
        final TextField textField2 = new TextField(30);
        panel.add(textField2);
        button = new Button("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectoryChooser directoryChooser = new DirectoryChooser("Data directory");
                String string = directoryChooser.getDirectory();
                if (string != null) {
                    textField2.setText(string);
                }
            }
        });
        panel.add(button);
        genericDialog.addPanel(panel);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
            return;
        }
        this.name = genericDialog.getNextString();
        this.imagePath = textField.getText();
        this.imageDir = textField2.getText();
    }

    public boolean checkUserInput() {
        if (this.canceled) {
            return false;
        }
        File file = new File(this.imageDir);
        if (!file.exists() && !file.mkdir()) {
            IJ.error((String)(this.imageDir + " does not exist and can't be created."));
            return false;
        }
        if (!file.isDirectory()) {
            IJ.error((String)(this.imageDir + " is not a directory."));
            return false;
        }
        this.dirEmpty = file.list().length == 0;
        file = new File(this.imagePath);
        if (!file.exists() && this.dirEmpty) {
            IJ.error((String)("Found an empty directory and " + this.imagePath + " does not exist"));
            return false;
        }
        if (!file.isFile() && this.dirEmpty) {
            IJ.error((String)("Found an empty directory and " + this.imagePath + " is not a valid file."));
            return false;
        }
        return true;
    }

    public boolean shouldCreateData() {
        return this.dirEmpty;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public String getImageDir() {
        return this.imageDir;
    }

    public String getName() {
        return this.name;
    }
}

