/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import adt.Byte3DArray;
import adt.ByteProbability;
import adt.Sparse3DByteArray;
import adt.Unsparse3DByteArray;
import amira.AmiraMeshDecoder;
import ij.ImagePlus;
import ij.io.FileInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oldsegmenters.SegmentatorModel;

public abstract class AutoLabeller {
    HashMap<Byte, LabelStats> stats = new LinkedHashMap<Byte, LabelStats>();
    byte[][] intensityProbabilities;
    final int labelCount;
    byte[] labelIds;
    int xMin = Integer.MAX_VALUE;
    int xMax = Integer.MIN_VALUE;
    int yMin = Integer.MAX_VALUE;
    int yMax = Integer.MIN_VALUE;
    int zMin = Integer.MAX_VALUE;
    int zMax = Integer.MIN_VALUE;

    public AutoLabeller(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        TreeSet<LabelStats> treeSet = new TreeSet<LabelStats>();
        while (string2 != null) {
            LabelStats labelStats = this.readStats(string2);
            treeSet.add(labelStats);
            System.out.println("loaded " + labelStats.toString());
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        this.labelIds = new byte[treeSet.size()];
        this.labelCount = this.labelIds.length;
        int n = 0;
        for (LabelStats labelStats : treeSet) {
            System.out.println("adding " + labelStats);
            this.stats.put(labelStats.id, labelStats);
            this.labelIds[n++] = labelStats.id;
        }
        System.out.println("summary file read");
        this.calculateLabelGivenIntensityProbabilites();
        System.out.flush();
    }

    private void calculateLabelGivenIntensityProbabilites() {
        this.intensityProbabilities = new byte[256][this.labelCount];
        double[][] dArray = new double[256][this.labelCount];
        for (int i = 0; i < 256; ++i) {
            LabelStats labelStats;
            int n;
            byte by = ByteProbability.INTEGER_TO_BYTE[i];
            double d = 0.0;
            double d2 = 0.0;
            StringBuffer stringBuffer = new StringBuffer("intesity = ").append(i).append(" ");
            for (int j = 0; j < this.labelCount; ++j) {
                LabelStats labelStats2 = this.stats.get(this.labelIds[j]);
                dArray[i][j] = labelStats2.getPixelProb(by);
                d += dArray[i][j];
                d2 += labelStats2.volumeMean;
            }
            double d3 = 0.0;
            for (n = 0; n < this.intensityProbabilities[i].length; ++n) {
                labelStats = this.stats.get(this.labelIds[n]);
                dArray[i][n] = dArray[i][n] / d;
                d3 += dArray[i][n];
            }
            for (n = 0; n < this.intensityProbabilities[i].length; ++n) {
                labelStats = this.stats.get(this.labelIds[n]);
                double[] dArray2 = dArray[i];
                int n2 = n;
                dArray2[n2] = dArray2[n2] / d3;
                this.intensityProbabilities[i][n] = ByteProbability.toByte(dArray[i][n]);
                stringBuffer.append(this.intensityProbabilities[i][n]).append(" ");
            }
            System.out.println(stringBuffer);
        }
    }

    public byte[] getIntensityProbs(byte by) {
        return this.intensityProbabilities[by & 0xFF];
    }

    public byte[] getSpatialProbs(int n, int n2, int n3) {
        byte[] byArray = new byte[this.labelCount];
        for (int i = 0; i < this.labelCount; ++i) {
            byte by = this.labelIds[i];
            LabelStats labelStats = this.stats.get(by);
            byArray[i] = labelStats.spatialDistribution.get(n, n2, n3);
        }
        return byArray;
    }

    private LabelStats readStats(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t", false);
        LabelStats labelStats = new LabelStats();
        labelStats.id = Byte.parseByte(stringTokenizer.nextToken());
        labelStats.name = stringTokenizer.nextToken();
        labelStats.volumeMean = Double.parseDouble(stringTokenizer.nextToken());
        labelStats.volumeVariance = Double.parseDouble(stringTokenizer.nextToken());
        for (int i = 0; i < 256; ++i) {
            labelStats.pixelProb[i] = Double.parseDouble(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken();
            ImagePlus imagePlus = new ImagePlus();
            AmiraMeshDecoder amiraMeshDecoder = new AmiraMeshDecoder();
            if (amiraMeshDecoder.open(string2)) {
                if (amiraMeshDecoder.isTable()) {
                    object = amiraMeshDecoder.getTable();
                } else {
                    object = new FileInfo();
                    File file = new File(string2);
                    ((FileInfo)object).fileName = file.getName();
                    ((FileInfo)object).directory = file.getParent();
                    imagePlus.setFileInfo((FileInfo)object);
                    imagePlus.setStack(string2, amiraMeshDecoder.getStack());
                    amiraMeshDecoder.parameters.setParameters(imagePlus);
                }
            }
            object = labelStats.id != 0 ? new Sparse3DByteArray() : new Unsparse3DByteArray(imagePlus.getWidth(), imagePlus.getHeight(), imagePlus.getStackSize());
            int n = imagePlus.getWidth();
            for (int i = 1; i <= imagePlus.getStackSize(); ++i) {
                byte[] byArray = (byte[])imagePlus.getStack().getProcessor(i).getPixels();
                for (int j = 0; j < byArray.length; ++j) {
                    byte by = byArray[j];
                    if (by == 0) continue;
                    object.put(j % n, j / n, i, by);
                }
            }
            labelStats.spatialDistribution = object;
            if (labelStats.id != 0) {
                this.xMin = Math.min(object.getxMin(), this.xMin);
                this.xMax = Math.max(object.getxMax(), this.xMax);
                this.yMin = Math.min(object.getyMin(), this.yMin);
                this.yMax = Math.max(object.getyMax(), this.yMax);
                this.zMin = Math.min(object.getzMin(), this.zMin);
                this.zMax = Math.max(object.getzMax(), this.zMax);
            }
            imagePlus.close();
        }
        return labelStats;
    }

    public abstract void segment(SegmentatorModel var1);

    public class LabelStats
    implements Comparable {
        byte id;
        String name;
        double volumeMean;
        double volumeVariance;
        Byte3DArray spatialDistribution;
        double[] pixelProb = new double[256];

        public double getPixelProb(byte by) {
            return this.pixelProb[by & 0xFF];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.name).append(" ");
            stringBuffer.append(this.id & 0xFF).append(" ");
            stringBuffer.append("[");
            stringBuffer.append(this.spatialDistribution.getxMin()).append(", ");
            stringBuffer.append(this.spatialDistribution.getxMax()).append(", ");
            stringBuffer.append(this.spatialDistribution.getyMin()).append(", ");
            stringBuffer.append(this.spatialDistribution.getyMax()).append(", ");
            stringBuffer.append(this.spatialDistribution.getzMin()).append(", ");
            stringBuffer.append(this.spatialDistribution.getzMax()).append("]");
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            return ((LabelStats)object).id < this.id ? 1 : -1;
        }
    }
}

