/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.OvalRoi;
import ij.gui.Roi;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.Rectangle;
import oldsegmenters.SegmentatorModel;

public class LabelBrush_
implements PlugIn {
    public static final String MACRO_CMD = "var brushWidth = 10;\nvar leftClick=16, altOrShift=9;\nvar pollDelay = 10;\nmacro \"Show Current Label [l]\" { label=call('LabelBrush_.getLabelMessage')\n showStatus(label);\n}\nmacro 'Label Brush Tool - C111O11ffC100T6c0aL' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('LabelBrush_.label', x,y,z,flags,brushWidth);\n  }else{\n   call('LabelBrush_.unlabel', x,y,z,flags,brushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Label Brush Tool Options...' {\n brushWidth = getNumber('Label Brush Width (pixels):', brushWidth);\n}";

    public void run(String string) {
        System.out.println("run of LabelBrush_ ...");
        if (IJ.versionLessThan((String)"1.37c")) {
            System.err.println("Version too old");
            return;
        }
        System.out.println("loading LabelBrushTool");
        MacroInstaller macroInstaller = new MacroInstaller();
        macroInstaller.install(MACRO_CMD);
    }

    public static synchronized void label(String string, String string2, String string3, String string4, String string5) {
        LabelBrush_.label((int)Float.parseFloat(string), (int)Float.parseFloat(string2), (int)Float.parseFloat(string3), (int)Float.parseFloat(string4), (int)Float.parseFloat(string5));
    }

    public static synchronized void unlabel(String string, String string2, String string3, String string4, String string5) {
        LabelBrush_.unlabel((int)Float.parseFloat(string), (int)Float.parseFloat(string2), (int)Float.parseFloat(string3), (int)Float.parseFloat(string4), (int)Float.parseFloat(string5));
    }

    public static void label(int n, int n2, int n3, int n4, int n5) {
        LabelBrush_.labelROI(LabelBrush_.getBrushRoi(n, n2, n5), LabelBrush_.getProcessor(++n3), LabelBrush_.getColor());
        LabelBrush_.updateSlice(n3);
    }

    public static void unlabel(int n, int n2, int n3, int n4, int n5) {
        LabelBrush_.labelROI(LabelBrush_.getBrushRoi(n, n2, n5), LabelBrush_.getProcessor(++n3), 0);
        LabelBrush_.updateSlice(n3);
    }

    private static ImageProcessor getProcessor(int n) {
        return new SegmentatorModel(IJ.getImage()).getLabelImagePlus().getStack().getProcessor(n);
    }

    public static String getLabelMessage() {
        String string;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"showLabel: No current image.");
            return "";
        }
        ImageCanvas imageCanvas = imagePlus.getCanvas();
        Point point = imageCanvas.getCursorLoc();
        int n = point.x;
        int n2 = point.y;
        int n3 = imagePlus.getCurrentSlice() - 1;
        ImagePlus imagePlus2 = new SegmentatorModel(imagePlus).getLabelImagePlus();
        if (imagePlus2 == null) {
            IJ.error((String)"showLabel: No label field for this image.");
            return "No label field found for: " + imagePlus.getTitle();
        }
        ImageProcessor imageProcessor = imagePlus2.getStack().getProcessor(n3 + 1);
        int n4 = imageProcessor.getPixel(n, n2);
        if (n4 == 255) {
            string = "No label at (" + n + "," + n2 + "," + n3 + ") in " + imagePlus2.getTitle();
        } else {
            AmiraParameters amiraParameters = new SegmentatorModel(IJ.getImage()).getMaterialParams();
            String string2 = amiraParameters.getMaterialName(n4);
            string = "Current material is: " + string2 + " at (" + n + "," + n2 + "," + n3 + ") in " + imagePlus2.getTitle();
        }
        return string;
    }

    private static int getColor() {
        AmiraParameters.Material material = new SegmentatorModel(IJ.getImage()).getCurrentMaterial();
        if (material == null) {
            return 0;
        }
        return material.id;
    }

    private static void updateSlice(int n) {
        new SegmentatorModel(IJ.getImage()).updateSlice(n);
    }

    public static Roi getBrushRoi(int n, int n2, int n3) {
        return new OvalRoi(n - n3 / 2, n2 - n3 / 2, n3, n3);
    }

    public static void labelROI(Roi roi, ImageProcessor imageProcessor, int n) {
        Rectangle rectangle = roi.getBoundingRect();
        for (int i = rectangle.x; i <= rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y; j <= rectangle.y + rectangle.height; ++j) {
                if (!roi.contains(i, j)) continue;
                imageProcessor.set(i, j, n);
            }
        }
    }
}

