/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import oldsegmenters.SegmentatorModel;

public class LabelThresholder_
implements PlugInFilter {
    static Mem mem;
    public static int min;
    public static int max;

    public int setup(String string, ImagePlus imagePlus) {
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        SegmentatorModel segmentatorModel = new SegmentatorModel(IJ.getImage());
        int n = segmentatorModel.data.getCurrentSlice();
        ImageProcessor imageProcessor2 = segmentatorModel.data.getStack().getProcessor(n);
        ImageProcessor imageProcessor3 = segmentatorModel.getLabelImagePlus().getStack().getProcessor(n);
        if (segmentatorModel.getCurrentMaterial() == null) {
            IJ.showMessage((String)"please select a label first");
            return;
        }
        if (segmentatorModel.data.getRoi() == null) {
            IJ.error((String)"You need to have a region of interest selected in order to threshold an area.");
            return;
        }
        LabelThresholder_.threshold(segmentatorModel.data.getRoi(), min, max, imageProcessor2, imageProcessor3, segmentatorModel.getCurrentMaterial().id);
        segmentatorModel.updateSlice(n);
    }

    public static void rollback() {
        SegmentatorModel segmentatorModel = new SegmentatorModel(IJ.getImage());
        int n = segmentatorModel.data.getCurrentSlice();
        if (mem != null) {
            mem.restore();
        }
        segmentatorModel.updateSlice(n);
    }

    public static void commit() {
        if (mem != null) {
            mem.clear();
        }
    }

    public static void threshold(Roi roi, int n, int n2, ImageProcessor imageProcessor, ImageProcessor imageProcessor2, int n3) {
        mem = new Mem(imageProcessor2);
        Rectangle rectangle = roi.getBoundingRect();
        for (int i = rectangle.x; i <= rectangle.x + rectangle.width; ++i) {
            for (int j = rectangle.y; j <= rectangle.y + rectangle.height; ++j) {
                if (!roi.contains(i, j) || imageProcessor.get(i, j) < n || imageProcessor.get(i, j) > n2) continue;
                mem.rememberPixel(i, j);
                imageProcessor2.set(i, j, n3);
            }
        }
    }

    static {
        min = 5;
        max = 100;
    }

    static class Mem {
        ImageProcessor data;
        HashMap<Point, Integer> memory = new HashMap();

        public Mem(ImageProcessor imageProcessor) {
            this.data = imageProcessor;
        }

        public void rememberPixel(int n, int n2) {
            this.memory.put(new Point(n, n2), this.data.get(n, n2));
        }

        public void restore() {
            for (Point point : this.memory.keySet()) {
                this.data.set(point.x, point.y, this.memory.get(point).intValue());
            }
        }

        public void clear() {
            this.memory.clear();
        }
    }
}

