/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraParameters;
import ij.ImagePlus;
import vib.SegmentationViewerCanvas;

public class SegmentatorModel {
    final ImagePlus data;
    public static final String LABEL_IMAGE_PLUS = "SegmentatorModel.labels";
    public static final String LABEL_CANVAS = "SegmentatorModel.labels.canvas";
    public static final String CURRENT_MATERIAL = "SegmentatorModel.currentMaterial";

    public SegmentatorModel(ImagePlus imagePlus) {
        this.data = imagePlus;
    }

    public ImagePlus getLabelImagePlus() {
        return (ImagePlus)this.data.getProperty(LABEL_IMAGE_PLUS);
    }

    public void setLabelImagePlus(ImagePlus imagePlus) {
        this.data.setProperty(LABEL_IMAGE_PLUS, (Object)imagePlus);
    }

    public ImagePlus getOriginalImage() {
        return this.data;
    }

    public SegmentationViewerCanvas getLabelCanvas() {
        return (SegmentationViewerCanvas)((Object)this.data.getProperty(LABEL_CANVAS));
    }

    public void setLabelCanvas(SegmentationViewerCanvas segmentationViewerCanvas) {
        this.data.setProperty(LABEL_CANVAS, (Object)segmentationViewerCanvas);
    }

    public AmiraParameters getMaterialParams() {
        if (this.getLabelImagePlus() == null) {
            return null;
        }
        return new AmiraParameters(this.getLabelImagePlus());
    }

    public void setCurrentMaterial(AmiraParameters.Material material) {
        this.data.setProperty(CURRENT_MATERIAL, (Object)material);
    }

    public AmiraParameters.Material getCurrentMaterial() {
        return (AmiraParameters.Material)this.data.getProperty(CURRENT_MATERIAL);
    }

    public void updateSlice(int n) {
        this.getLabelCanvas().updateSlice(n);
        this.data.updateAndDraw();
    }

    public void updateSliceNoRedraw(int n) {
        this.getLabelCanvas().updateSlice(n);
    }
}

