/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import amira.AmiraTableEncoder;
import events.RoiEvent;
import events.RoiListener;
import events.SliceEvent;
import events.SliceListener;
import events.SliceWatcher;
import gui.GuiBuilder;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.io.SaveDialog;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oldsegmenters.AutoLabellerNaive;
import oldsegmenters.LabelBinaryOps;
import oldsegmenters.LabelThresholder_;
import oldsegmenters.SegmentatorModel;
import vib.SegmentationViewerCanvas;

public class Segmentator_
extends JFrame
implements PlugIn {
    private static final String LOAD_IMAGE = "load image";
    private static final String SAVE_IMAGE = "save image";
    private static final String LOAD_LABELS = "load labels";
    private static final String SAVE_LABELS = "save labels";
    private static final String LOAD_MATERIALS = "load materials";
    private static final String THRESHOLD = "threshold";
    private static final String THRESHOLD_UNDO = "undo";
    private static final String INTERPOLATOR = "interpolate";
    private static final String DILATE = "dilate";
    private static final String ERODE = "erode";
    private static final String OPEN = "open";
    private static final String CLOSE = "close";
    private static final String CLEAN = "clean";
    private static final String NAIVE_LABEL = "naive auto label (optic lobes)";
    JList labelList;
    DefaultListModel labelListModel;
    JSpinner minThreshold;
    JSpinner maxThreshold;
    JTextField autoLabelFileLoc;

    public Segmentator_() {
        super("segmentator");
        Controllor controllor = new Controllor();
        MacroInstaller macroInstaller = new MacroInstaller();
        macroInstaller.install("var brushWidth = 10;\nvar leftClick=16, altOrShift=9;\nvar pollDelay = 10;\nmacro \"Show Current Label [l]\" { label=call('LabelBrush_.getLabelMessage')\n showStatus(label);\n}\nmacro 'Label Brush Tool - C111O11ffC100T6c0aL' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('LabelBrush_.label', x,y,z,flags,brushWidth);\n  }else{\n   call('LabelBrush_.unlabel', x,y,z,flags,brushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Label Brush Tool Options...' {\n brushWidth = getNumber('Label Brush Width (pixels):', brushWidth);\n}");
        ImagePlus.addImageListener((ImageListener)controllor);
        for (Frame frame : ImageWindow.getFrames()) {
            if (!(frame instanceof ImageWindow)) continue;
            controllor.imageOpened(((ImageWindow)frame).getImagePlus());
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.labelList = Segmentator_.addLabelList(this);
        this.labelListModel = (DefaultListModel)this.labelList.getModel();
        this.labelList.addListSelectionListener(controllor);
        GuiBuilder.add2Command(this, LOAD_IMAGE, LOAD_IMAGE, SAVE_IMAGE, SAVE_IMAGE, controllor);
        GuiBuilder.add2Command(this, LOAD_LABELS, LOAD_LABELS, SAVE_LABELS, SAVE_LABELS, controllor);
        GuiBuilder.addCommand(this, LOAD_MATERIALS, LOAD_MATERIALS, controllor);
        this.minThreshold = GuiBuilder.addLabeledNumericSpinner(this, "min", 45, 0, 255, controllor);
        this.maxThreshold = GuiBuilder.addLabeledNumericSpinner(this, "max", 255, 0, 255, controllor);
        GuiBuilder.add2Command(this, THRESHOLD, THRESHOLD, THRESHOLD_UNDO, THRESHOLD_UNDO, controllor);
        GuiBuilder.addCommand(this, INTERPOLATOR, INTERPOLATOR, controllor);
        GuiBuilder.add2Command(this, DILATE, DILATE, ERODE, ERODE, controllor);
        GuiBuilder.add2Command(this, OPEN, OPEN, CLOSE, CLOSE, controllor);
        GuiBuilder.addCommand(this, CLEAN, CLEAN, controllor);
        this.autoLabelFileLoc = GuiBuilder.addFileField(this, "auto label file loc (av intensity");
        GuiBuilder.addCommand(this, NAIVE_LABEL, NAIVE_LABEL, controllor);
        this.pack();
    }

    public void run(String string) {
        this.setVisible(!this.isVisible());
    }

    public void clearLabelsList() {
        this.labelListModel.clear();
    }

    public void populateLabelList(AmiraParameters amiraParameters) {
        this.clearLabelsList();
        if (amiraParameters == null) {
            return;
        }
        for (int i = 0; i < amiraParameters.getMaterialCount(); ++i) {
            this.labelListModel.addElement(amiraParameters.getMaterial(i));
        }
    }

    public AmiraParameters.Material getCurrentMaterial() {
        int n = this.labelList.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (AmiraParameters.Material)this.labelListModel.get(n);
    }

    private void threshold() {
        LabelThresholder_.min = ((SpinnerNumberModel)this.minThreshold.getModel()).getNumber().intValue();
        LabelThresholder_.max = ((SpinnerNumberModel)this.maxThreshold.getModel()).getNumber().intValue();
        IJ.runPlugIn((String)"LabelThresholder_", (String)"");
    }

    public static JList addLabelList(Container container) {
        DefaultListModel defaultListModel = new DefaultListModel();
        JList jList = new JList(defaultListModel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("labels..."), "North");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel.add(new JScrollPane(jList));
        container.add(jPanel);
        return jList;
    }

    private class Controllor
    implements ActionListener,
    ImageListener,
    WindowFocusListener,
    SliceListener,
    RoiListener,
    ListSelectionListener,
    ChangeListener {
        ImagePlus currentImage;

        private Controllor() {
        }

        public void writeImage(Object object) {
            SaveDialog saveDialog = new SaveDialog("AmiraFile", null, ".am");
            String string = saveDialog.getDirectory();
            String string2 = saveDialog.getFileName();
            if (string2 == null) {
                return;
            }
            if (object instanceof TextWindow) {
                TextWindow textWindow = (TextWindow)object;
                AmiraTableEncoder amiraTableEncoder = new AmiraTableEncoder(textWindow);
                if (!amiraTableEncoder.write(string + string2)) {
                    IJ.error((String)("Could not write to " + string + string2));
                }
                return;
            }
            AmiraMeshEncoder amiraMeshEncoder = new AmiraMeshEncoder(string + string2);
            if (!amiraMeshEncoder.open()) {
                IJ.error((String)("Could not write " + string + string2));
                return;
            }
            if (!amiraMeshEncoder.write((ImagePlus)object)) {
                IJ.error((String)("Error writing " + string + string2));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(Segmentator_.LOAD_IMAGE)) {
                IJ.runPlugIn((String)"AmiraMeshReader_", (String)"");
                if (AmiraParameters.isAmiraLabelfield(IJ.getImage())) {
                    IJ.showMessage((String)"file was not an image file");
                } else {
                    this.updateCurrent(IJ.getImage());
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.SAVE_IMAGE)) {
                IJ.runPlugIn((String)"AmiraMeshWriter_", (String)"");
            } else if (actionEvent.getActionCommand().equals(Segmentator_.LOAD_LABELS)) {
                IJ.runPlugIn((String)"AmiraMeshReader_", (String)"");
                if (AmiraParameters.isAmiraLabelfield(IJ.getImage())) {
                    this.loadLabels(IJ.getImage());
                } else {
                    IJ.showMessage((String)"file was not a labels file");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.SAVE_LABELS)) {
                this.writeImage(new SegmentatorModel(this.currentImage).getLabelImagePlus());
            } else if (actionEvent.getActionCommand().equals(Segmentator_.LOAD_MATERIALS)) {
                IJ.runPlugIn((String)"AmiraMeshReader_", (String)"");
                if (AmiraParameters.isAmiraLabelfield(IJ.getImage())) {
                    this.loadMaterials(IJ.getImage());
                } else {
                    IJ.showMessage((String)"file was not a labels file");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.THRESHOLD)) {
                Segmentator_.this.threshold();
            } else if (actionEvent.getActionCommand().equals(Segmentator_.THRESHOLD_UNDO)) {
                LabelThresholder_.rollback();
            } else if (actionEvent.getActionCommand().equals(Segmentator_.INTERPOLATOR)) {
                IJ.runPlugIn((String)"LabelInterpolator_", (String)"");
            } else if (actionEvent.getActionCommand().equals(Segmentator_.DILATE)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.dilate(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.ERODE)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                System.out.println("eroding");
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.erode(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.CLOSE)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.close(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.OPEN)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.open(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.CLEAN)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.close(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    LabelBinaryOps.open(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmentator_.NAIVE_LABEL)) {
                new RunAsyncronous(actionEvent.getActionCommand()).start();
            }
            if (this.currentImage != null) {
                this.currentImage.updateAndDraw();
            }
        }

        private void loadMaterials(ImagePlus imagePlus) {
            AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
            System.out.println("currentImage.getStackSize() = " + this.currentImage.getStackSize());
            IJ.newImage((String)"new", (String)"8-bit", (int)this.currentImage.getWidth(), (int)this.currentImage.getHeight(), (int)this.currentImage.getStackSize());
            ImagePlus imagePlus2 = IJ.getImage();
            imagePlus2.setProperty("Info", imagePlus.getProperty("Info"));
            AmiraParameters amiraParameters2 = new AmiraParameters(imagePlus2);
            imagePlus.close();
            this.loadLabels(imagePlus2);
        }

        private void loadLabels(ImagePlus imagePlus) {
            imagePlus.hide();
            new SegmentatorModel(this.currentImage).setLabelImagePlus(imagePlus);
            AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
            Segmentator_.this.populateLabelList(amiraParameters);
            SegmentationViewerCanvas segmentationViewerCanvas = new SegmentationViewerCanvas(this.currentImage, imagePlus);
            new SegmentatorModel(this.currentImage).setLabelCanvas(segmentationViewerCanvas);
            if (this.currentImage.getStackSize() > 1) {
                new StackWindow(this.currentImage, (ImageCanvas)segmentationViewerCanvas);
            } else {
                new ImageWindow(this.currentImage, (ImageCanvas)segmentationViewerCanvas);
            }
            new SliceWatcher(this.currentImage).addSliceListener(this);
            this.currentImage.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void imageOpened(ImagePlus imagePlus) {
            imagePlus.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void imageClosed(ImagePlus imagePlus) {
            imagePlus.getWindow().removeWindowFocusListener((WindowFocusListener)this);
        }

        public void imageUpdated(ImagePlus imagePlus) {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            this.updateCurrent(IJ.getImage());
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }

        private void updateCurrent(ImagePlus imagePlus) {
            if (imagePlus == this.currentImage) {
                return;
            }
            if (this.currentImage != null) {
                new SliceWatcher(this.currentImage).removeSliceListener(this);
            }
            if (imagePlus != null) {
                System.out.println("newCurrent = " + imagePlus);
                new SliceWatcher(imagePlus).addSliceListener(this);
                Segmentator_.this.labelList.removeListSelectionListener(this);
                Segmentator_.this.populateLabelList(new SegmentatorModel(imagePlus).getMaterialParams());
                Segmentator_.this.labelList.addListSelectionListener(this);
            }
            this.currentImage = imagePlus;
        }

        public void sliceNumberChanged(SliceEvent sliceEvent) {
            LabelThresholder_.commit();
        }

        public void roiChanged(RoiEvent roiEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            new SegmentatorModel(this.currentImage).setCurrentMaterial(Segmentator_.this.getCurrentMaterial());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if ((changeEvent.getSource().equals(Segmentator_.this.minThreshold) || changeEvent.getSource().equals(Segmentator_.this.maxThreshold)) && this.currentImage.getRoi() != null) {
                LabelThresholder_.rollback();
                Segmentator_.this.threshold();
            }
        }

        private class RunAsyncronous
        extends Thread {
            String cmd;

            public RunAsyncronous(String string) {
                this.cmd = string;
            }

            public void run() {
                if (this.cmd.equals(Segmentator_.NAIVE_LABEL)) {
                    try {
                        AutoLabellerNaive autoLabellerNaive = new AutoLabellerNaive(Segmentator_.this.autoLabelFileLoc.getText());
                        autoLabellerNaive.segment(new SegmentatorModel(Controllor.this.currentImage));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }
}

