/*
 * Decompiled with CFR 0.152.
 */
package oldsegmenters;

import amira.AmiraMeshDecoder;
import amira.AmiraMeshEncoder;
import amira.AmiraParameters;
import events.RoiEvent;
import events.RoiListener;
import events.SliceEvent;
import events.SliceListener;
import events.SliceWatcher;
import gui.GuiBuilder;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.plugin.MacroInstaller;
import ij.plugin.PlugIn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oldsegmenters.ChoicesDialog;
import oldsegmenters.LabelBinaryOps;
import oldsegmenters.LabelThresholder_;
import oldsegmenters.SegmentatorModel;
import vib.SegmentationViewerCanvas;

public class Segmenter_
extends JFrame
implements PlugIn {
    private static final String SAVE_LABELS = "save labels";
    private static final String LABEL_CURRENT = "label current";
    private static final String THRESHOLD = "threshold";
    private static final String THRESHOLD_UNDO = "undo";
    private static final String INTERPOLATOR = "interpolate";
    private static final String DILATE = "dilate";
    private static final String ERODE = "erode";
    private static final String OPEN = "open";
    private static final String CLOSE = "close";
    private static final String CLEAN = "clean";
    JList labelList;
    DefaultListModel labelListModel;
    JSpinner minThreshold;
    JSpinner maxThreshold;
    JLabel markingLabel;

    public Segmenter_() {
        super("VIB Manual Segmenter");
        Controllor controllor = new Controllor();
        MacroInstaller macroInstaller = new MacroInstaller();
        macroInstaller.install("var brushWidth = 10;\nvar leftClick=16, altOrShift=9;\nvar pollDelay = 10;\nmacro \"Show Current Label [l]\" { label=call('LabelBrush_.getLabelMessage')\n showStatus(label);\n}\nmacro 'Label Brush Tool - C111O11ffC100T6c0aL' {\n while (true) {\n  getCursorLoc(x, y, z, flags);\n  if (flags&leftClick==0) exit();\n  if (flags&altOrShift==0){\n   call('LabelBrush_.label', x,y,z,flags,brushWidth);\n  }else{\n   call('LabelBrush_.unlabel', x,y,z,flags,brushWidth);\n  }\n  wait(pollDelay);\n }\n}\n\nmacro 'Label Brush Tool Options...' {\n brushWidth = getNumber('Label Brush Width (pixels):', brushWidth);\n}");
        ImagePlus.addImageListener((ImageListener)controllor);
        for (Frame frame : ImageWindow.getFrames()) {
            if (!(frame instanceof ImageWindow)) continue;
            controllor.imageOpened(((ImageWindow)frame).getImagePlus());
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.labelList = Segmenter_.addLabelList(this);
        this.labelListModel = (DefaultListModel)this.labelList.getModel();
        this.labelList.addListSelectionListener(controllor);
        this.markingLabel = new JLabel("current image: <no current image>");
        Box box = new Box(0);
        box.add(this.markingLabel);
        this.add(box);
        GuiBuilder.add2Command(this, LABEL_CURRENT, LABEL_CURRENT, SAVE_LABELS, SAVE_LABELS, controllor);
        this.minThreshold = GuiBuilder.addLabeledNumericSpinner(this, "min", 45, 0, 255, controllor);
        this.maxThreshold = GuiBuilder.addLabeledNumericSpinner(this, "max", 255, 0, 255, controllor);
        GuiBuilder.add2Command(this, THRESHOLD, THRESHOLD, THRESHOLD_UNDO, THRESHOLD_UNDO, controllor);
        GuiBuilder.addCommand(this, INTERPOLATOR, INTERPOLATOR, controllor);
        GuiBuilder.add2Command(this, DILATE, DILATE, ERODE, ERODE, controllor);
        GuiBuilder.add2Command(this, OPEN, OPEN, CLOSE, CLOSE, controllor);
        GuiBuilder.addCommand(this, CLEAN, CLEAN, controllor);
        this.pack();
    }

    public void run(String string) {
        this.setVisible(!this.isVisible());
    }

    public void clearLabelsList() {
        this.labelListModel.clear();
    }

    public void populateLabelList(AmiraParameters amiraParameters) {
        this.clearLabelsList();
        if (amiraParameters == null) {
            return;
        }
        for (int i = 0; i < amiraParameters.getMaterialCount(); ++i) {
            this.labelListModel.addElement(amiraParameters.getMaterial(i));
        }
    }

    public AmiraParameters.Material getCurrentMaterial() {
        int n = this.labelList.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (AmiraParameters.Material)this.labelListModel.get(n);
    }

    private void threshold() {
        LabelThresholder_.min = ((SpinnerNumberModel)this.minThreshold.getModel()).getNumber().intValue();
        LabelThresholder_.max = ((SpinnerNumberModel)this.maxThreshold.getModel()).getNumber().intValue();
        IJ.runPlugIn((String)"LabelThresholder_", (String)"");
    }

    public static JList addLabelList(Container container) {
        DefaultListModel defaultListModel = new DefaultListModel();
        JList jList = new JList(defaultListModel);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel("labels..."), "North");
        JPanel jPanel2 = new JPanel(new GridLayout(1, 2));
        jPanel.add(new JScrollPane(jList));
        container.add(jPanel);
        return jList;
    }

    private class Controllor
    implements ActionListener,
    ImageListener,
    WindowFocusListener,
    SliceListener,
    RoiListener,
    ListSelectionListener,
    ChangeListener {
        ImagePlus currentImage;

        private Controllor() {
        }

        public void saveLabelFile() {
            FileInfo fileInfo = this.currentImage.getOriginalFileInfo();
            if (fileInfo == null) {
                IJ.error((String)"There's no original file name associated with this image.");
                return;
            }
            String string = fileInfo.directory;
            String string2 = fileInfo.fileName;
            String string3 = string2 + ".labels";
            SaveDialog saveDialog = new SaveDialog("Save label annotation as...", string, string3, ".labels");
            if (saveDialog.getFileName() == null) {
                return;
            }
            String string4 = saveDialog.getDirectory() + saveDialog.getFileName();
            File file = new File(string4);
            if (file != null && file.exists() && !IJ.showMessageWithCancel((String)"Save label annotation file...", (String)("The file " + string4 + " already exists.\n" + "Do you want to replace it?"))) {
                return;
            }
            IJ.showStatus((String)("Saving label annotations to " + string4));
            AmiraMeshEncoder amiraMeshEncoder = new AmiraMeshEncoder(string4);
            if (!amiraMeshEncoder.open()) {
                IJ.error((String)("Could not write to " + string4));
                return;
            }
            if (amiraMeshEncoder.write(new SegmentatorModel(this.currentImage).getLabelImagePlus())) {
                IJ.showStatus((String)"Label file saved.");
            } else {
                IJ.error((String)("Error writing to: " + string4));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(Segmenter_.SAVE_LABELS)) {
                this.saveLabelFile();
            } else if (actionEvent.getActionCommand().equals(Segmenter_.LABEL_CURRENT)) {
                this.labelCurrent();
            } else if (actionEvent.getActionCommand().equals(Segmenter_.THRESHOLD)) {
                Segmenter_.this.threshold();
            } else if (actionEvent.getActionCommand().equals(Segmenter_.THRESHOLD_UNDO)) {
                LabelThresholder_.rollback();
            } else if (actionEvent.getActionCommand().equals(Segmenter_.INTERPOLATOR)) {
                IJ.runPlugIn((String)"LabelInterpolator_", (String)"");
            } else if (actionEvent.getActionCommand().equals(Segmenter_.DILATE)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.dilate(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmenter_.ERODE)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                System.out.println("eroding");
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.erode(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmenter_.CLOSE)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.close(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmenter_.OPEN)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.open(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            } else if (actionEvent.getActionCommand().equals(Segmenter_.CLEAN)) {
                SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
                if (segmentatorModel.getCurrentMaterial() != null) {
                    LabelBinaryOps.close(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    LabelBinaryOps.open(segmentatorModel.getLabelImagePlus().getStack().getProcessor(this.currentImage.getCurrentSlice()), this.currentImage.getRoi(), (byte)segmentatorModel.getCurrentMaterial().id);
                    segmentatorModel.updateSlice(this.currentImage.getCurrentSlice());
                } else {
                    IJ.showMessage((String)"please select a label first");
                }
            }
            if (this.currentImage != null) {
                this.currentImage.updateAndDraw();
            }
        }

        private void loadDefaultMaterials() {
            Segmenter_.this.populateLabelList(AmiraParameters.defaultMaterials());
        }

        public void imageOpened(ImagePlus imagePlus) {
            imagePlus.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void imageClosed(ImagePlus imagePlus) {
            imagePlus.getWindow().removeWindowFocusListener((WindowFocusListener)this);
        }

        public void imageUpdated(ImagePlus imagePlus) {
        }

        public void windowGainedFocus(WindowEvent windowEvent) {
            this.updateCurrent(IJ.getImage());
        }

        public void windowLostFocus(WindowEvent windowEvent) {
        }

        private void updateCurrent(ImagePlus imagePlus) {
            if (imagePlus == this.currentImage) {
                return;
            }
            if (this.currentImage != null) {
                new SliceWatcher(this.currentImage).removeSliceListener(this);
            }
            if (imagePlus == null) {
                Segmenter_.this.markingLabel.setText("current image: <no current image>");
            } else {
                Segmenter_.this.markingLabel.setText("current image: \"" + imagePlus.getTitle() + "\"");
                new SliceWatcher(imagePlus).addSliceListener(this);
                SegmentatorModel segmentatorModel = new SegmentatorModel(imagePlus);
                AmiraParameters amiraParameters = segmentatorModel.getMaterialParams();
                Segmenter_.this.labelList.removeListSelectionListener(this);
                if (amiraParameters == null) {
                    Segmenter_.this.clearLabelsList();
                } else {
                    Segmenter_.this.populateLabelList(amiraParameters);
                }
                Segmenter_.this.labelList.addListSelectionListener(this);
            }
            this.currentImage = imagePlus;
        }

        public void labelCurrent() {
            if (this.currentImage == null) {
                IJ.error((String)"There's no current image.");
                return;
            }
            if (this.currentImage.getType() != 0) {
                IJ.error((String)"You can only label 8 bit images at the moment.");
                return;
            }
            FileInfo fileInfo = this.currentImage.getOriginalFileInfo();
            if (fileInfo == null) {
                IJ.error((String)"There's no original file name associated with this image. Please save it first.");
                return;
            }
            SegmentatorModel segmentatorModel = new SegmentatorModel(this.currentImage);
            if (segmentatorModel.getLabelImagePlus() != null) {
                IJ.error((String)("The current image (" + this.currentImage.getTitle() + ") already has a label field associated with it."));
                return;
            }
            ImagePlus imagePlus = null;
            Object object = fileInfo.directory;
            Object object2 = fileInfo.fileName;
            File file = new File((String)object, (String)object2 + ".labels");
            if (file.exists()) {
                AmiraMeshDecoder amiraMeshDecoder;
                String[] stringArray = new String[]{"Load corresponding label file", "Start with an empty label field"};
                ChoicesDialog choicesDialog = new ChoicesDialog((Frame)IJ.getInstance(), "Load default label file?", "There's a label file with the expected corresponding name to this file: '" + file.getName() + "'.\nDo you want to load it, or start again with an empty label field?", stringArray);
                if (choicesDialog.optionChosen(0) && (amiraMeshDecoder = new AmiraMeshDecoder()).open(file.getPath())) {
                    imagePlus = new ImagePlus();
                    FileInfo fileInfo2 = new FileInfo();
                    fileInfo2.fileName = file.getName();
                    fileInfo2.directory = file.getParent();
                    imagePlus.setFileInfo(fileInfo2);
                    imagePlus.setStack("labels in " + file.getName(), amiraMeshDecoder.getStack());
                    amiraMeshDecoder.parameters.setParameters(imagePlus);
                }
            }
            if (imagePlus == null) {
                imagePlus = IJ.createImage((String)("labels for " + this.currentImage.getTitle()), (String)"8-bit", (int)this.currentImage.getWidth(), (int)this.currentImage.getHeight(), (int)this.currentImage.getStackSize());
                imagePlus.setProperty("Info", (Object)AmiraParameters.defaultMaterialsString);
            }
            object2 = new AmiraParameters(imagePlus);
            Segmenter_.this.labelList.removeListSelectionListener(this);
            Segmenter_.this.populateLabelList((AmiraParameters)object2);
            Segmenter_.this.labelList.addListSelectionListener(this);
            imagePlus.getProcessor().setColorModel(((AmiraParameters)object2).getColorModel());
            segmentatorModel.setLabelImagePlus(imagePlus);
            object = new SegmentationViewerCanvas(this.currentImage, imagePlus);
            segmentatorModel.setLabelCanvas((SegmentationViewerCanvas)((Object)object));
            if (this.currentImage.getStackSize() > 1) {
                new StackWindow(this.currentImage, (ImageCanvas)object);
            } else {
                new ImageWindow(this.currentImage, (ImageCanvas)object);
            }
            new SliceWatcher(this.currentImage).addSliceListener(this);
            IJ.runPlugIn((String)"ij.plugin.LutLoader", (String)"grays");
            this.currentImage.getWindow().addWindowFocusListener((WindowFocusListener)this);
        }

        public void sliceNumberChanged(SliceEvent sliceEvent) {
            LabelThresholder_.commit();
        }

        public void roiChanged(RoiEvent roiEvent) {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            new SegmentatorModel(this.currentImage).setCurrentMaterial(Segmenter_.this.getCurrentMaterial());
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if ((changeEvent.getSource().equals(Segmenter_.this.minThreshold) || changeEvent.getSource().equals(Segmenter_.this.maxThreshold)) && this.currentImage.getRoi() != null) {
                LabelThresholder_.rollback();
                Segmenter_.this.threshold();
            }
        }
    }
}

