/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.GammaFunction;

public class ErrorFunction {
    public static double erf(double d) {
        if (d > 0.0) {
            return GammaFunction.incompleteGammaP(0.5, d * d);
        }
        if (d < 0.0) {
            return -GammaFunction.incompleteGammaP(0.5, d * d);
        }
        return 0.0;
    }

    public static double erfc(double d) {
        return 1.0 - ErrorFunction.erf(d);
    }

    public static double inverseErf(double d) {
        return ErrorFunction.pointNormal(0.5 * d + 0.5) / Math.sqrt(2.0);
    }

    private static double pointNormal(double d) {
        double d2;
        double d3 = -0.322232431088;
        double d4 = -1.0;
        double d5 = -0.342242088547;
        double d6 = -0.0204231210245;
        double d7 = -4.53642210148E-5;
        double d8 = 0.099348462606;
        double d9 = 0.588581570495;
        double d10 = 0.531103462366;
        double d11 = 0.10353775285;
        double d12 = 0.0038560700634;
        double d13 = 0.0;
        double d14 = d;
        double d15 = d2 = d14 < 0.5 ? d14 : 1.0 - d14;
        if (d2 < 1.0E-20) {
            new IllegalArgumentException("Argument prob out of range");
        }
        double d16 = Math.sqrt(Math.log(1.0 / (d2 * d2)));
        d13 = d16 + ((((d16 * d7 + d6) * d16 + d5) * d16 + d4) * d16 + d3) / ((((d16 * d12 + d11) * d16 + d10) * d16 + d9) * d16 + d8);
        return d14 < 0.5 ? -d13 : d13;
    }
}

