/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MersenneTwisterFast;
import pal.math.MultivariateFunction;

public class MathUtils {
    public static MersenneTwisterFast random = new MersenneTwisterFast();

    public static final double[] getNormalized(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = MathUtils.getTotal(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] / d;
        }
        return dArray2;
    }

    public static final double getTotal(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static final double getTotal(double[] dArray) {
        return MathUtils.getTotal(dArray, 0, dArray.length);
    }

    public static final double[] getRandomArguments(MultivariateFunction multivariateFunction) {
        double[] dArray = new double[multivariateFunction.getNumArguments()];
        for (int i = 0; i < dArray.length; ++i) {
            double d = multivariateFunction.getLowerBound(i);
            double d2 = multivariateFunction.getUpperBound(i);
            dArray[i] = (d2 - d) * MersenneTwisterFast.getNextDouble() + d;
        }
        return dArray;
    }
}

