/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import java.io.Serializable;

public class MersenneTwisterFast
implements Serializable {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private static final long GOOD_SEED = 4357L;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;
    private static final MersenneTwisterFast DEFAULT_INSTANCE = new MersenneTwisterFast();
    private static long seedAdditive_ = 0L;

    public MersenneTwisterFast() {
        this(System.currentTimeMillis() + seedAdditive_);
        seedAdditive_ += (long)this.nextInt();
    }

    public MersenneTwisterFast(long l) {
        if (l == 0L) {
            this.setSeed(4357L);
        } else {
            this.setSeed(l);
        }
    }

    public final void shuffle(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.nextInt(n - i) + i;
            int n3 = nArray[n2];
            nArray[n2] = nArray[i];
            nArray[i] = n3;
        }
    }

    public final void shuffle(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            while ((n4 = this.nextInt(n2)) != (n3 = this.nextInt(n2))) {
            }
            int n5 = nArray[n3];
            nArray[n3] = nArray[n4];
            nArray[n4] = n5;
        }
    }

    public int[] shuffled(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.shuffle(nArray);
        return nArray;
    }

    public final void setSeed(long l) {
        this.haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mt[0] = (int)l;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1];
            ++this.mti;
        }
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public final int nextInt() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return n;
    }

    public final short nextShort() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (short)(n >>> 16);
    }

    public final char nextChar() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (char)(n >>> 16);
    }

    public final boolean nextBoolean() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        return (n ^= n >>> 18) >>> 31 != 0;
    }

    public final byte nextByte() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (byte)(n >>> 24);
    }

    public final void nextBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n;
            if (this.mti >= 624) {
                int n2;
                for (n2 = 0; n2 < 227; ++n2) {
                    n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                    this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
                }
                while (n2 < 623) {
                    n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                    this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                    ++n2;
                }
                n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
                this.mti = 0;
            }
            n = this.mt[this.mti++];
            n ^= n >>> 11;
            n ^= n << 7 & 0x9D2C5680;
            n ^= n << 15 & 0xEFC60000;
            n ^= n >>> 18;
            byArray[i] = (byte)(n >>> 24);
        }
    }

    public final long nextLong() {
        int n;
        int n2;
        int n3;
        if (this.mti >= 624) {
            for (n3 = 0; n3 < 227; ++n3) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
            }
            while (n3 < 623) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
                ++n3;
            }
            n2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
            this.mti = 0;
        }
        n2 = this.mt[this.mti++];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        if (this.mti >= 624) {
            for (n3 = 0; n3 < 227; ++n3) {
                n = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n3 < 623) {
                n = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n3;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return ((long)n2 << 32) + (long)n;
    }

    public final double nextDouble() {
        int n;
        int n2;
        int n3;
        if (this.mti >= 624) {
            for (n3 = 0; n3 < 227; ++n3) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
            }
            while (n3 < 623) {
                n2 = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
                ++n3;
            }
            n2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
            this.mti = 0;
        }
        n2 = this.mt[this.mti++];
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        if (this.mti >= 624) {
            for (n3 = 0; n3 < 227; ++n3) {
                n = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n3 < 623) {
                n = this.mt[n3] & Integer.MIN_VALUE | this.mt[n3 + 1] & Integer.MAX_VALUE;
                this.mt[n3] = this.mt[n3 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n3;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (double)(((long)(n2 >>> 6) << 27) + (long)(n >>> 5)) / 9.007199254740992E15;
    }

    public final double nextGaussian() {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        do {
            int n5;
            if (this.mti >= 624) {
                for (n5 = 0; n5 < 227; ++n5) {
                    n4 = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + 397] ^ n4 >>> 1 ^ this.mag01[n4 & 1];
                }
                while (n5 < 623) {
                    n4 = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + -227] ^ n4 >>> 1 ^ this.mag01[n4 & 1];
                    ++n5;
                }
                n4 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n4 >>> 1 ^ this.mag01[n4 & 1];
                this.mti = 0;
            }
            n4 = this.mt[this.mti++];
            n4 ^= n4 >>> 11;
            n4 ^= n4 << 7 & 0x9D2C5680;
            n4 ^= n4 << 15 & 0xEFC60000;
            n4 ^= n4 >>> 18;
            if (this.mti >= 624) {
                for (n5 = 0; n5 < 227; ++n5) {
                    n3 = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + 397] ^ n3 >>> 1 ^ this.mag01[n3 & 1];
                }
                while (n5 < 623) {
                    n3 = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + -227] ^ n3 >>> 1 ^ this.mag01[n3 & 1];
                    ++n5;
                }
                n3 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n3 >>> 1 ^ this.mag01[n3 & 1];
                this.mti = 0;
            }
            n3 = this.mt[this.mti++];
            n3 ^= n3 >>> 11;
            n3 ^= n3 << 7 & 0x9D2C5680;
            n3 ^= n3 << 15 & 0xEFC60000;
            n3 ^= n3 >>> 18;
            if (this.mti >= 624) {
                for (n5 = 0; n5 < 227; ++n5) {
                    n2 = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + 397] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
                }
                while (n5 < 623) {
                    n2 = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + -227] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
                    ++n5;
                }
                n2 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n2 >>> 1 ^ this.mag01[n2 & 1];
                this.mti = 0;
            }
            n2 = this.mt[this.mti++];
            n2 ^= n2 >>> 11;
            n2 ^= n2 << 7 & 0x9D2C5680;
            n2 ^= n2 << 15 & 0xEFC60000;
            n2 ^= n2 >>> 18;
            if (this.mti >= 624) {
                for (n5 = 0; n5 < 227; ++n5) {
                    n = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
                }
                while (n5 < 623) {
                    n = this.mt[n5] & Integer.MIN_VALUE | this.mt[n5 + 1] & Integer.MAX_VALUE;
                    this.mt[n5] = this.mt[n5 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                    ++n5;
                }
                n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
                this.mti = 0;
            }
            n = this.mt[this.mti++];
            n ^= n >>> 11;
            n ^= n << 7 & 0x9D2C5680;
            n ^= n << 15 & 0xEFC60000;
        } while ((d3 = (d2 = 2.0 * ((double)(((long)(n4 >>> 6) << 27) + (long)(n3 >>> 5)) / 9.007199254740992E15) - 1.0) * d2 + (d = 2.0 * ((double)(((long)(n2 >>> 6) << 27) + (long)((n ^= n >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * d) >= 1.0);
        double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public final float nextFloat() {
        int n;
        if (this.mti >= 624) {
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        n = this.mt[this.mti++];
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (float)(n >>> 8) / 1.6777216E7f;
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        int n4;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            int n5;
            if (this.mti >= 624) {
                int n6;
                for (n6 = 0; n6 < 227; ++n6) {
                    n5 = this.mt[n6] & Integer.MIN_VALUE | this.mt[n6 + 1] & Integer.MAX_VALUE;
                    this.mt[n6] = this.mt[n6 + 397] ^ n5 >>> 1 ^ this.mag01[n5 & 1];
                }
                while (n6 < 623) {
                    n5 = this.mt[n6] & Integer.MIN_VALUE | this.mt[n6 + 1] & Integer.MAX_VALUE;
                    this.mt[n6] = this.mt[n6 + -227] ^ n5 >>> 1 ^ this.mag01[n5 & 1];
                    ++n6;
                }
                n5 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n5 >>> 1 ^ this.mag01[n5 & 1];
                this.mti = 0;
            }
            n5 = this.mt[this.mti++];
            n5 ^= n5 >>> 11;
            n5 ^= n5 << 7 & 0x9D2C5680;
            n5 ^= n5 << 15 & 0xEFC60000;
            n5 ^= n5 >>> 18;
            return (int)((long)n * (long)(n5 >>> 1) >> 31);
        }
        do {
            if (this.mti >= 624) {
                int n7;
                for (n7 = 0; n7 < 227; ++n7) {
                    n3 = this.mt[n7] & Integer.MIN_VALUE | this.mt[n7 + 1] & Integer.MAX_VALUE;
                    this.mt[n7] = this.mt[n7 + 397] ^ n3 >>> 1 ^ this.mag01[n3 & 1];
                }
                while (n7 < 623) {
                    n3 = this.mt[n7] & Integer.MIN_VALUE | this.mt[n7 + 1] & Integer.MAX_VALUE;
                    this.mt[n7] = this.mt[n7 + -227] ^ n3 >>> 1 ^ this.mag01[n3 & 1];
                    ++n7;
                }
                n3 = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
                this.mt[623] = this.mt[396] ^ n3 >>> 1 ^ this.mag01[n3 & 1];
                this.mti = 0;
            }
            n3 = this.mt[this.mti++];
            n3 ^= n3 >>> 11;
            n3 ^= n3 << 7 & 0x9D2C5680;
            n3 ^= n3 << 15 & 0xEFC60000;
        } while ((n4 = (n3 ^= n3 >>> 18) >>> 1) - (n2 = n4 % n) + (n - 1) < 0);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte getNextByte() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean getNextBoolean() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void getNextBytes(byte[] byArray) {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            DEFAULT_INSTANCE.nextBytes(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char getNextChar() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final double getNextDouble() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final float getNextFloat() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final long getNextLong() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final short getNextShort() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getNextInt() {
        MersenneTwisterFast mersenneTwisterFast = DEFAULT_INSTANCE;
        synchronized (mersenneTwisterFast) {
            return DEFAULT_INSTANCE.nextInt();
        }
    }
}

