/*
 * Decompiled with CFR 0.152.
 */
package pal.math;

import pal.math.MachineAccuracy;
import pal.math.MultivariateFunction;
import pal.math.UnivariateFunction;

public class NumericalDerivative {
    public static double firstDerivative(UnivariateFunction univariateFunction, double d) {
        double d2 = MachineAccuracy.SQRT_EPSILON * (Math.abs(d) + 1.0);
        return (univariateFunction.evaluate(d + d2) - univariateFunction.evaluate(d - d2)) / (2.0 * d2);
    }

    public static double secondDerivative(UnivariateFunction univariateFunction, double d) {
        double d2 = MachineAccuracy.SQRT_SQRT_EPSILON * (Math.abs(d) + 1.0);
        return (univariateFunction.evaluate(d + d2) - 2.0 * univariateFunction.evaluate(d) + univariateFunction.evaluate(d - d2)) / (d2 * d2);
    }

    public static double[] gradient(MultivariateFunction multivariateFunction, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        NumericalDerivative.gradient(multivariateFunction, dArray, dArray2);
        return dArray2;
    }

    public static void gradient(MultivariateFunction multivariateFunction, double[] dArray, double[] dArray2) {
        for (int i = 0; i < multivariateFunction.getNumArguments(); ++i) {
            double d = MachineAccuracy.SQRT_EPSILON * (Math.abs(dArray[i]) + 1.0);
            double d2 = dArray[i];
            dArray[i] = d2 + d;
            double d3 = multivariateFunction.evaluate(dArray);
            dArray[i] = d2 - d;
            double d4 = multivariateFunction.evaluate(dArray);
            dArray[i] = d2;
            dArray2[i] = (d3 - d4) / (2.0 * d);
        }
    }

    public static double[] diagonalHessian(MultivariateFunction multivariateFunction, double[] dArray) {
        int n = multivariateFunction.getNumArguments();
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = MachineAccuracy.SQRT_SQRT_EPSILON * (Math.abs(dArray[i]) + 1.0);
            double d2 = dArray[i];
            dArray[i] = d2 + d;
            double d3 = multivariateFunction.evaluate(dArray);
            dArray[i] = d2 - d;
            double d4 = multivariateFunction.evaluate(dArray);
            dArray[i] = d2;
            double d5 = multivariateFunction.evaluate(dArray);
            dArray2[i] = (d3 - 2.0 * d5 + d4) / (d * d);
        }
        return dArray2;
    }
}

