/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Convolve_3d {
    private static int w;
    private static int h;
    private static int d;
    private static int r_x;
    private static int r_y;
    private static int r_z;
    private static Object[] slices_in;
    private static boolean isByte;
    private static boolean isShort;
    private static boolean isFloat;
    private static float[][][] H;

    public static ImagePlus convolve(ImagePlus imagePlus, float[] fArray, float[] fArray2, float[] fArray3) {
        ImagePlus imagePlus2 = Convolve_3d.convolveX(imagePlus, fArray);
        ImagePlus imagePlus3 = Convolve_3d.convolveY(imagePlus2, fArray2);
        return Convolve_3d.convolveZ(imagePlus3, fArray3);
    }

    public static ImagePlus convolveX(ImagePlus imagePlus, float[] fArray) {
        float[][][] fArray2 = new float[1][1][fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[0][0][i] = fArray[i];
        }
        return Convolve_3d.convolve(imagePlus, fArray2);
    }

    public static ImagePlus convolveY(ImagePlus imagePlus, float[] fArray) {
        float[][][] fArray2 = new float[1][fArray.length][1];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[0][i][0] = fArray[i];
        }
        return Convolve_3d.convolve(imagePlus, fArray2);
    }

    public static ImagePlus convolveZ(ImagePlus imagePlus, float[] fArray) {
        float[][][] fArray2 = new float[fArray.length][1][1];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i][0][0] = fArray[i];
        }
        return Convolve_3d.convolve(imagePlus, fArray2);
    }

    public static ImagePlus convolve(ImagePlus imagePlus, float[][][] fArray) {
        int n;
        int n2;
        H = fArray;
        r_z = H.length;
        r_y = H[0].length;
        r_x = H[0][0].length;
        w = imagePlus.getWidth();
        h = imagePlus.getHeight();
        d = imagePlus.getStackSize();
        int n3 = r_x / 2;
        int n4 = w - r_x / 2;
        int n5 = r_y / 2;
        int n6 = h - r_y / 2;
        int n7 = r_z / 2;
        int n8 = d - r_z / 2;
        slices_in = new Object[d];
        float[][] fArrayArray = new float[d][];
        for (n2 = 0; n2 < d; ++n2) {
            Convolve_3d.slices_in[n2] = imagePlus.getStack().getProcessor(n2 + 1).getPixels();
            fArrayArray[n2] = new float[w * h];
        }
        isByte = slices_in[0] instanceof byte[];
        isShort = slices_in[0] instanceof short[];
        isFloat = slices_in[0] instanceof float[];
        for (n2 = 0; n2 < d; ++n2) {
            IJ.showProgress((int)n2, (int)d);
            for (n = 0; n < h; ++n) {
                for (int i = 0; i < w; ++i) {
                    fArrayArray[n2][n * Convolve_3d.w + i] = Convolve_3d.convolvePoint(n2, n, i);
                }
            }
        }
        ImageStack imageStack = new ImageStack(w, h);
        for (n = 0; n < d; ++n) {
            imageStack.addSlice("", (ImageProcessor)new FloatProcessor(w, h, fArrayArray[n], null));
        }
        ImagePlus imagePlus2 = new ImagePlus("", imageStack);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    private static float convolvePoint(int n, int n2, int n3) {
        float f = 0.0f;
        for (int i = -r_z / 2; i <= r_z / 2; ++i) {
            for (int j = -r_y / 2; j <= r_y / 2; ++j) {
                for (int k = -r_x / 2; k <= r_x / 2; ++k) {
                    f += Convolve_3d.getValue(n3 + k, n2 + j, n + i) * H[i + r_z / 2][j + r_y / 2][k + r_x / 2];
                }
            }
        }
        return f;
    }

    private static float getValue(int n, int n2, int n3) {
        if (n < 0) {
            return 0.0f;
        }
        if (n > w - 1) {
            return 0.0f;
        }
        if (n2 < 0) {
            return 0.0f;
        }
        if (n2 > h - 1) {
            return 0.0f;
        }
        if (n3 < 0) {
            return 0.0f;
        }
        if (n3 > d - 1) {
            return 0.0f;
        }
        int n4 = n2 * w + n;
        if (isByte) {
            return ((byte[])slices_in[n3])[n4] & 0xFF;
        }
        if (isShort) {
            return ((short[])slices_in[n3])[n4];
        }
        if (isFloat) {
            return ((float[])slices_in[n3])[n4];
        }
        IJ.error((String)"Neither byte nor float image");
        return -1.0f;
    }
}

