/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class Erode_
implements PlugInFilter {
    private int w;
    private int h;
    private int d;
    private ImagePlus image;
    private byte[][] pixels_in;
    private byte[][] pixels_out;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Erode");
        genericDialog.addNumericField("Iso value", 255.0, 0);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.erode(this.image, (int)genericDialog.getNextNumber(), false).show();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 131;
    }

    public ImagePlus erode(ImagePlus imagePlus, int n, boolean bl) {
        int n2;
        int n3;
        this.w = imagePlus.getWidth();
        this.h = imagePlus.getHeight();
        this.d = imagePlus.getStackSize();
        this.pixels_in = new byte[this.d][];
        this.pixels_out = new byte[this.d][];
        for (n3 = 0; n3 < this.d; ++n3) {
            this.pixels_in[n3] = (byte[])imagePlus.getStack().getPixels(n3 + 1);
            this.pixels_out[n3] = new byte[this.w * this.h];
        }
        for (n3 = 0; n3 < this.d; ++n3) {
            IJ.showProgress((int)n3, (int)(this.d - 1));
            for (int i = 0; i < this.h; ++i) {
                for (n2 = 0; n2 < this.w; ++n2) {
                    if (this.get(n2, i, n3) != n) {
                        this.set(n2, i, n3, this.get(n2, i, n3));
                        continue;
                    }
                    if (this.get(n2 - 1, i, n3) == n && this.get(n2 + 1, i, n3) == n && this.get(n2, i - 1, n3) == n && this.get(n2, i + 1, n3) == n && this.get(n2, i, n3 - 1) == n && this.get(n2, i, n3 + 1) == n) {
                        this.set(n2, i, n3, n);
                        continue;
                    }
                    this.set(n2, i, n3, 0);
                }
            }
        }
        ColorModel colorModel = imagePlus.getStack().getColorModel();
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (n2 = 0; n2 < this.d; ++n2) {
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, this.pixels_out[n2], colorModel));
        }
        if (!bl) {
            imagePlus.setStack(null, imageStack);
            return imagePlus;
        }
        ImagePlus imagePlus2 = new ImagePlus(imagePlus.getTitle() + "_eroded", imageStack);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    public int get(int n, int n2, int n3) {
        n = n < 0 ? 0 : n;
        n = n >= this.w ? this.w - 1 : n;
        n2 = n2 < 0 ? 0 : n2;
        n2 = n2 >= this.h ? this.h - 1 : n2;
        n3 = n3 < 0 ? 0 : n3;
        n3 = n3 >= this.d ? this.d - 1 : n3;
        return this.pixels_in[n3][n2 * this.w + n] & 0xFF;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.pixels_out[n3][n2 * this.w + n] = (byte)n4;
    }
}

