/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import process3d.Convolve_3d;
import process3d.Smooth_;
import vib.InterpolatedImage;

public class Harris_Corner_Detector
implements PlugInFilter {
    private ImagePlus image;
    private ImagePlus XX;
    private ImagePlus YY;
    private ImagePlus ZZ;
    private ImagePlus XY;
    private ImagePlus XZ;
    private ImagePlus YZ;
    public static final float HARRIS_THRESHOLD = 20.0f;
    public static final float K = 0.14f;

    public Harris_Corner_Detector() {
    }

    public Harris_Corner_Detector(ImagePlus imagePlus) {
        this.image = imagePlus;
    }

    public void run(ImageProcessor imageProcessor) {
        this.findCorners().show();
    }

    public ImagePlus findCorners() {
        this.makeDerivatives();
        ImagePlus imagePlus = this.createCRF();
        imagePlus.show();
        imagePlus = Harris_Corner_Detector.suppressNonMaximum(imagePlus);
        return imagePlus;
    }

    public ImagePlus createCRF() {
        IJ.showStatus((String)"Create crf");
        InterpolatedImage interpolatedImage = new InterpolatedImage(this.XX);
        InterpolatedImage interpolatedImage2 = new InterpolatedImage(this.XY);
        InterpolatedImage interpolatedImage3 = new InterpolatedImage(this.XZ);
        InterpolatedImage interpolatedImage4 = new InterpolatedImage(this.YY);
        InterpolatedImage interpolatedImage5 = new InterpolatedImage(this.YZ);
        InterpolatedImage interpolatedImage6 = new InterpolatedImage(this.ZZ);
        InterpolatedImage interpolatedImage7 = interpolatedImage.cloneDimensionsOnly();
        InterpolatedImage.Iterator iterator = interpolatedImage.iterator();
        while (iterator.next() != null) {
            float f = interpolatedImage.getNoCheckFloat(iterator.i, iterator.j, iterator.k);
            float f2 = interpolatedImage2.getNoCheckFloat(iterator.i, iterator.j, iterator.k);
            float f3 = interpolatedImage3.getNoCheckFloat(iterator.i, iterator.j, iterator.k);
            float f4 = interpolatedImage4.getNoCheckFloat(iterator.i, iterator.j, iterator.k);
            float f5 = interpolatedImage5.getNoCheckFloat(iterator.i, iterator.j, iterator.k);
            float f6 = interpolatedImage6.getNoCheckFloat(iterator.i, iterator.j, iterator.k);
            float f7 = f + f4 + f6;
            float f8 = f * (f4 * f4 - f5 * f5) - f2 * (f2 * f6 - f5 * f3) + f3 * (f2 * f5 - f4 * f3);
            float f9 = f8 - 0.14f * f7 * f7;
            interpolatedImage7.setFloat(iterator.i, iterator.j, iterator.k, f9);
        }
        this.ZZ = null;
        this.YZ = null;
        this.YY = null;
        this.XZ = null;
        this.XY = null;
        this.XX = null;
        System.gc();
        return interpolatedImage7.getImage();
    }

    public void makeDerivatives() {
        IJ.showStatus((String)"Calculate derivatives");
        float f = 2.0f;
        float[] fArray = new float[]{-0.5f, 0.0f, 0.5f};
        ImagePlus imagePlus = Smooth_.smooth(this.image, true, f, false);
        ImagePlus imagePlus2 = Convolve_3d.convolveX(imagePlus, fArray);
        ImagePlus imagePlus3 = Convolve_3d.convolveY(imagePlus, fArray);
        ImagePlus imagePlus4 = Convolve_3d.convolveZ(imagePlus, fArray);
        this.XX = Smooth_.smooth(Harris_Corner_Detector.mul(imagePlus2, imagePlus2), true, f, false);
        this.XY = Smooth_.smooth(Harris_Corner_Detector.mul(imagePlus2, imagePlus3), true, f, false);
        this.XZ = Smooth_.smooth(Harris_Corner_Detector.mul(imagePlus2, imagePlus4), true, f, false);
        this.YY = Smooth_.smooth(Harris_Corner_Detector.mul(imagePlus3, imagePlus3), true, f, false);
        this.YZ = Smooth_.smooth(Harris_Corner_Detector.mul(imagePlus3, imagePlus4), true, f, false);
        this.ZZ = Smooth_.smooth(Harris_Corner_Detector.mul(imagePlus4, imagePlus4), true, f, false);
    }

    public static final ImagePlus mul(ImagePlus imagePlus, ImagePlus imagePlus2) {
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        InterpolatedImage interpolatedImage2 = new InterpolatedImage(imagePlus2);
        InterpolatedImage interpolatedImage3 = interpolatedImage.cloneDimensionsOnly();
        InterpolatedImage.Iterator iterator = interpolatedImage.iterator();
        while (iterator.next() != null) {
            interpolatedImage3.setFloat(iterator.i, iterator.j, iterator.k, interpolatedImage.getNoCheckFloat(iterator.i, iterator.j, iterator.k) * interpolatedImage2.getNoCheckFloat(iterator.i, iterator.j, iterator.k));
        }
        return interpolatedImage3.getImage();
    }

    public static ImagePlus suppressNonMaximum(ImagePlus imagePlus) {
        IJ.showStatus((String)"Suppress non-maximum points");
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        InterpolatedImage interpolatedImage2 = interpolatedImage.cloneDimensionsOnly();
        InterpolatedImage.Iterator iterator = interpolatedImage.iterator();
        int n = 27;
        block0: while (iterator.next() != null) {
            float f = interpolatedImage.getNoInterpolFloat(iterator.i, iterator.j, iterator.k);
            if (f < 20.0f) continue;
            interpolatedImage2.setFloat(iterator.i, iterator.j, iterator.k, 100.0f);
            for (int i = 0; i < n; ++i) {
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                if (i == n / 2 || !(interpolatedImage.getNoInterpolFloat(n7 = iterator.i + (n6 = i % 9 % 3 - 1), n5 = iterator.j + (n4 = i % 9 / 3 - 1), n3 = iterator.k + (n2 = i / 9 - 1)) >= f)) continue;
                interpolatedImage2.setFloat(iterator.i, iterator.j, iterator.k, 0.0f);
                continue block0;
            }
        }
        return interpolatedImage2.getImage();
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = new InterpolatedImage(imagePlus).cloneImage().getImage();
        new StackConverter(this.image).convertToGray32();
        return 9;
    }
}

