/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import process3d.Find_Minima;
import process3d.Flood_Fill;
import vib.BenesNamedPoint;
import vib.InterpolatedImage;
import vib.PointList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IFT_
implements PlugInFilter {
    private ImagePlus image;
    private int w;
    private int h;
    private int wh;
    private int d;
    private PriorityQueue queue;
    private byte[][] data;
    private int[][] result;
    private int[] C;
    private boolean[] flag;
    Cls[] classes;
    private int[] neighbors = new int[6];

    public IFT_(ImagePlus imagePlus) {
        this.image = imagePlus;
    }

    public IFT_() {
    }

    public void run(ImageProcessor imageProcessor) {
        int[] nArray = WindowManager.getIDList();
        if (nArray == null) {
            IJ.error((String)"No images open");
            return;
        }
        String[] stringArray = new String[nArray.length + 2];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = WindowManager.getImage((int)nArray[i]).getTitle();
        }
        stringArray[stringArray.length - 1] = "use seeds from point list";
        stringArray[stringArray.length - 2] = "use local minima";
        GenericDialog genericDialog = new GenericDialog("Watershed from markers");
        genericDialog.addChoice("Seeds", stringArray, stringArray[0]);
        genericDialog.addCheckbox("Show class indices", true);
        genericDialog.addCheckbox("Show mean intensities", true);
        genericDialog.addCheckbox("Show results table", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        int n = genericDialog.getNextChoiceIndex();
        if (n == stringArray.length - 1) {
            this.initFromPointList();
        } else if (n == stringArray.length - 2) {
            this.initFromMinima();
        } else {
            this.initFromImage(WindowManager.getImage((String)stringArray[n]));
        }
        this.propagate();
        if (genericDialog.getNextBoolean()) {
            this.createResult().show();
        }
        if (genericDialog.getNextBoolean()) {
            this.createMeans().show();
        }
        if (genericDialog.getNextBoolean()) {
            new TextWindow("Classes", "min\tmax\tmean\tvol\tcogx\tcogy\tcogz\tox\toy\toz", this.createSummaryString(), 400, 500);
        }
    }

    public void initFromImage(ImagePlus imagePlus) {
        int n;
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.wh = this.w * this.h;
        this.d = this.image.getStackSize();
        this.data = new byte[this.d][];
        for (n = 0; n < this.d; ++n) {
            this.data[n] = (byte[])this.image.getStack().getProcessor(n + 1).getPixels();
        }
        this.C = new int[this.w * this.h * this.d];
        this.flag = new boolean[this.w * this.h * this.d];
        this.result = new int[this.d][this.w * this.h];
        for (n = 0; n < this.C.length; ++n) {
            this.C[n] = 255;
        }
        this.queue = new PriorityQueue();
        for (n = 0; n < imagePlus.getStackSize(); ++n) {
            byte[] byArray = (byte[])imagePlus.getStack().getPixels(n + 1);
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    int n2;
                    int n3 = i * this.w + j;
                    if (byArray[n3] == 0) continue;
                    int n4 = n * byArray.length + n3;
                    this.C[n4] = n2 = 0;
                    this.result[n][n3] = byArray[n3] & 0xFF;
                    this.queue.add(n4, n2);
                    IFT_.addClass(arrayList, j, i, n, byArray[n3]);
                }
            }
        }
        this.classes = new Cls[arrayList.size()];
        arrayList.toArray(this.classes);
    }

    public void initFromMinima() {
        int n;
        IJ.showStatus((String)"Find minima");
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.wh = this.w * this.h;
        this.d = this.image.getStackSize();
        this.data = new byte[this.d][];
        for (n = 0; n < this.d; ++n) {
            this.data[n] = (byte[])this.image.getStack().getProcessor(n + 1).getPixels();
        }
        this.C = new int[this.w * this.h * this.d];
        this.flag = new boolean[this.w * this.h * this.d];
        this.result = new int[this.d][this.w * this.h];
        for (n = 0; n < this.C.length; ++n) {
            this.C[n] = 255;
        }
        ImagePlus imagePlus = new Find_Minima(this.image).classify();
        this.queue = new PriorityQueue();
        int n2 = 0;
        for (int i = 0; i < imagePlus.getStackSize(); ++i) {
            byte[] byArray = (byte[])imagePlus.getStack().getPixels(i + 1);
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    int n3;
                    int n4 = j * this.w + k;
                    if (byArray[n4] == 0) continue;
                    int n5 = i * byArray.length + n4;
                    this.C[n5] = n3 = 0;
                    this.result[i][n4] = n2++;
                    this.queue.add(n5, n3);
                    IFT_.addClass(arrayList, k, j, i, this.data[i][j * this.w + k]);
                    Flood_Fill.fill(imagePlus, k, j, i, 0);
                }
            }
            IJ.showProgress((int)(i + 1), (int)this.d);
        }
        System.out.println(n2 + " classes");
        this.classes = new Cls[n2];
        arrayList.toArray(this.classes);
    }

    protected static void addClass(List<Cls> list, int n, int n2, int n3, byte by) {
        Cls cls = new Cls();
        cls.add(n, n2, n3, by);
        cls.originx = n;
        cls.originy = n2;
        cls.originz = n3;
        list.add(cls);
    }

    public void initFromPointList() {
        int n;
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.wh = this.w * this.h;
        this.d = this.image.getStackSize();
        PointList pointList = PointList.load(this.image);
        this.data = new byte[this.d][];
        for (n = 0; n < this.d; ++n) {
            this.data[n] = (byte[])this.image.getStack().getProcessor(n + 1).getPixels();
        }
        this.C = new int[this.w * this.h * this.d];
        this.flag = new boolean[this.w * this.h * this.d];
        this.result = new int[this.d][this.w * this.h];
        for (n = 0; n < this.C.length; ++n) {
            this.C[n] = 255;
        }
        this.queue = new PriorityQueue();
        n = 1;
        for (BenesNamedPoint benesNamedPoint : pointList) {
            int n2;
            int n3 = (int)benesNamedPoint.z;
            int n4 = (int)benesNamedPoint.y * this.w + (int)benesNamedPoint.x;
            int n5 = n3 * this.w * this.h + n4;
            this.C[n5] = n2 = 0;
            this.result[n3][n4] = n += 10;
            this.queue.add(n5, n2);
            IFT_.addClass(arrayList, (int)benesNamedPoint.x, (int)benesNamedPoint.y, (int)benesNamedPoint.z, (byte)n);
        }
        this.classes = new Cls[arrayList.size()];
        arrayList.toArray(this.classes);
    }

    public void propagate() {
        int n;
        System.out.println("Propagate");
        int n2 = 0;
        int n3 = this.wh * this.d;
        while (!this.queue.isEmpty()) {
            n = this.queue.poll();
            this.flag[n] = true;
            this.getNeighbours(n);
            for (int i = 0; i < this.neighbors.length; ++i) {
                int n4 = this.neighbors[i];
                if (n4 == -1) continue;
                int n5 = this.C[n4];
                int n6 = this.C[n] + this.weight(n, n4);
                if (n6 >= this.C[n4]) continue;
                this.C[n4] = n6;
                int n7 = n4 / this.wh;
                int n8 = n4 % this.wh;
                int n9 = n / this.wh;
                int n10 = n % this.wh;
                this.result[n7][n8] = this.result[n9][n10];
                this.classes[this.result[n9][n10]].add(n8 % this.w, n8 / this.w, n7, this.data[n7][n8]);
                ++n2;
                this.queue.removeFromBucket(n4, n5);
                this.queue.add(n4, this.C[n4]);
            }
            if (n2 % 1000 != 0) continue;
            IJ.showProgress((int)n2, (int)n3);
        }
        IJ.showProgress((double)1.0);
        for (n = 0; n < this.classes.length; ++n) {
            this.classes[n].finished();
        }
    }

    public ImagePlus createResult() {
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 0; i < this.d; ++i) {
            imageStack.addSlice("", (ImageProcessor)new ColorProcessor(this.w, this.h, this.result[i]));
        }
        ImagePlus imagePlus = new ImagePlus("Result", imageStack);
        imagePlus.setCalibration(this.image.getCalibration());
        return imagePlus;
    }

    public ImagePlus createMeans() {
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 0; i < this.d; ++i) {
            byte[] byArray = new byte[this.wh];
            for (int j = 0; j < this.wh; ++j) {
                byArray[j] = (byte)this.classes[this.result[i][j]].mean;
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, byArray, null));
        }
        ImagePlus imagePlus = new ImagePlus("Result", imageStack);
        imagePlus.setCalibration(this.image.getCalibration());
        return imagePlus;
    }

    public String createSummaryString() {
        String string = "";
        for (int i = 0; i < this.classes.length; ++i) {
            Cls cls = this.classes[i];
            string = string + cls.min + "\t" + cls.max + "\t" + cls.mean + "\t" + cls.vol + "\t" + cls.cogx + "\t" + cls.cogy + "\t" + cls.cogz + cls.originx + "\t" + cls.originy + "\t" + cls.originz + "\n";
        }
        return string;
    }

    public Cls[] getClasses() {
        return this.classes;
    }

    public int weight(int n, int n2) {
        int n3 = n / this.wh;
        int n4 = n % this.wh;
        int n5 = n2 / this.wh;
        int n6 = n2 % this.wh;
        return Math.abs((this.data[n3][n4] & 0xFF) - (this.data[n5][n6] & 0xFF));
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void getNeighbours(int n) {
        int n2 = n / this.wh;
        int n3 = n % this.wh;
        int n4 = n3 % this.w;
        int n5 = n3 / this.w;
        for (int i = 0; i < this.neighbors.length; ++i) {
            this.neighbors[i] = -1;
        }
        if (n4 > 1 && !this.flag[n2 * this.wh + n3 - 1]) {
            this.neighbors[0] = n2 * this.wh + n3 - 1;
        }
        if (n4 < this.w - 1 && !this.flag[n2 * this.wh + n3 + 1]) {
            this.neighbors[1] = n2 * this.wh + n3 + 1;
        }
        if (n5 > 1 && !this.flag[n2 * this.wh + (n5 - 1) * this.w + n4]) {
            this.neighbors[2] = n2 * this.wh + (n5 - 1) * this.w + n4;
        }
        if (n5 < this.h - 1 && !this.flag[n2 * this.wh + (n5 + 1) * this.w + n4]) {
            this.neighbors[3] = n2 * this.wh + (n5 + 1) * this.w + n4;
        }
        if (n2 > 1 && !this.flag[(n2 - 1) * this.wh + n3]) {
            this.neighbors[4] = (n2 - 1) * this.wh + n3;
        }
        if (n2 < this.d - 1 && !this.flag[(n2 + 1) * this.wh + n3]) {
            this.neighbors[5] = (n2 + 1) * this.wh + n3;
        }
    }

    public ImagePlus checkLabelfield(ImagePlus imagePlus) {
        InterpolatedImage interpolatedImage = new InterpolatedImage(imagePlus);
        InterpolatedImage interpolatedImage2 = interpolatedImage.cloneDimensionsOnly();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = imagePlus.getStackSize();
        ImagePlus imagePlus2 = this.createResult();
        for (int i = 0; i < n3; ++i) {
            int[] nArray = (int[])imagePlus2.getStack().getPixels(i + 1);
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    int n4 = nArray[j * n + k] & 0xFFFFFF;
                    Cls cls = this.classes[n4];
                    interpolatedImage2.set(k, j, i, interpolatedImage.getNoCheck(cls.originx, cls.originy, cls.originz));
                }
            }
        }
        return interpolatedImage2.getImage();
    }

    public static void writeClasses(String string, Cls[] clsArray) throws Exception {
        PrintWriter printWriter = new PrintWriter(new FileWriter(string));
        printWriter.println(clsArray.length + " classes");
        for (int i = 0; i < clsArray.length; ++i) {
            printWriter.println(clsArray[i]);
        }
        printWriter.close();
    }

    public static Cls[] readClasses(String string) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        int n = Integer.parseInt(string2.split("\\s")[0]);
        Cls[] clsArray = new Cls[n];
        for (int i = 0; i < n; ++i) {
            clsArray[i] = Cls.initFromString(bufferedReader.readLine());
        }
        bufferedReader.close();
        return clsArray;
    }

    private static final class IntArray {
        private int[] array;
        private int size = 0;
        private int initCap;

        public IntArray(int n) {
            this.initCap = n;
            this.array = new int[n];
        }

        public final int size() {
            return this.size;
        }

        public final boolean isEmpty() {
            return this.size == 0;
        }

        public final int get(int n) {
            if (n >= 0 && n < this.size) {
                return this.array[n];
            }
            return -1;
        }

        public final void add(int n) {
            if (this.size == this.array.length) {
                int n2 = this.initCap / 5;
                n2 = n2 == 0 ? 1 : n2;
                int[] nArray = this.array;
                this.array = new int[this.array.length + n2];
                System.arraycopy(nArray, 0, this.array, 0, nArray.length);
            }
            this.array[this.size] = n;
            ++this.size;
        }

        public final void removeIndex(int n) {
            if (n < 0 || n >= this.size) {
                return;
            }
            --this.size;
            for (int i = n; i < this.size; ++i) {
                this.array[i] = this.array[i + 1];
            }
        }

        public final int removeLast() {
            --this.size;
            return this.array[this.size];
        }

        public final boolean removeValue(int n) {
            int n2;
            for (n2 = 0; n2 < this.size && this.array[n2] != n; ++n2) {
            }
            if (n2 == this.size) {
                return false;
            }
            --this.size;
            while (n2 < this.size) {
                this.array[n2] = this.array[n2 + 1];
                ++n2;
            }
            return true;
        }

        public final void set(int n, int n2) {
            if (n >= 0 && n < this.size) {
                this.array[n] = n2;
            }
        }

        public final void removeAll() {
            this.size = 0;
        }
    }

    private static final class PriorityQueue {
        private IntArray[] arr = new IntArray[256];
        private int size = 0;

        public final void add(int n, int n2) {
            if (this.arr[n2] == null) {
                this.arr[n2] = new IntArray(10000);
            }
            this.arr[n2].add(n);
            ++this.size;
        }

        public final boolean isEmpty() {
            return this.size == 0;
        }

        public final int poll() {
            for (int i = 0; i < this.arr.length; ++i) {
                if (this.arr[i] == null || this.arr[i].isEmpty()) continue;
                int n = this.arr[i].removeLast();
                --this.size;
                return n;
            }
            return -1;
        }

        public final void removeFromBucket(int n, int n2) {
            if (this.arr[n2] != null && this.arr[n2].removeValue(n)) {
                --this.size;
            }
        }
    }

    public static final class Cls {
        public int min = 255;
        public int max = 0;
        public int mean = 0;
        public int vol = 0;
        public int cogx = 0;
        public int cogy = 0;
        public int cogz = 0;
        public int originx = 0;
        public int originy = 0;
        public int originz = 0;

        private final void add(int n, int n2, int n3, byte by) {
            int n4 = by & 0xFF;
            if (n4 < this.min) {
                this.min = n4;
            }
            if (n4 > this.max) {
                this.max = n4;
            }
            this.mean += n4;
            ++this.vol;
            this.cogx += n;
            this.cogy += n2;
            this.cogz += n3;
        }

        private final void finished() {
            this.mean /= this.vol;
            this.cogx /= this.vol;
            this.cogy /= this.vol;
            this.cogz /= this.vol;
        }

        static Cls initFromString(String string) {
            Cls cls = new Cls();
            String[] stringArray = string.split("\\s");
            cls.min = Integer.parseInt(stringArray[0]);
            cls.max = Integer.parseInt(stringArray[1]);
            cls.mean = Integer.parseInt(stringArray[2]);
            cls.vol = Integer.parseInt(stringArray[3]);
            cls.cogx = Integer.parseInt(stringArray[4]);
            cls.cogy = Integer.parseInt(stringArray[5]);
            cls.cogz = Integer.parseInt(stringArray[6]);
            cls.originx = Integer.parseInt(stringArray[7]);
            cls.originy = Integer.parseInt(stringArray[8]);
            cls.originz = Integer.parseInt(stringArray[9]);
            return cls;
        }

        public String toString() {
            return this.min + " " + this.max + " " + this.mean + " " + this.vol + " " + this.cogx + " " + this.cogy + " " + this.cogz + " " + this.originx + " " + this.originy + " " + this.originz;
        }
    }
}

