/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import process3d.Plot_Dots;

public class Particle_Analyzer_3D
implements PlugInFilter {
    private ImagePlus image;
    private ImagePlus result;
    private int[] classes;
    private int[] sizes;
    private int[] intensities;
    private int w;
    private int h;
    private int z;
    private int threshold = 100;
    private boolean showStatus = true;

    public Particle_Analyzer_3D() {
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 1;
    }

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Particle Analyzer 3D");
        genericDialog.addNumericField("Threshold [0..255]", (double)this.threshold, 0);
        genericDialog.addCheckbox("Show_result_table", true);
        genericDialog.addCheckbox("Show_result_chart", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.threshold = (int)genericDialog.getNextNumber();
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.z = this.image.getStackSize();
        this.showStatus = true;
        this.result = this.classify(this.image);
        this.calculateIntensities(this.image);
        this.calculateSizes();
        this.sortResults();
        this.keepNLargest(3);
        this.getResultAsByteImage().show();
        if (genericDialog.getNextBoolean()) {
            this.showResultWindow();
        }
        if (genericDialog.getNextBoolean()) {
            this.showChart();
        }
    }

    public ImagePlus getResultAsByteImage() {
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 0; i < this.z; ++i) {
            int[] nArray = (int[])this.result.getStack().getPixels(i + 1);
            byte[] byArray = new byte[this.w * this.h];
            for (int j = 0; j < byArray.length; ++j) {
                byArray[j] = nArray[j] == -1 ? -1 : (byte)nArray[j];
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, byArray, null));
        }
        ImagePlus imagePlus = new ImagePlus("Classified", imageStack);
        imagePlus.setCalibration(this.image.getCalibration());
        return imagePlus;
    }

    public void keepNLargest(int n) {
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        System.arraycopy(this.sizes, 0, nArray, 0, n);
        System.arraycopy(this.intensities, 0, nArray2, 0, n);
        System.arraycopy(this.classes, 0, nArray3, 0, n);
        for (int i = 0; i < this.result.getStackSize(); ++i) {
            ImageProcessor imageProcessor = this.result.getStack().getProcessor(i + 1);
            for (int j = 0; j < this.w * this.h; ++j) {
                if (imageProcessor.get(j) < n) continue;
                imageProcessor.set(j, -1);
            }
        }
        this.sizes = nArray;
        this.intensities = nArray2;
        this.classes = nArray3;
    }

    public void sortResults() {
        Object object;
        int n;
        Object[] objectArray = new Cl[this.classes.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = new Cl(this.classes[n], this.sizes[n], this.intensities[n]);
        }
        Arrays.sort(objectArray);
        for (n = 0; n < this.result.getStackSize(); ++n) {
            object = this.result.getStack().getProcessor(n + 1);
            block2: for (int i = 0; i < this.w * this.h; ++i) {
                if (object.get(i) == -1) continue;
                for (int j = 0; j < objectArray.length; ++j) {
                    if (object.get(i) != ((Cl)objectArray[j]).cl) continue;
                    object.set(i, j);
                    continue block2;
                }
            }
        }
        for (n = 0; n < this.classes.length; ++n) {
            object = objectArray[n];
            this.sizes[n] = object.size;
            this.intensities[n] = object.inten;
        }
    }

    public void showResultWindow() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.classes.length; ++i) {
            stringBuffer.append(this.classes[i] + "\t" + this.sizes[i]);
            stringBuffer.append("\t" + this.intensities[i]);
            stringBuffer.append("\n");
        }
        String string = "Class\tsize\tintensity";
        new TextWindow("Results", string, stringBuffer.toString(), 500, 350);
    }

    public void showChart() {
        double[] dArray = new double[this.sizes.length];
        double[] dArray2 = new double[this.intensities.length];
        String[] stringArray = new String[this.classes.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.sizes[i];
            dArray2[i] = (double)this.intensities[i] / 100.0;
            stringArray[i] = Integer.toString(this.classes[i]);
        }
        Plot_Dots plot_Dots = new Plot_Dots();
        plot_Dots.x = dArray;
        plot_Dots.y = dArray2;
        plot_Dots.labels = stringArray;
        plot_Dots.xLabel = "Size";
        plot_Dots.yLabel = "Intensity";
        plot_Dots.create();
    }

    public Particle_Analyzer_3D(ImagePlus imagePlus, int n, boolean bl) {
        this.image = imagePlus;
        this.w = this.image.getWidth();
        this.h = this.image.getHeight();
        this.z = this.image.getStackSize();
        this.showStatus = bl;
        this.threshold = n;
        this.result = this.classify(this.image);
    }

    public int[] getClasses() {
        return this.classes;
    }

    public int[] sizes() {
        return this.sizes;
    }

    public int classesCount() {
        return this.classes.length;
    }

    public ImagePlus classesAsImage() {
        return this.result;
    }

    public ImagePlus imageForClass(int n, String string) {
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 1; i <= this.z; ++i) {
            int[] nArray = (int[])this.result.getStack().getProcessor(i).getPixels();
            byte[] byArray = new byte[nArray.length];
            for (int j = 0; j < nArray.length; ++j) {
                byArray[j] = nArray[j] == n ? -1 : 0;
            }
            imageStack.addSlice("", (ImageProcessor)new ByteProcessor(this.w, this.h, byArray, null));
        }
        if (string == null || string.trim().equals("")) {
            string = "Class " + n;
        }
        ImagePlus imagePlus = new ImagePlus(string, imageStack);
        imagePlus.setCalibration(this.result.getCalibration());
        return imagePlus;
    }

    public int getSize(int n) {
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.classes[i] != n) continue;
            return this.sizes[i];
        }
        return -1;
    }

    public int getLargestClass() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.classes.length; ++i) {
            if (this.sizes[i] <= n2) continue;
            n2 = this.sizes[i];
            n = i;
        }
        return this.classes[n];
    }

    public ImagePlus imageOfLargestClass() {
        return this.imageForClass(this.getLargestClass(), "Largest object");
    }

    private ImagePlus classify(ImagePlus imagePlus) {
        if (this.showStatus) {
            IJ.showStatus((String)"classify...");
        }
        MergedClasses mergedClasses = new MergedClasses();
        ImageStack imageStack = new ImageStack(this.w, this.h);
        for (int i = 1; i <= this.z; ++i) {
            byte[] byArray = (byte[])imagePlus.getStack().getProcessor(i).getPixels();
            int[] nArray = new int[this.w * this.h];
            int[] nArray2 = i > 1 ? (int[])imageStack.getProcessor(i - 1).getPixels() : null;
            for (int j = 0; j < this.h; ++j) {
                for (int k = 0; k < this.w; ++k) {
                    int n = j * this.w + k;
                    byte by = byArray[n];
                    int n2 = j > 0 ? nArray[n - this.w] : -1;
                    int n3 = k > 0 ? nArray[n - 1] : -1;
                    int n4 = i > 1 ? nArray2[n] : -1;
                    nArray[n] = this.classifyPixel(mergedClasses, by, n2, n3, n4);
                }
            }
            if (this.showStatus) {
                IJ.showProgress((int)i, (int)this.z);
            }
            imageStack.addSlice("", (ImageProcessor)new ColorProcessor(this.w, this.h, nArray));
        }
        this.correctMergedClasses(mergedClasses, imageStack);
        ImagePlus imagePlus2 = new ImagePlus("Classified", imageStack);
        imagePlus2.setCalibration(imagePlus.getCalibration());
        return imagePlus2;
    }

    private void correctMergedClasses(MergedClasses mergedClasses, ImageStack imageStack) {
        int n;
        if (this.showStatus) {
            IJ.showStatus((String)"correct merged classes...");
        }
        Map<Integer, Integer> map = mergedClasses.mapToRealClasses();
        for (n = 1; n <= this.z; ++n) {
            int[] nArray = (int[])imageStack.getProcessor(n).getPixels();
            for (int i = 0; i < nArray.length; ++i) {
                int n2;
                if (nArray[i] == -1) continue;
                nArray[i] = n2 = map.get(nArray[i]).intValue();
            }
            if (!this.showStatus) continue;
            IJ.showProgress((int)n, (int)this.z);
        }
        n = mergedClasses.classes.size();
        this.classes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.classes[i] = i;
        }
    }

    public void calculateSizes() {
        if (this.showStatus) {
            IJ.showStatus((String)"calculate class sizes...");
        }
        ImageStack imageStack = this.result.getStack();
        this.sizes = new int[this.classes.length];
        for (int i = 1; i <= this.z; ++i) {
            int[] nArray = (int[])imageStack.getProcessor(i).getPixels();
            for (int j = 0; j < this.w * this.h; ++j) {
                if (nArray[j] == -1) continue;
                int n = nArray[j];
                this.sizes[n] = this.sizes[n] + 1;
            }
            if (!this.showStatus) continue;
            IJ.showProgress((int)i, (int)this.z);
        }
    }

    public void calculateIntensities(ImagePlus imagePlus) {
        if (this.showStatus) {
            IJ.showStatus((String)"calculate class intensities...");
        }
        this.intensities = new int[this.classes.length];
        ImageStack imageStack = this.result.getStack();
        ImageStack imageStack2 = imagePlus.getStack();
        for (int i = 1; i <= this.z; ++i) {
            int[] nArray = (int[])imageStack.getProcessor(i).getPixels();
            byte[] byArray = (byte[])imageStack2.getProcessor(i).getPixels();
            for (int j = 0; j < this.w * this.h; ++j) {
                if (nArray[j] == -1) continue;
                int n = nArray[j];
                this.intensities[n] = this.intensities[n] + (byArray[j] & 0xFF);
            }
            if (!this.showStatus) continue;
            IJ.showProgress((int)i, (int)this.z);
        }
    }

    private int max(int[] nArray) {
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private int classifyPixel(MergedClasses mergedClasses, byte by, int n, int n2, int n3) {
        if ((by & 0xFF) < this.threshold) {
            return -1;
        }
        boolean bl = n != -1 || n2 != -1 || n3 != -1;
        int n4 = -1;
        if (bl) {
            n4 = Math.max(Math.max(n, n2), n3);
            if (n != n4 && n != -1) {
                mergedClasses.mergeIfNecessary(n, n4);
            }
            if (n2 != n4 && n2 != -1) {
                mergedClasses.mergeIfNecessary(n2, n4);
            }
            if (n3 != n4 && n3 != -1) {
                mergedClasses.mergeIfNecessary(n3, n4);
            }
        } else {
            n4 = mergedClasses.addNewClass();
        }
        return n4;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MergedClasses {
        private List<Set<Integer>> classes = new ArrayList<Set<Integer>>();
        private int n_entries = 0;

        private MergedClasses() {
        }

        int addNewClass() {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            hashSet.add(this.n_entries);
            this.classes.add(hashSet);
            ++this.n_entries;
            return this.n_entries - 1;
        }

        void mergeIfNecessary(int n, int n2) {
            Set<Integer> set = this.getClassWhichContains(n);
            Set<Integer> set2 = this.getClassWhichContains(n2);
            if (set == null || set2 == null) {
                IJ.error((String)"Expected that both classes a and b already exist");
            }
            if (set == set2) {
                return;
            }
            set.addAll(set2);
            this.classes.remove(set2);
        }

        Set<Integer> getClassWhichContains(int n) {
            int n2 = this.getClassIndexWhichContains(n);
            if (n2 != -1) {
                return this.classes.get(n2);
            }
            return null;
        }

        int getClassIndexWhichContains(int n) {
            int n2 = 0;
            for (Set<Integer> set : this.classes) {
                if (set.contains(n)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        Map<Integer, Integer> mapToRealClasses() {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            for (int i = 0; i < this.n_entries; ++i) {
                hashMap.put(i, this.getClassIndexWhichContains(i));
            }
            return hashMap;
        }

        void print() {
            for (int i = 0; i < this.classes.size(); ++i) {
                Set<Integer> set = this.classes.get(i);
                System.out.println(i + " --> [" + this.asString(set) + "]");
            }
        }

        String asString(Set<Integer> set) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Integer n : set) {
                stringBuffer.append(n + "  ");
            }
            return stringBuffer.toString();
        }
    }

    private class Cl
    implements Comparable {
        int cl;
        int size;
        int inten;

        Cl(int n, int n2, int n3) {
            this.cl = n;
            this.size = n2;
            this.inten = n3;
        }

        public int compareTo(Object object) {
            return ((Cl)object).size - this.size;
        }
    }
}

