/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;

public class Plot_Dots
implements PlugIn,
MouseMotionListener {
    public double[] x = new double[]{0.0, 5.0, 10.0};
    public double[] y = new double[]{0.0, 5.0, 10.0};
    public String[] labels = new String[]{"p1", "p2", "p3"};
    public static final int size = 300;
    public String xLabel = "xLabel";
    public String yLabel = "yLabel";
    public static final Font FONT = new Font("SansSerif", 0, 10);
    public static final DecimalFormat DF = new DecimalFormat("#####.000");
    public static final int INDENT = 40;
    public static final int CTRL_HEIGHT = 100;
    public static boolean drawLabels = true;
    private ImageProcessor ip;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private double xdiff;
    private double ydiff;
    private double factor;
    private int w;
    private int h;
    private ImagePlus imp;
    int previous = 0;

    public void run(String string) {
    }

    public void create() {
        this.xmin = this.min(this.x);
        this.ymin = this.min(this.y);
        this.xmax = this.max(this.x);
        this.ymax = this.max(this.y);
        this.xdiff = this.xmax - this.xmin;
        this.ydiff = this.ymax - this.ymin;
        this.factor = this.xdiff > this.ydiff ? 300.0 / this.xdiff : 300.0 / this.ydiff;
        this.w = (int)(this.xdiff * this.factor);
        this.h = (int)(this.ydiff * this.factor);
        this.ip = new ByteProcessor(this.w + 80, this.h + 120 + 100);
        this.ip.setColor(255);
        this.ip.fill();
        this.drawAxis();
        this.drawPoints();
        this.imp = new ImagePlus("lkdjf", this.ip);
        this.imp.show();
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d = (double)(mouseEvent.getX() - 40) / this.factor + this.xmin;
        double d2 = (double)(this.h + 40 - mouseEvent.getY()) / this.factor + this.ymin;
        this.drawPos(d, d2);
        this.drawNearestPoint(d, d2);
        this.imp.updateAndDraw();
    }

    public int getNearestPoint(double d, double d2) {
        double d3 = Double.MAX_VALUE;
        int n = 0;
        for (int i = 0; i < this.x.length; ++i) {
            double d4 = Math.abs(d - this.x[i]) + Math.abs(d2 - this.y[i]);
            if (!(d4 < d3)) continue;
            d3 = d4;
            n = i;
        }
        return n;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouxeExited(MouseEvent mouseEvent) {
    }

    public void drawAxis() {
        this.ip.setColor(0);
        this.ip.setFont(FONT);
        this.ip.drawLine(40, this.h + 40, this.w + 40, this.h + 40);
        this.ip.drawLine(40, this.h + 40, 40, 40);
        this.ip.setJustification(1);
        this.ip.drawString(this.xLabel, this.w / 2 + 40, this.h + 80 - 3);
        ByteProcessor byteProcessor = new ByteProcessor(this.h + 80, 12);
        byteProcessor.setColor(255);
        byteProcessor.fill();
        byteProcessor.setFont(FONT);
        byteProcessor.setJustification(1);
        byteProcessor.setColor(0);
        byteProcessor.drawString(this.yLabel, this.h / 2 + 40, 12);
        byteProcessor = byteProcessor.rotateLeft();
        this.ip.insert((ImageProcessor)byteProcessor, 0, 0);
        this.drawXMarker(this.xmin);
        this.drawXMarker(this.xmax);
        this.drawXMarker(this.xmin + (this.xmax - this.xmin) / 2.0);
        this.drawYMarker(this.ymin);
        this.drawYMarker(this.ymax);
        this.drawYMarker(this.ymin + (this.ymax - this.ymin) / 2.0);
    }

    public void drawPos(double d, double d2) {
        this.ip.setColor(255);
        this.ip.setRoi(40, this.h + 80, this.w, 100);
        this.ip.fill();
        this.ip.resetRoi();
        this.ip.setColor(0);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.drawString("X pos: " + DF.format(d), 40, this.h + 80 + 20);
        this.ip.drawString("Y pos: " + DF.format(d2), 40, this.h + 80 + 35);
    }

    public void drawNearestPoint(double d, double d2) {
        this.ip.setFont(new Font("SansSerif", 1, 12));
        this.ip.drawString("Nearest point:", 40, this.h + 80 + 55);
        this.drawPoint(this.previous, 0);
        int n = this.getNearestPoint(d, d2);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.drawString("Point: " + this.labels[n], 40, this.h + 80 + 70);
        this.ip.drawString(this.xLabel + ": " + DF.format(this.x[n]), 40, this.h + 80 + 85);
        this.ip.drawString(this.yLabel + ": " + DF.format(this.y[n]), 40, this.h + 80 + 100);
        this.drawPoint(n, 100);
        this.previous = n;
    }

    public void drawXMarker(double d) {
        int n = (int)(this.factor * (d - this.xmin)) + 40;
        this.ip.drawLine(n, this.h + 40 - 2, n, this.h + 40 + 2);
        this.ip.setJustification(1);
        this.ip.drawString(DF.format(d), n, this.h + 80 - 20);
    }

    public void drawYMarker(double d) {
        int n = this.h + 40 - (int)(this.factor * (d - this.ymin));
        this.ip.drawLine(38, n, 42, n);
        this.ip.setJustification(1);
        this.ip.drawString(DF.format(d), 20, n);
    }

    public void drawPoint(int n, int n2) {
        int n3 = (int)(this.factor * (this.x[n] - this.xmin)) + 40;
        int n4 = this.h + 40 - (int)(this.factor * (this.y[n] - this.ymin));
        this.ip.setColor(n2);
        this.ip.setFont(FONT);
        this.ip.drawLine(n3 - 3, n4 - 3, n3 + 3, n4 + 3);
        this.ip.setLineWidth(2);
        this.ip.drawLine(n3 - 3, n4 + 3, n3 + 3, n4 - 3);
        if (drawLabels) {
            this.ip.drawString(this.labels[n], n3 + 4, n4 + 4);
        }
    }

    public void drawPoints() {
        this.ip.setJustification(0);
        for (int i = 0; i < this.x.length; ++i) {
            this.drawPoint(i, 0);
        }
    }

    public double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
        }
        return d;
    }

    public double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] < d)) continue;
            d = dArray[i];
        }
        return d;
    }
}

