/*
 * Decompiled with CFR 0.152.
 */
package process3d;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import process3d.Convolve_3d;

public class Smooth_
implements PlugInFilter {
    private ImagePlus image;

    public void run(ImageProcessor imageProcessor) {
        GenericDialog genericDialog = new GenericDialog("Smooth_");
        genericDialog.addChoice("Method", new String[]{"Uniform", "Gaussian"}, "Gaussian");
        genericDialog.addNumericField("sigma", 1.0, 3);
        genericDialog.addCheckbox("Use calibration", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        boolean bl = genericDialog.getNextChoice().equals("Gaussian");
        float f = (float)genericDialog.getNextNumber();
        boolean bl2 = genericDialog.getNextBoolean();
        ImagePlus imagePlus = Smooth_.smooth(this.image, bl, f, bl2);
        imagePlus.show();
    }

    public static ImagePlus smooth(ImagePlus imagePlus, boolean bl, float f, boolean bl2) {
        int n = imagePlus.getType();
        Calibration calibration = imagePlus.getCalibration();
        float f2 = !bl2 ? 1.0f : (float)Math.abs(calibration.pixelWidth);
        float[] fArray = Smooth_.createKernel(f, f2, bl);
        f2 = !bl2 ? 1.0f : (float)Math.abs(calibration.pixelHeight);
        float[] fArray2 = Smooth_.createKernel(f, f2, bl);
        f2 = !bl2 ? 1.0f : (float)Math.abs(calibration.pixelDepth);
        float[] fArray3 = Smooth_.createKernel(f, f2, bl);
        ImageStack imageStack = Convolve_3d.convolve(imagePlus, fArray, fArray2, fArray3).getStack();
        if (imagePlus.getType() == 2) {
            ImagePlus imagePlus2 = new ImagePlus("Smoothed", imageStack);
            imagePlus2.setCalibration(imagePlus.getCalibration());
            return imagePlus2;
        }
        ImageStack imageStack2 = new ImageStack(imageStack.getWidth(), imageStack.getHeight());
        for (int i = 0; i < imageStack.getSize(); ++i) {
            int n2;
            Object[] objectArray;
            float[] fArray4 = (float[])imageStack.getProcessor(i + 1).getPixels();
            if (n == 0) {
                objectArray = new byte[fArray4.length];
                for (n2 = 0; n2 < objectArray.length; ++n2) {
                    objectArray[n2] = (byte)Math.round(fArray4[n2]);
                }
                imageStack2.addSlice("", (Object)objectArray);
                continue;
            }
            if (n != 1) continue;
            objectArray = new short[fArray4.length];
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                objectArray[n2] = (short)Math.round(fArray4[n2]);
            }
            imageStack2.addSlice("", (Object)objectArray);
        }
        ImagePlus imagePlus3 = new ImagePlus("Smoothed", imageStack2);
        imagePlus3.setCalibration(imagePlus.getCalibration());
        return imagePlus3;
    }

    public static float[] createKernel(float f, float f2, boolean bl) {
        return bl ? Smooth_.createGaussianKernel(f, f2) : Smooth_.createUniformKernel(f, f2);
    }

    public static float[] createUniformKernel(float f, float f2) {
        int n = (int)Math.ceil(2.0f * (f /= f2) + 1.0f);
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = 1.0f / (float)n;
        }
        return fArray;
    }

    public static float[] createGaussianKernel(float f, float f2) {
        int n;
        int n2 = (int)Math.ceil(5.0f * (f /= f2));
        n2 = n2 % 2 == 0 ? n2 + 1 : n2;
        float[] fArray = new float[n2];
        int n3 = n2 / 2;
        float f3 = 0.0f;
        fArray[n3] = Smooth_.gauss(0.0f, f);
        f3 += fArray[n3];
        for (n = 1; n <= n3; ++n) {
            float f4 = Smooth_.gauss(n, f);
            fArray[n3 + n] = f4;
            fArray[n3 - n] = f4;
            f3 += 2.0f * fArray[n3 - n];
        }
        n = 0;
        while (n < n2) {
            int n4 = n++;
            fArray[n4] = fArray[n4] / f3;
        }
        return fArray;
    }

    public static float gauss(float f, float f2) {
        return (float)Math.exp(-f * f / (2.0f * f2 * f2));
    }

    public int setup(String string, ImagePlus imagePlus) {
        this.image = imagePlus;
        return 141;
    }
}

