/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import stacks.CropDialog;
import stacks.ThreePaneCropCanvas;
import stacks.ThreePanes;
import stacks.ThreePanesCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreePaneCrop
extends ThreePanes {
    int max_x_offscreen;
    int min_x_offscreen;
    int max_y_offscreen;
    int min_y_offscreen;
    int max_z_offscreen;
    int min_z_offscreen;
    protected int overall_min_x;
    protected int overall_max_x;
    protected int overall_min_y;
    protected int overall_max_y;
    protected int overall_min_z;
    protected int overall_max_z;
    CropDialog dialog;
    boolean changeOrigin;

    @Override
    public ThreePanesCanvas createCanvas(ImagePlus imagePlus, int n) {
        return new ThreePaneCropCanvas(imagePlus, this, n);
    }

    public void setCropAbove(double d) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        ImageStack imageStack = this.xy.getStack();
        int n7 = this.xy.getWidth();
        int n8 = this.xy.getHeight();
        int n9 = this.xy.getStackSize();
        int n10 = this.xy.getType();
        for (int i = 0; i < n9; ++i) {
            switch (n10) {
                case 0: 
                case 3: {
                    int n11;
                    int n12;
                    Object[] objectArray = (byte[])imageStack.getPixels(i + 1);
                    for (n12 = 0; n12 < n7; ++n12) {
                        for (n11 = 0; n11 < n8; ++n11) {
                            int n13 = objectArray[n11 * n7 + n12] & 0xFF;
                            if (!((double)n13 > d)) continue;
                            if (n12 < n) {
                                n = n12;
                            }
                            if (n11 < n3) {
                                n3 = n11;
                            }
                            if (i < n5) {
                                n5 = i;
                            }
                            if (n12 > n2) {
                                n2 = n12;
                            }
                            if (n11 > n4) {
                                n4 = n11;
                            }
                            if (i <= n6) continue;
                            n6 = i;
                        }
                    }
                    break;
                }
                case 1: {
                    int n11;
                    int n12;
                    Object[] objectArray = (short[])imageStack.getPixels(i + 1);
                    for (n12 = 0; n12 < n7; ++n12) {
                        for (n11 = 0; n11 < n8; ++n11) {
                            byte by = objectArray[n11 * n7 + n12];
                            if (!((double)by > d)) continue;
                            if (n12 < n) {
                                n = n12;
                            }
                            if (n11 < n3) {
                                n3 = n11;
                            }
                            if (i < n5) {
                                n5 = i;
                            }
                            if (n12 > n2) {
                                n2 = n12;
                            }
                            if (n11 > n4) {
                                n4 = n11;
                            }
                            if (i <= n6) continue;
                            n6 = i;
                        }
                    }
                }
                case 4: {
                    int n11;
                    int n12;
                    Object[] objectArray = (int[])imageStack.getPixels(i + 1);
                    for (n12 = 0; n12 < n7; ++n12) {
                        for (n11 = 0; n11 < n8; ++n11) {
                            byte by = objectArray[n11 * n7 + n12];
                            int n14 = (by & 0xFF0000) >> 16;
                            int n15 = (by & 0xFF00) >> 8;
                            int n16 = by & 0xFF;
                            int n17 = (n14 + n15 + n16) / 3;
                            if (!((double)n17 > d)) continue;
                            if (n12 < n) {
                                n = n12;
                            }
                            if (n11 < n3) {
                                n3 = n11;
                            }
                            if (i < n5) {
                                n5 = i;
                            }
                            if (n12 > n2) {
                                n2 = n12;
                            }
                            if (n11 > n4) {
                                n4 = n11;
                            }
                            if (i <= n6) continue;
                            n6 = i;
                        }
                    }
                    break;
                }
                case 2: {
                    int n11;
                    int n12;
                    Object[] objectArray = (float[])imageStack.getPixels(i + 1);
                    for (n12 = 0; n12 < n7; ++n12) {
                        for (n11 = 0; n11 < n8; ++n11) {
                            byte by = objectArray[n11 * n7 + n12];
                            if (!((double)by > d)) continue;
                            if (n12 < n) {
                                n = n12;
                            }
                            if (n11 < n3) {
                                n3 = n11;
                            }
                            if (i < n5) {
                                n5 = i;
                            }
                            if (n12 > n2) {
                                n2 = n12;
                            }
                            if (n11 > n4) {
                                n4 = n11;
                            }
                            if (i <= n6) continue;
                            n6 = i;
                        }
                    }
                    break;
                }
            }
            IJ.showProgress((double)((float)i / (float)n9));
        }
        IJ.showProgress((double)1.0);
        if (n == Integer.MAX_VALUE) {
            IJ.error((String)("There were no voxels with value greater than " + d));
            return;
        }
        this.setCropCuboid(n, n2, n3, n4, n5, n6);
        this.repaintAllPanes();
    }

    public void performMultipleCrops(ArrayList<ImagePlus> arrayList) {
        for (ImagePlus imagePlus : arrayList) {
            ImagePlus imagePlus2 = ThreePaneCrop.performCrop(imagePlus, this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen, this.changeOrigin);
            imagePlus2.show();
        }
    }

    public static ImagePlus performCrop(ImagePlus imagePlus, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        Object object;
        Object object2;
        int n7 = imagePlus.getWidth();
        int n8 = n2 - n + 1;
        int n9 = n4 - n3 + 1;
        int n10 = n5 + 1;
        int n11 = n6 + 1;
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = new ImageStack(n8, n9);
        int n12 = imagePlus.getType();
        ColorModel colorModel = null;
        if (3 == n12) {
            colorModel = imageStack.getColorModel();
        }
        switch (n12) {
            case 0: 
            case 3: {
                int n13;
                for (n13 = n10; n13 <= n11; ++n13) {
                    object2 = (byte[])imageStack.getPixels(n13);
                    object = new byte[n8 * n9];
                    for (int i = n3; i <= n4; ++i) {
                        System.arraycopy(object2, i * n7 + n, object, (i - n3) * n8, n8);
                    }
                    ByteProcessor byteProcessor = new ByteProcessor(n8, n9);
                    byteProcessor.setPixels(object);
                    imageStack2.addSlice(null, (ImageProcessor)byteProcessor);
                    IJ.showProgress((double)((n13 - n10) / (n11 - n10 + 1)));
                }
                break;
            }
            case 1: {
                int n13;
                for (n13 = n10; n13 <= n11; ++n13) {
                    object2 = (short[])imageStack.getPixels(n13);
                    object = new short[n8 * n9];
                    for (int i = n3; i <= n4; ++i) {
                        System.arraycopy(object2, i * n7 + n, object, (i - n3) * n8, n8);
                    }
                    ShortProcessor shortProcessor = new ShortProcessor(n8, n9);
                    shortProcessor.setPixels(object);
                    imageStack2.addSlice(null, (ImageProcessor)shortProcessor);
                    IJ.showProgress((double)((n13 - n10) / (n11 - n10 + 1)));
                }
                break;
            }
            case 4: {
                int n13;
                for (n13 = n10; n13 <= n11; ++n13) {
                    object2 = (int[])imageStack.getPixels(n13);
                    object = new int[n8 * n9];
                    for (int i = n3; i <= n4; ++i) {
                        System.arraycopy(object2, i * n7 + n, object, (i - n3) * n8, n8);
                    }
                    ColorProcessor colorProcessor = new ColorProcessor(n8, n9);
                    colorProcessor.setPixels(object);
                    imageStack2.addSlice(null, (ImageProcessor)colorProcessor);
                    IJ.showProgress((double)((n13 - n10) / (n11 - n10 + 1)));
                }
                break;
            }
            case 2: {
                int n13;
                for (n13 = n10; n13 <= n11; ++n13) {
                    object2 = (float[])imageStack.getPixels(n13);
                    object = new float[n8 * n9];
                    for (int i = n3; i <= n4; ++i) {
                        System.arraycopy(object2, i * n7 + n, object, (i - n3) * n8, n8);
                    }
                    FloatProcessor floatProcessor = new FloatProcessor(n8, n9);
                    floatProcessor.setPixels(object);
                    imageStack2.addSlice(null, (ImageProcessor)floatProcessor);
                    IJ.showProgress((double)((n13 - n10) / (n11 - n10 + 1)));
                }
                break;
            }
        }
        if (3 == n12 && colorModel != null) {
            imageStack2.setColorModel(colorModel);
        }
        IJ.showProgress((double)1.0);
        ImagePlus imagePlus2 = new ImagePlus("cropped " + imagePlus.getTitle(), imageStack2);
        object2 = imagePlus.getCalibration();
        if (object2 != null) {
            object = (Calibration)object2.clone();
            if (bl) {
                object.xOrigin -= (double)n;
                object.yOrigin -= (double)n3;
                object.zOrigin -= (double)n5;
            }
            if (object != null) {
                imagePlus2.setCalibration((Calibration)object);
            }
        }
        if (imagePlus.getProperty("Info") != null) {
            imagePlus2.setProperty("Info", imagePlus.getProperty("Info"));
        }
        imagePlus2.setFileInfo(imagePlus.getOriginalFileInfo());
        return imagePlus2;
    }

    public void cancel() {
        this.closeAndReset();
    }

    public void setCropCuboid(int n, int n2, int n3, int n4, int n5, int n6) {
        n = Math.max(n, this.overall_min_x);
        n3 = Math.max(n3, this.overall_min_y);
        n5 = Math.max(n5, this.overall_min_z);
        n2 = Math.min(n2, this.overall_max_x);
        n4 = Math.min(n4, this.overall_max_y);
        n6 = Math.min(n6, this.overall_max_z);
        ((ThreePaneCropCanvas)this.xy_canvas).setCropBounds(n, n2, n3, n4);
        if (!this.single_pane) {
            ((ThreePaneCropCanvas)this.xz_canvas).setCropBounds(n, n2, n5, n6);
            ((ThreePaneCropCanvas)this.zy_canvas).setCropBounds(n5, n6, n3, n4);
        }
        this.min_x_offscreen = n;
        this.max_x_offscreen = n2;
        this.min_y_offscreen = n3;
        this.max_y_offscreen = n4;
        this.min_z_offscreen = n5;
        this.max_z_offscreen = n6;
        this.dialog.updateCropBounds(this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen);
    }

    @Override
    public void initialize(ImagePlus imagePlus) {
        this.checkMemory(imagePlus, 3);
        boolean bl = imagePlus.getStackSize() == 1;
        GenericDialog genericDialog = new GenericDialog("Three Pane Crop (v1.2)");
        genericDialog.addMessage("Cropping: " + imagePlus.getTitle());
        if (!bl) {
            genericDialog.addCheckbox("Three pane view?", true);
        }
        genericDialog.addCheckbox("Change origin?", true);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        this.single_pane = bl || !genericDialog.getNextBoolean();
        this.changeOrigin = genericDialog.getNextBoolean();
        super.initialize(imagePlus);
        this.overall_min_x = 0;
        this.overall_min_y = 0;
        this.overall_min_z = 0;
        this.overall_max_x = imagePlus.getWidth() - 1;
        this.overall_max_y = imagePlus.getHeight() - 1;
        this.overall_max_z = imagePlus.getStackSize() - 1;
        this.dialog = new CropDialog("Crop Options", this);
        this.setCropCuboid(0, imagePlus.getWidth() - 1, 0, imagePlus.getHeight() - 1, 0, imagePlus.getStackSize() - 1);
    }

    public void handleDraggedTo(int n, int n2, int n3, int n4) {
        int[] nArray = new int[3];
        this.findPointInStack(n, n2, n4, nArray);
        if (n4 == 0 && n3 == 1) {
            int n5 = Math.min(nArray[0], this.max_x_offscreen);
            int n6 = Math.min(nArray[1], this.max_y_offscreen);
            this.setCropCuboid(n5, this.max_x_offscreen, n6, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen);
        } else if (n4 == 0 && n3 == 3) {
            int n7 = Math.min(nArray[0], this.max_x_offscreen);
            int n8 = Math.max(nArray[1], this.min_y_offscreen);
            this.setCropCuboid(n7, this.max_x_offscreen, this.min_y_offscreen, n8, this.min_z_offscreen, this.max_z_offscreen);
        } else if (n4 == 0 && n3 == 2) {
            int n9 = Math.max(nArray[0], this.min_x_offscreen);
            int n10 = Math.min(nArray[1], this.max_y_offscreen);
            this.setCropCuboid(this.min_x_offscreen, n9, n10, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen);
        } else if (n4 == 0 && n3 == 4) {
            int n11 = Math.max(nArray[0], this.min_x_offscreen);
            int n12 = Math.max(nArray[1], this.min_y_offscreen);
            this.setCropCuboid(this.min_x_offscreen, n11, this.min_y_offscreen, n12, this.min_z_offscreen, this.max_z_offscreen);
        } else if (n4 == 1 && n3 == 1) {
            int n13 = Math.min(nArray[0], this.max_x_offscreen);
            int n14 = Math.min(nArray[2], this.max_z_offscreen);
            this.setCropCuboid(n13, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, n14, this.max_z_offscreen);
        } else if (n4 == 1 && n3 == 2) {
            int n15 = Math.max(nArray[0], this.min_x_offscreen);
            int n16 = Math.min(nArray[2], this.max_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, n15, this.min_y_offscreen, this.max_y_offscreen, n16, this.max_z_offscreen);
        } else if (n4 == 1 && n3 == 3) {
            int n17 = Math.min(nArray[0], this.max_x_offscreen);
            int n18 = Math.max(nArray[2], this.min_z_offscreen);
            this.setCropCuboid(n17, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, n18);
        } else if (n4 == 1 && n3 == 4) {
            int n19 = Math.max(nArray[0], this.min_x_offscreen);
            int n20 = Math.max(nArray[2], this.min_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, n19, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, n20);
        } else if (n4 == 2 && n3 == 1) {
            int n21 = Math.min(nArray[1], this.max_y_offscreen);
            int n22 = Math.min(nArray[2], this.max_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, n21, this.max_y_offscreen, n22, this.max_z_offscreen);
        } else if (n4 == 2 && n3 == 2) {
            int n23 = Math.min(nArray[1], this.max_y_offscreen);
            int n24 = Math.max(nArray[2], this.min_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, n23, this.max_y_offscreen, this.min_z_offscreen, n24);
        } else if (n4 == 2 && n3 == 3) {
            int n25 = Math.max(nArray[1], this.min_y_offscreen);
            int n26 = Math.min(nArray[2], this.max_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, n25, n26, this.max_z_offscreen);
        } else if (n4 == 2 && n3 == 4) {
            int n27 = Math.max(nArray[1], this.min_y_offscreen);
            int n28 = Math.max(nArray[2], this.min_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, n27, this.min_z_offscreen, n28);
        }
        this.repaintAllPanes();
    }
}

