/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import stacks.CropHandleRectangle;
import stacks.ThreePaneCrop;
import stacks.ThreePanes;
import stacks.ThreePanesCanvas;

public class ThreePaneCropCanvas
extends ThreePanesCanvas {
    int crop_min_offscreen_x;
    int crop_max_offscreen_x;
    int crop_min_offscreen_y;
    int crop_max_offscreen_y;
    int offscreen_width;
    int offscreen_height;
    static final int HANDLE_NW = 1;
    static final int HANDLE_NE = 2;
    static final int HANDLE_SW = 3;
    static final int HANDLE_SE = 4;
    int dragging;
    int x_pressed_at;
    int y_pressed_at;
    int offset_x_in_handle;
    int offset_y_in_handle;
    CropHandleRectangle nw;
    CropHandleRectangle ne;
    CropHandleRectangle sw;
    CropHandleRectangle se;
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;

    public ThreePaneCropCanvas(ImagePlus imagePlus, ThreePanes threePanes, int n) {
        super(imagePlus, threePanes, n);
        this.offscreen_width = imagePlus.getWidth();
        this.offscreen_height = imagePlus.getHeight();
        this.crop_min_offscreen_x = 0;
        this.crop_max_offscreen_x = this.offscreen_width - 1;
        this.crop_min_offscreen_y = 0;
        this.crop_max_offscreen_y = this.offscreen_height - 1;
        this.nw = new CropHandleRectangle(n, 12, this);
        this.ne = new CropHandleRectangle(n, 12, this);
        this.sw = new CropHandleRectangle(n, 12, this);
        this.se = new CropHandleRectangle(n, 12, this);
        this.setHandlesFromBounds();
    }

    private void setHandlesFromBounds() {
        this.nw.top_left_x = this.crop_min_offscreen_x;
        this.nw.top_left_y = this.crop_min_offscreen_y;
        this.ne.top_left_x = this.crop_max_offscreen_x - this.ne.side + 1;
        this.ne.top_left_y = this.crop_min_offscreen_y;
        this.sw.top_left_x = this.crop_min_offscreen_x;
        this.sw.top_left_y = this.crop_max_offscreen_y - this.sw.side + 1;
        this.se.top_left_x = this.crop_max_offscreen_x - this.se.side + 1;
        this.se.top_left_y = this.crop_max_offscreen_y - this.se.side + 1;
    }

    public static Object newThreePanesCanvas(ImagePlus imagePlus, ThreePaneCrop threePaneCrop, int n) {
        return new ThreePaneCropCanvas(imagePlus, threePaneCrop, n);
    }

    public void setCropBounds(int n, int n2, int n3, int n4) {
        this.crop_min_offscreen_x = n;
        this.crop_max_offscreen_x = n2;
        this.crop_min_offscreen_y = n3;
        this.crop_max_offscreen_y = n4;
        this.setHandlesFromBounds();
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    public void paint(Graphics graphics) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        super.paint(this.backBufferGraphics);
        this.drawOverlay(this.backBufferGraphics);
        this.nw.draw(this.backBufferGraphics);
        this.ne.draw(this.backBufferGraphics);
        this.sw.draw(this.backBufferGraphics);
        this.se.draw(this.backBufferGraphics);
        graphics.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }

    protected void drawOverlay(Graphics graphics) {
        super.drawOverlay(graphics);
        graphics.setColor(Color.MAGENTA);
        graphics.drawLine(this.screenX(this.crop_min_offscreen_x), this.screenY(0), this.screenX(this.crop_min_offscreen_x), this.screenY(this.offscreen_height) - 1);
        graphics.drawLine(this.screenX(this.crop_max_offscreen_x + 1) - 1, this.screenY(0), this.screenX(this.crop_max_offscreen_x + 1) - 1, this.screenY(this.offscreen_height) - 1);
        graphics.drawLine(this.screenX(0), this.screenY(this.crop_min_offscreen_y), this.screenX(this.offscreen_width) - 1, this.screenY(this.crop_min_offscreen_y));
        graphics.drawLine(this.screenX(0), this.screenY(this.crop_max_offscreen_y + 1) - 1, this.screenX(this.offscreen_width) - 1, this.screenY(this.crop_max_offscreen_y + 1) - 1);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.offScreenX(mouseEvent.getX());
        int n2 = this.offScreenY(mouseEvent.getY());
        if (this.nw.pointInside(this.offScreenX(mouseEvent.getX()), this.offScreenY(mouseEvent.getY()))) {
            this.dragging = 1;
            this.offset_x_in_handle = n - this.nw.top_left_x;
            this.offset_y_in_handle = n2 - this.nw.top_left_y;
        } else if (this.ne.pointInside(this.offScreenX(mouseEvent.getX()), this.offScreenY(mouseEvent.getY()))) {
            this.dragging = 2;
            this.offset_x_in_handle = n - this.ne.top_left_x - this.ne.side;
            this.offset_y_in_handle = n2 - this.ne.top_left_y;
        } else if (this.sw.pointInside(this.offScreenX(mouseEvent.getX()), this.offScreenY(mouseEvent.getY()))) {
            this.dragging = 3;
            this.offset_x_in_handle = n - this.sw.top_left_x;
            this.offset_y_in_handle = n2 - this.sw.top_left_y - this.sw.side;
        } else if (this.se.pointInside(this.offScreenX(mouseEvent.getX()), this.offScreenY(mouseEvent.getY()))) {
            this.dragging = 4;
            this.offset_x_in_handle = n - this.se.top_left_x - this.se.side;
            this.offset_y_in_handle = n2 - this.se.top_left_y - this.se.side;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = 0;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        ((ThreePaneCrop)this.owner).handleDraggedTo(this.offScreenX(mouseEvent.getX()) - this.offset_x_in_handle, this.offScreenY(mouseEvent.getY()) - this.offset_y_in_handle, this.dragging, this.plane);
    }
}

