/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import stacks.PaneOwner;
import stacks.ThreePanesCanvas;

public class ThreePanes
implements PaneOwner {
    public static final int XY_PLANE = 0;
    public static final int XZ_PLANE = 1;
    public static final int ZY_PLANE = 2;
    protected ImagePlus xy;
    protected ImagePlus xz;
    protected ImagePlus zy;
    protected ThreePanesCanvas xy_canvas;
    protected ThreePanesCanvas xz_canvas;
    protected ThreePanesCanvas zy_canvas;
    protected ImageCanvas original_xy_canvas;
    protected StackWindow xy_window;
    protected StackWindow xz_window;
    protected StackWindow zy_window;
    protected boolean single_pane = false;
    int type;
    int bytesPerPixel;

    public void findPointInStack(int n, int n2, int n3, int[] nArray) {
        switch (n3) {
            case 0: {
                nArray[0] = n;
                nArray[1] = n2;
                nArray[2] = this.xy.getCurrentSlice() - 1;
                break;
            }
            case 1: {
                nArray[0] = n;
                nArray[1] = this.xz.getCurrentSlice() - 1;
                nArray[2] = n2;
                break;
            }
            case 2: {
                nArray[0] = this.zy.getCurrentSlice() - 1;
                nArray[1] = n2;
                nArray[2] = n;
            }
        }
    }

    public void findPointInStackPrecise(double d, double d2, int n, double[] dArray) {
        switch (n) {
            case 0: {
                dArray[0] = d;
                dArray[1] = d2;
                dArray[2] = this.xy.getCurrentSlice() - 1;
                break;
            }
            case 1: {
                dArray[0] = d;
                dArray[1] = this.xz.getCurrentSlice() - 1;
                dArray[2] = d2;
                break;
            }
            case 2: {
                dArray[0] = this.zy.getCurrentSlice() - 1;
                dArray[1] = d2;
                dArray[2] = d;
            }
        }
    }

    public ThreePanesCanvas createCanvas(ImagePlus imagePlus, int n) {
        return new ThreePanesCanvas(imagePlus, this, n);
    }

    public void mouseMovedTo(int n, int n2, int n3, boolean bl) {
        int[] nArray = new int[3];
        this.findPointInStack(n, n2, n3, nArray);
        this.xy_canvas.setCrosshairs(nArray[0], nArray[1], nArray[2], true);
        if (!this.single_pane) {
            this.xz_canvas.setCrosshairs(nArray[0], nArray[1], nArray[2], true);
            this.zy_canvas.setCrosshairs(nArray[0], nArray[1], nArray[2], true);
        }
        if (bl) {
            this.setSlicesAllPanes(nArray[0], nArray[1], nArray[2]);
        }
    }

    public void setSlicesAllPanes(int n, int n2, int n3) {
        this.xy.setSlice(n3 + 1);
        if (!this.single_pane) {
            this.xz.setSlice(n2 + 1);
            this.zy.setSlice(n + 1);
        }
    }

    public void repaintAllPanes() {
        this.xy_canvas.repaint();
        if (!this.single_pane) {
            this.xz_canvas.repaint();
            this.zy_canvas.repaint();
        }
    }

    public void closeAndReset() {
        if (!this.single_pane) {
            this.zy.close();
            this.xz.close();
        }
        if (this.original_xy_canvas != null && this.xy != null && this.xy.getImage() != null) {
            this.xy_window = new StackWindow(this.xy, this.original_xy_canvas);
        }
    }

    public void checkMemory(ImagePlus imagePlus, int n) {
        long l = imagePlus.getWidth() * imagePlus.getHeight() * imagePlus.getStackSize() * (imagePlus.getBitDepth() / 8);
        long l2 = (long)(n + 1) * l;
        System.gc();
        long l3 = Runtime.getRuntime().maxMemory();
        if (l2 > l3) {
            IJ.error((String)"Warning", (String)("It looks as if the amount of memory required for the three pane view (" + l2 / 0x100000L + "MiB) exceeds the maximum memory available (" + l3 / 0x100000L + "MiB)"));
        }
    }

    public static String imageTypeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "GRAY8 (8-bit grayscale (unsigned))";
                break;
            }
            case 1: {
                string = "GRAY16 (16-bit grayscale (unsigned))";
                break;
            }
            case 2: {
                string = "GRAY32 (32-bit floating-point grayscale)";
                break;
            }
            case 3: {
                string = "COLOR_256 (8-bit indexed color)";
                break;
            }
            case 4: {
                string = "COLOR_RGB (32-bit RGB color)";
                break;
            }
            default: {
                string = "Unknown (value: " + n + ")";
            }
        }
        return string;
    }

    public void initialize(ImagePlus imagePlus) {
        this.xy = imagePlus;
        this.type = this.xy.getType();
        this.bytesPerPixel = this.xy.getBitDepth() / 8;
        this.original_xy_canvas = imagePlus.getWindow().getCanvas();
        int n = this.xy.getWidth();
        int n2 = this.xy.getHeight();
        int n3 = this.xy.getStackSize();
        ImageStack imageStack = this.xy.getStack();
        ColorModel colorModel = null;
        if (this.type == 3) {
            colorModel = imageStack.getColorModel();
        }
        if (!this.single_pane) {
            ByteProcessor byteProcessor;
            int n4;
            Object[] objectArray;
            int n5;
            int n6 = n3;
            int n7 = n2;
            ImageStack imageStack2 = new ImageStack(n6, n7);
            int n8 = n;
            int n9 = n3;
            ImageStack imageStack3 = new ImageStack(n8, n9);
            byte[][] byArrayArray = new byte[n3][];
            int[][] nArrayArray = new int[n3][];
            float[][] fArrayArray = new float[n3][];
            short[][] sArrayArray = new short[n3][];
            block18: for (n5 = 0; n5 < n3; ++n5) {
                switch (this.type) {
                    case 0: 
                    case 3: {
                        byArrayArray[n5] = (byte[])imageStack.getPixels(n5 + 1);
                        continue block18;
                    }
                    case 1: {
                        sArrayArray[n5] = (short[])imageStack.getPixels(n5 + 1);
                        continue block18;
                    }
                    case 4: {
                        nArrayArray[n5] = (int[])imageStack.getPixels(n5 + 1);
                        continue block18;
                    }
                    case 2: {
                        fArrayArray[n5] = (float[])imageStack.getPixels(n5 + 1);
                    }
                }
            }
            IJ.showStatus((String)"Generating XZ planes...");
            IJ.showProgress((double)0.0);
            switch (this.type) {
                case 0: 
                case 3: {
                    int n10;
                    int n11;
                    for (n5 = 0; n5 < n; ++n5) {
                        objectArray = new byte[n6 * n7];
                        for (int i = 0; i < n3; ++i) {
                            for (n4 = 0; n4 < n2; ++n4) {
                                n11 = i;
                                n10 = n4;
                                objectArray[n10 * n6 + n11] = byArrayArray[i][n4 * n + n5];
                            }
                        }
                        byteProcessor = new ByteProcessor(n6, n7);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack2.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
                case 1: {
                    int n10;
                    int n11;
                    for (n5 = 0; n5 < n; ++n5) {
                        objectArray = new short[n6 * n7];
                        for (int i = 0; i < n3; ++i) {
                            for (n4 = 0; n4 < n2; ++n4) {
                                n11 = i;
                                n10 = n4;
                                objectArray[n10 * n6 + n11] = sArrayArray[i][n4 * n + n5];
                            }
                        }
                        byteProcessor = new ShortProcessor(n6, n7);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack2.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
                case 4: {
                    int n10;
                    int n11;
                    for (n5 = 0; n5 < n; ++n5) {
                        objectArray = new int[n6 * n7];
                        for (int i = 0; i < n3; ++i) {
                            for (n4 = 0; n4 < n2; ++n4) {
                                n11 = i;
                                n10 = n4;
                                objectArray[n10 * n6 + n11] = nArrayArray[i][n4 * n + n5];
                            }
                        }
                        byteProcessor = new ColorProcessor(n6, n7);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack2.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
                case 2: {
                    int n10;
                    int n11;
                    for (n5 = 0; n5 < n; ++n5) {
                        objectArray = new float[n6 * n7];
                        for (int i = 0; i < n3; ++i) {
                            for (n4 = 0; n4 < n2; ++n4) {
                                n11 = i;
                                n10 = n4;
                                objectArray[n10 * n6 + n11] = (byte)fArrayArray[i][n4 * n + n5];
                            }
                        }
                        byteProcessor = new FloatProcessor(n6, n7);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack2.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
            }
            if (this.type == 3 && colorModel != null) {
                imageStack2.setColorModel(colorModel);
            }
            IJ.showProgress((double)1.0);
            IJ.showStatus((String)"Generating ZY planes...");
            IJ.showProgress((double)0.0);
            this.zy = new ImagePlus("ZY planes of " + this.xy.getShortTitle(), imageStack2);
            switch (this.type) {
                case 0: 
                case 3: {
                    for (n5 = 0; n5 < n2; ++n5) {
                        objectArray = new byte[n8 * n9];
                        for (int i = 0; i < n3; ++i) {
                            n4 = i;
                            System.arraycopy(byArrayArray[i], n5 * n, objectArray, n4 * n8, n);
                        }
                        byteProcessor = new ByteProcessor(n8, n9);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack3.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
                case 1: {
                    for (n5 = 0; n5 < n2; ++n5) {
                        objectArray = new short[n8 * n9];
                        for (int i = 0; i < n3; ++i) {
                            n4 = i;
                            System.arraycopy(sArrayArray[i], n5 * n, objectArray, n4 * n8, n);
                        }
                        byteProcessor = new ShortProcessor(n8, n9);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack3.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
                case 4: {
                    for (n5 = 0; n5 < n2; ++n5) {
                        objectArray = new int[n8 * n9];
                        for (int i = 0; i < n3; ++i) {
                            n4 = i;
                            System.arraycopy(nArrayArray[i], n5 * n, objectArray, n4 * n8, n);
                        }
                        byteProcessor = new ColorProcessor(n8, n9);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack3.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
                case 2: {
                    for (n5 = 0; n5 < n2; ++n5) {
                        objectArray = new float[n8 * n9];
                        for (int i = 0; i < n3; ++i) {
                            n4 = i;
                            System.arraycopy(fArrayArray[i], n5 * n, objectArray, n4 * n8, n);
                        }
                        byteProcessor = new FloatProcessor(n8, n9);
                        byteProcessor.setPixels((Object)objectArray);
                        imageStack3.addSlice(null, (ImageProcessor)byteProcessor);
                        IJ.showProgress((double)((double)n5 / (double)n));
                    }
                    break;
                }
            }
            this.xz = new ImagePlus("XZ planes of " + this.xy.getShortTitle(), imageStack3);
            if (this.type == 3 && colorModel != null) {
                imageStack3.setColorModel(colorModel);
            }
            IJ.showProgress((double)1.0);
        }
        System.gc();
        this.xy_canvas = this.createCanvas(this.xy, 0);
        if (!this.single_pane) {
            this.xz_canvas = this.createCanvas(this.xz, 1);
            this.zy_canvas = this.createCanvas(this.zy, 2);
        }
        this.xy_window = new StackWindow(this.xy, (ImageCanvas)this.xy_canvas);
        if (!this.single_pane) {
            this.xz_window = new StackWindow(this.xz, (ImageCanvas)this.xz_canvas);
            this.zy_window = new StackWindow(this.zy, (ImageCanvas)this.zy_canvas);
        }
    }
}

