/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import stacks.PaneOwner;

public class ThreePanesCanvas
extends ImageCanvas {
    protected PaneOwner owner;
    protected int plane;
    private double current_x;
    private double current_y;
    private double current_z;
    boolean draw_crosshairs;

    protected ThreePanesCanvas(ImagePlus imagePlus, PaneOwner paneOwner, int n) {
        super(imagePlus);
        this.owner = paneOwner;
        this.plane = n;
    }

    protected ThreePanesCanvas(ImagePlus imagePlus, int n) {
        super(imagePlus);
        this.plane = n;
    }

    public static Object newThreePanesCanvas(ImagePlus imagePlus, PaneOwner paneOwner, int n) {
        return new ThreePanesCanvas(imagePlus, paneOwner, n);
    }

    public void setPaneOwner(PaneOwner paneOwner) {
        this.owner = paneOwner;
    }

    protected void drawOverlay(Graphics graphics) {
        if (this.draw_crosshairs) {
            int n = (int)Math.round(this.current_x);
            int n2 = (int)Math.round(this.current_y);
            int n3 = (int)Math.round(this.current_z);
            if (this.plane == 0) {
                int n4 = this.myScreenXD(this.current_x);
                int n5 = this.myScreenYD(this.current_y);
                this.drawCrosshairs(graphics, Color.red, n4, n5);
            } else if (this.plane == 1) {
                int n6 = this.myScreenXD(this.current_x);
                int n7 = this.myScreenYD(this.current_z);
                this.drawCrosshairs(graphics, Color.red, n6, n7);
            } else if (this.plane == 2) {
                int n8 = this.myScreenXD(this.current_z);
                int n9 = this.myScreenYD(this.current_y);
                this.drawCrosshairs(graphics, Color.red, n8, n9);
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.drawOverlay(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        double d = this.offScreenX(mouseEvent.getX());
        double d2 = this.offScreenY(mouseEvent.getY());
        boolean bl = (mouseEvent.getModifiersEx() & 0x40) != 0;
        this.owner.mouseMovedTo((int)d, (int)d2, this.plane, bl);
    }

    protected void drawCrosshairs(Graphics graphics, Color color, int n, int n2) {
        graphics.setColor(color);
        int n3 = 8;
        graphics.drawLine(n, n2 + 1, n, n2 + (n3 - 1));
        graphics.drawLine(n, n2 - 1, n, n2 - (n3 - 1));
        graphics.drawLine(n + 1, n2, n + (n3 - 1), n2);
        graphics.drawLine(n - 1, n2, n - (n3 - 1), n2);
    }

    public void setCrosshairs(double d, double d2, double d3, boolean bl) {
        this.current_x = d;
        this.current_y = d2;
        this.current_z = d3;
        this.draw_crosshairs = bl;
    }

    public int myOffScreenX(int n) {
        return this.srcRect.x + (int)(((double)n - this.magnification / 2.0) / this.magnification);
    }

    public int myOffScreenY(int n) {
        return this.srcRect.y + (int)(((double)n - this.magnification / 2.0) / this.magnification);
    }

    public double myOffScreenXD(int n) {
        return (double)this.srcRect.x + ((double)n - this.magnification / 2.0) / this.magnification;
    }

    public double myOffScreenYD(int n) {
        return (double)this.srcRect.y + ((double)n - this.magnification / 2.0) / this.magnification;
    }

    public int myScreenX(int n) {
        return (int)((double)(n - this.srcRect.x) * this.magnification + this.magnification / 2.0);
    }

    public int myScreenY(int n) {
        return (int)((double)(n - this.srcRect.y) * this.magnification + this.magnification / 2.0);
    }

    public int myScreenXD(double d) {
        return (int)((d - (double)this.srcRect.x) * this.magnification + this.magnification / 2.0);
    }

    public int myScreenYD(double d) {
        return (int)((d - (double)this.srcRect.y) * this.magnification + this.magnification / 2.0);
    }
}

