/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import amira.AmiraParameters;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.plugin.PlugIn;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import javax.imageio.ImageIO;
import util.BatchOpener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Unpack_To_PNG
implements PlugIn {
    public void run(String string) {
        String string2 = null;
        String string3 = Macro.getOptions();
        if (string3 == null || string3.equals("")) {
            if (string == null || string.equals("")) {
                IJ.error((String)"No parameters supplied either as macro options or a plugin argument.");
                return;
            }
            string2 = string;
        } else {
            string2 = string3;
        }
        String string4 = Macro.getValue((String)string2, (String)"filename", (String)"");
        if (string4.equals("")) {
            IJ.error((String)"No macro parameter filename supplied");
            return;
        }
        String string5 = Macro.getValue((String)string3, (String)"directory", (String)"");
        if (string5.equals("")) {
            IJ.error((String)"No macro parameter directory supplied");
            return;
        }
        ImagePlus[] imagePlusArray = BatchOpener.open(string4);
        if (imagePlusArray == null) {
            IJ.error((String)("Couldn't open the file: " + string4));
            return;
        }
        if (AmiraParameters.isAmiraLabelfield(imagePlusArray[0])) {
            System.out.println("Looks like an Amira label file...");
            try {
                this.unpackAmiraLabelFieldToPNGs(imagePlusArray[0], string5);
            }
            catch (IOException iOException) {
                IJ.error((String)("There was an IOException while unpacking the label file: " + iOException));
            }
            return;
        }
        System.out.println("Decided it doesn't look a label file, but has " + imagePlusArray.length + " channels.");
        for (int i = 0; i < imagePlusArray.length; ++i) {
            ImagePlus imagePlus = imagePlusArray[i];
            int n = imagePlus.getStackSize();
            for (int j = 0; j < n; ++j) {
                DecimalFormat decimalFormat = new DecimalFormat("00");
                DecimalFormat decimalFormat2 = new DecimalFormat("00000");
                String string6 = decimalFormat.format(i) + "-" + decimalFormat2.format(j) + ".png";
                string6 = string5 + File.separator + string6;
                try {
                    this.writeImage(imagePlus, j, string6, -1);
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Caught an exception: " + exception);
                    return;
                }
            }
        }
    }

    ArrayList<Polygon> getPolygonsNonBackground(ByteProcessor byteProcessor) {
        ShapeRoi shapeRoi;
        ArrayList<Polygon> arrayList = new ArrayList<Polygon>();
        Roi roi = this.getRoiNonBackground(byteProcessor);
        if (roi == null) {
            return arrayList;
        }
        Roi[] roiArray = null;
        if (roi.getType() == 9) {
            shapeRoi = (ShapeRoi)roi;
            roiArray = shapeRoi.getRois();
        } else if (roi.getType() == 4) {
            shapeRoi = (PolygonRoi)roi;
            roiArray = new Roi[]{shapeRoi};
        } else {
            System.out.println("Unhandled Roi type: " + roi.getType() + ", " + roi.getTypeAsString());
        }
        for (int i = 0; i < roiArray.length; ++i) {
            Polygon polygon = roiArray[i].getPolygon();
            arrayList.add(polygon);
        }
        return arrayList;
    }

    Roi getRoiNonBackground(ByteProcessor byteProcessor) {
        byteProcessor.setThreshold(1.0, 255.0, 2);
        ImageStack imageStack = new ImageStack(byteProcessor.getWidth(), byteProcessor.getHeight());
        imageStack.addSlice(null, (ImageProcessor)byteProcessor);
        ImagePlus imagePlus = new ImagePlus("example stack", imageStack);
        ThresholdToSelection thresholdToSelection = new ThresholdToSelection();
        thresholdToSelection.setup("", imagePlus);
        thresholdToSelection.run((ImageProcessor)byteProcessor);
        return imagePlus.getRoi();
    }

    public static String polygonToAreaCoords(Polygon polygon) {
        String string = "";
        double d = -1.0;
        double d2 = -1.0;
        double[] dArray = new double[6];
        boolean bl = true;
        boolean bl2 = false;
        PathIterator pathIterator = polygon.getPathIterator(null);
        while (!pathIterator.isDone()) {
            bl = false;
            int n = pathIterator.currentSegment(dArray);
            if (n == 0) {
                d = dArray[0];
                d2 = dArray[1];
                bl2 = true;
                string = string + (int)dArray[0] + ", " + (int)dArray[1] + ", ";
            } else if (n == 1) {
                string = string + (int)dArray[0] + ", " + (int)dArray[1] + ", ";
            } else {
                if (n == 4) break;
                IJ.error((String)("Unhandled PathIterator type: " + n));
                return "";
            }
            pathIterator.next();
        }
        if (bl) {
            return "";
        }
        if (d == dArray[0] && d2 == dArray[1]) {
            if (string.endsWith(", ")) {
                string = string.substring(0, string.length() - 2);
            }
        } else {
            string = string + (int)d + ", " + (int)d2;
        }
        return string;
    }

    void unpackAmiraLabelFieldToPNGs(ImagePlus imagePlus, String string) throws IOException {
        Object[] objectArray;
        if (imagePlus.getType() != 0 && imagePlus.getType() != 3) {
            IJ.error((String)"The label file appeared not to be 8 bit (!)");
            return;
        }
        AmiraParameters amiraParameters = new AmiraParameters(imagePlus);
        int n = amiraParameters.getMaterialCount();
        String[] stringArray = amiraParameters.getMaterialList();
        int n2 = imagePlus.getStackSize();
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        String string2 = string + File.separator + "material-index.js";
        PrintStream printStream = new PrintStream(string2);
        printStream.println("var materials = [");
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            objectArray = amiraParameters.getMaterialColor(i);
            byArray[i] = (byte)(objectArray[0] * 255.0);
            byArray2[i] = (byte)(objectArray[1] * 255.0);
            byArray3[i] = (byte)(objectArray[2] * 255.0);
            printStream.print("  [ \"" + amiraParameters.getMaterialName(i) + "\", [ " + (byArray[i] & 0xFF) + ", " + (byArray2[i] & 0xFF) + ", " + (byArray3[i] & 0xFF) + " ] ]");
            if (i != n - 1) {
                printStream.println(",");
                continue;
            }
            printStream.println("");
        }
        printStream.println("];");
        printStream.close();
        String string3 = string + File.separator + "dimensions.js";
        printStream = new PrintStream(string3);
        printStream.println("var stack_width = " + n3 + ";");
        printStream.println("var stack_height = " + n4 + ";");
        printStream.println("var stack_depth = " + n2 + ";");
        printStream.close();
        objectArray = new long[n];
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        byte[] byArray4 = new byte[n];
        IndexColorModel indexColorModel = new IndexColorModel(8, n, byArray, byArray2, byArray3, 0);
        String string4 = string + File.separator + "all-maps.html";
        PrintStream printStream2 = new PrintStream(string4);
        for (int i = 0; i < n2; ++i) {
            int n5;
            Object object;
            DecimalFormat decimalFormat = new DecimalFormat("00");
            DecimalFormat decimalFormat2 = new DecimalFormat("00000");
            String string5 = decimalFormat.format(0L) + "-" + decimalFormat2.format(i) + ".png";
            string5 = string + File.separator + string5;
            ImageStack imageStack = imagePlus.getStack();
            ImageProcessor imageProcessor = imageStack.getProcessor(i + 1);
            byte[] byArray5 = (byte[])imageProcessor.getPixelsCopy();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            String string6 = "<MAP NAME=\"map-" + decimalFormat2.format(i) + "\">";
            String string7 = "</MAP>";
            for (int j = 0; j < byArray5.length; ++j) {
                int n6 = byArray5[j] & 0xFF;
                object = new Integer(n6);
                hashSet.add((Integer)object);
                int n7 = n6;
                objectArray[n7] = objectArray[n7] + 1L;
                n5 = j % n3;
                int n8 = j / n3;
                int n9 = n6;
                fArray[n9] = fArray[n9] + (float)n5;
                int n10 = n6;
                fArray2[n10] = fArray2[n10] + (float)n8;
                int n11 = n6;
                fArray3[n11] = fArray3[n11] + (float)i;
            }
            printStream2.println(string6);
            Object object2 = new BufferedImage(n3, n4, 13, indexColorModel);
            String string8 = string5 + "-all.png";
            object = (Graphics2D)((BufferedImage)object2).getGraphics();
            Image image = imageProcessor.createImage();
            ((Graphics)object).drawImage(image, 0, 0, null);
            Object object3 = new File(string8);
            ImageIO.write((RenderedImage)object2, "png", (File)object3);
            object2 = new byte[byArray5.length];
            for (int j = 0; j < byArray5.length; ++j) {
                object2[j] = false;
            }
            ByteProcessor byteProcessor = new ByteProcessor(n3, n4);
            byteProcessor.setColorModel((ColorModel)indexColorModel);
            byteProcessor.setPixels(object2);
            object = string + File.separator + "map-" + decimalFormat2.format(i) + ".html";
            printStream = new PrintStream((String)object);
            for (n5 = 1; n5 < n; ++n5) {
                Object object4;
                Object object5;
                object3 = amiraParameters.getMaterialName(n5);
                DecimalFormat decimalFormat3 = new DecimalFormat("000");
                String string9 = string5 + "-" + decimalFormat3.format(n5) + "-" + (String)object3 + ".png";
                BufferedImage bufferedImage = new BufferedImage(n3, n4, 13, indexColorModel);
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                if (hashSet.contains(new Integer(n5))) {
                    object5 = new byte[byArray5.length];
                    for (int j = 0; j < byArray5.length; ++j) {
                        object5[j] = (byArray5[j] & 0xFF) == n5 ? (Object)((byte)n5) : (Object)false;
                    }
                    object4 = new byte[((Object)object5).length];
                    System.arraycopy(object5, 0, object4, 0, ((Object)object5).length);
                    ByteProcessor byteProcessor2 = new ByteProcessor(n3, n4);
                    byteProcessor2.setColorModel((ColorModel)indexColorModel);
                    byteProcessor2.setPixels(object5);
                    Image image2 = byteProcessor2.createImage();
                    graphics2D.drawImage(image2, 0, 0, null);
                    File file = new File(string9);
                    ImageIO.write((RenderedImage)bufferedImage, "png", file);
                    ArrayList<Polygon> arrayList = this.getPolygonsNonBackground(byteProcessor2);
                    for (Polygon polygon : arrayList) {
                        String string10 = "<area shape=\"poly\" alt=\"" + (String)object3 + "\" " + "coords=\"" + Unpack_To_PNG.polygonToAreaCoords(polygon) + "\" href=\"#" + (String)object3 + "-" + decimalFormat2.format(i) + "\" onclick=\"selectedArea(" + i + ",'" + (String)object3 + "')\">";
                        printStream.println(string10);
                        printStream2.println(string10);
                    }
                    continue;
                }
                object5 = byteProcessor.createImage();
                graphics2D.drawImage((Image)object5, 0, 0, null);
                object4 = new File(string9);
                ImageIO.write((RenderedImage)bufferedImage, "png", (File)object4);
            }
            printStream.close();
            printStream2.println(string7);
        }
        printStream2.close();
        String string11 = string + File.separator + "centres.js";
        printStream = new PrintStream(string11);
        printStream.println("var centres_of_gravity = [");
        for (int i = 0; i < n; ++i) {
            int n12 = i;
            fArray[n12] = fArray[n12] / (float)objectArray[i];
            int n13 = i;
            fArray2[n13] = fArray2[n13] / (float)objectArray[i];
            int n14 = i;
            fArray3[n14] = fArray3[n14] / (float)objectArray[i];
            printStream.print("[ " + (int)fArray[i] + ", " + (int)fArray2[i] + ", " + (int)fArray3[i] + " ]");
            if (i != n - 1) {
                printStream.println(",");
                continue;
            }
            printStream.println("");
        }
        printStream.println("];");
        printStream.close();
    }

    void writeImage(ImagePlus imagePlus, int n, String string, int n2) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n3 = imagePlus.getWidth();
        int n4 = imagePlus.getHeight();
        BufferedImage bufferedImage = null;
        if (imagePlus.getType() == 0 || imagePlus.getType() == 3) {
            object4 = imagePlus.createLut();
            if (object4 != null && object4.getMapSize() > 0) {
                int n5 = object4.getMapSize();
                object3 = object4.getReds();
                object2 = object4.getGreens();
                object = object4.getBlues();
                IndexColorModel indexColorModel = null;
                indexColorModel = n2 < 0 ? new IndexColorModel(8, n5, (byte[])object3, (byte[])object2, (byte[])object) : new IndexColorModel(8, n5, (byte[])object3, (byte[])object2, (byte[])object, n2);
                bufferedImage = new BufferedImage(n3, n4, 13, indexColorModel);
            } else {
                if (object4 == null && imagePlus.getType() == 3) {
                    IJ.error((String)"createLut() returned null for a COLOR_256 image");
                    return;
                }
                bufferedImage = new BufferedImage(n3, n4, 10);
            }
        } else if (imagePlus.getType() == 3) {
            object4 = imagePlus.createLut();
        } else {
            bufferedImage = new BufferedImage(n3, n4, 1);
        }
        object4 = (Graphics2D)bufferedImage.getGraphics();
        ImageStack imageStack = imagePlus.getStack();
        object3 = imageStack.getProcessor(n + 1);
        object2 = object3.createImage();
        ((Graphics)object4).drawImage((Image)object2, 0, 0, null);
        object = new File(string);
        ImageIO.write((RenderedImage)bufferedImage, "png", (File)object);
    }
}

